/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001'\t\u0011R*\u0019;dQJ+7m\\4oSj,G+Z:u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\u0012\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\r\t,gm\u001c:f)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u00026v]&$\u0018B\u0001\u001c4\u0005\u0019\u0011UMZ8sK\")\u0001\b\u0001C\u0001S\u0005YB/Z:u\u001b\u0006$8\r\u001b*fG><g.\u001b>f\u001f:\u0014vn\u001e;j[\u0016D#a\u000e\u001e\u0011\u0005IZ\u0014B\u0001\u001f4\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011A\u0015\u0002=Q,7\u000f^'bi\u000eD'+Z2pO:L'0Z(o%><H/[7f\u0019RS\u0006FA\u001f;\u0011\u0015\t\u0005\u0001\"\u0001*\u0003%\"Xm\u001d;XS:$wn\u001e+W\r>sW*\u0019;dQJ+7m\\4oSj,wJ\u001c*poRLW.\u001a'U5\"\u0012\u0001I\u000f\u0005\u0006\t\u0002!\t!K\u0001+i\u0016\u001cHo\u0014<fe^Kg\u000eZ8x\u001f:l\u0015\r^2i%\u0016\u001cwn\u001a8ju\u0016|eNU8xi&lW\r\u0014+[Q\t\u0019%\bC\u0003H\u0001\u0011\u0005\u0011&\u0001\tuKN$8)Y:dC\u0012,W*\u0019;dQ\"\u0012aI\u000f\u0005\u0006\u0015\u0002!\t!K\u0001,i\u0016\u001cH/T1uG\"\u0014vn\u001e;j[\u0016<\u0016\u000e\u001e5pkR\f%oZ;nK:$xJ\u001c*poRLW.\u001a'U5\"\u0012\u0011J\u000f\u0005\u0006\u001b\u0002!\t!K\u0001!i\u0016\u001cH/T1uG\"\u0014vn\u001e;j[\u0016<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0003J<7\u000f\u000b\u0002Mu!)\u0001\u000b\u0001C\u0001S\u0005iC/Z:u\u001b\u0006$8\r\u001b*poRLW.Z,ji\"tuN\u001c*poRKW.Z!uiJL'-\u001e;f\u0003N\f%oZ:)\u0005=S\u0004\"B*\u0001\t\u0003I\u0013\u0001\t;fgRl\u0015\r^2i%><H/[7f/&$\bNU3y\u0007\u0006dG.Q:Be\u001eD#A\u0015\u001e")
public class MatchRecognizeTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE Ticker (\n        | `symbol` STRING,\n        | `ts_ltz` TIMESTAMP_LTZ(3),\n        | `price` INT,\n        | `tax` INT,\n        | WATERMARK FOR `ts_ltz` AS `ts_ltz` - INTERVAL '1' SECOND\n        |) WITH (\n        | 'connector' = 'values'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testMatchRecognizeOnRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE Ticker1 (\n        | `symbol` STRING,\n        | `ts` TIMESTAMP(3),\n        | `price` INT,\n        | `tax` INT,\n        | WATERMARK FOR `ts` AS `ts` - INTERVAL '1' SECOND\n        |) WITH (\n        | 'connector' = 'values'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker1\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWindowTVFOnMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().registerTable("T", table);
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM TABLE(TUMBLE(TABLE T, DESCRIPTOR(matchRowtime), INTERVAL '3' second))\n         |")).stripMargin();
        this.util().verifyRelPlanWithType(sqlQuery1);
    }

    @Test
    public void testOverWindowOnMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().registerTable("T", table);
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  symbol,\n        |  price,\n        |  tax,\n        |  matchRowtime,\n        |  SUM(price) OVER (\n        |    PARTITION BY symbol ORDER BY matchRowtime RANGE UNBOUNDED PRECEDING) as price_sum\n        |FROM T\n    ")).stripMargin();
        this.util().verifyRelPlanWithType(sqlQuery1);
    }

    @Test
    public void testCascadeMatch() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM (\n         |  SELECT\n         |    symbol,\n         |    matchRowtime,\n         |    price,\n         |    TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |  FROM Ticker\n         |  MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, matchRowtime, price, TUMBLE(matchRowtime, interval '3' second)\n         |)\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY matchRowtime\n         |  MEASURES\n         |    A.price as dPrice,\n         |    A.matchRowtime as matchRowtime\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.matchRowtime >= (CURRENT_TIMESTAMP - INTERVAL '1' day)\n         |)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRowtimeWithoutArgumentOnRowtimeLTZ() {
        this.thrown().expectMessage("MATCH_ROWTIME(rowtimeField) should be used when input stream contains rowtime attribute with TIMESTAMP_LTZ type.\nPlease pass rowtime attribute field as input argument of MATCH_ROWTIME(rowtimeField) function.");
        this.thrown().expect(AssertionError.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRowtimeWithMultipleArgs() {
        this.thrown().expectMessage("Invalid number of arguments to function 'MATCH_ROWTIME'.");
        this.thrown().expect(ValidationException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz, price) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRowtimeWithNonRowTimeAttributeAsArgs() {
        this.thrown().expectMessage("The function MATCH_ROWTIME requires argument to be a row time attribute type, but is 'INTEGER'.");
        this.thrown().expect(ValidationException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(price) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRowtimeWithRexCallAsArg() {
        this.thrown().expectMessage("The function MATCH_ROWTIME requires a field reference as argument, but actual argument is not a simple field reference.");
        this.thrown().expect(ValidationException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz + INTERVAL '1' SECOND) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

