/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.FlinkBatchRuleSets$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRule$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRuleTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001'\t1b\t\\5oW\u000e\u000bGnY'fe\u001e,'+\u001e7f)\u0016\u001cHO\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0006kRLG\u000e\t\u0005\u0006Q\u0001!\t!K\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023k5\t1G\u0003\u00025!\u0005)!.\u001e8ji&\u0011ag\r\u0002\u0007\u0005\u00164wN]3\t\u000ba\u0002A\u0011A\u0015\u00027Q,7\u000f^\"bY\u000elUM]4f/&$\bnU1nK\u0012Kw-Z:uQ\t9$\b\u0005\u00023w%\u0011Ah\r\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005\u0011&\u0001\u0014uKN$8)\u00197d\u001b\u0016\u0014x-Z,ji\"tuN\u001c#fi\u0016\u0014X.\u001b8jgRL7-\u0012=qeFB#!\u0010\u001e\t\u000b\u0005\u0003A\u0011A\u0015\u0002MQ,7\u000f^\"bY\u000elUM]4f/&$\bNT8o\t\u0016$XM]7j]&\u001cH/[2FqB\u0014(\u0007\u000b\u0002Au!)A\t\u0001C\u0001S\u0005YC/Z:u\u0007\u0006d7-T3sO\u0016<\u0016\u000e\u001e5OKN$X\r\u001a(p]\u0012+G/\u001a:nS:L7\u000f^5d\u000bb\u0004(\u000f\u000b\u0002Du!)q\t\u0001C\u0001S\u0005iC/Z:u\u0007\u0006d7-T3sO\u0016<\u0016\u000e\u001e5U_BlU\u000f\u001c;j\u001d>tG)\u001a;fe6Lg.[:uS\u000e,\u0005\u0010\u001d:)\u0005\u0019S\u0004\"\u0002&\u0001\t\u0003I\u0013!\f;fgR\u001c\u0015\r\\2NKJ<W\rV8q\r&dG/\u001a:ICNtuN\u001c#fi\u0016\u0014X.\u001b8jgRL7-\u0012=qe\"\u0012\u0011J\u000f\u0005\u0006\u001b\u0002!\t!K\u00011i\u0016\u001cHoQ1mG6+'oZ3XSRD'i\u001c;u_6lU\u000f\u001c;j\u001d>tG)\u001a;fe6Lg.[:uS\u000e,\u0005\u0010\u001d:)\u00051S\u0004\"\u0002)\u0001\t\u0003I\u0013a\u000f;fgR\u001c\u0015\r\\2NKJ<WmV5uQ\n{G\u000f^8n\u001bVdG/\u001b(p]\u0012+G/\u001a:nS:L7\u000f^5d\u0013:\u001cuN\u001c3ji&|g.\u0012=qe\"\u0012qJ\u000f\u0005\u0006'\u0002!\t!K\u0001.i\u0016\u001cHoQ1mG6+'oZ3XSRDw.\u001e;J]:,'OT8o\t\u0016$XM]7j]&\u001cH/[2FqB\u0014\bF\u0001*;\u0001")
public class FlinkCalcMergeRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("table_ref", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(FlinkBatchRuleSets$.MODULE$.TABLE_REF_RULES()).build());
        programs.addLast("logical", (FlinkOptimizeProgram)FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_TO_CALC, CoreRules.PROJECT_TO_CALC, FlinkCalcMergeRule$.MODULE$.INSTANCE(), FlinkLogicalCalc$.MODULE$.CONVERTER(), FlinkLogicalLegacyTableSourceScan$.MODULE$.CONVERTER()})).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{FlinkConventions$.MODULE$.LOGICAL()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRuleTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addFunction("random_udf", new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
    }

    @Test
    public void testCalcMergeWithSameDigest() {
        this.util().verifyRelPlan("SELECT a, b FROM (SELECT * FROM MyTable WHERE a = b) t WHERE b = a");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr1() {
        String sqlQuery = "SELECT a, a1 FROM (SELECT a, random_udf(a) AS a1 FROM MyTable) t WHERE a1 > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr2() {
        String sqlQuery = "SELECT a FROM (SELECT a FROM MyTable) t WHERE random_udf(a) > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNestedNonDeterministicExpr() {
        String sqlQuery = "SELECT random_udf(a1) as a2 FROM (SELECT random_udf(a) as a1, b FROM MyTable) t WHERE b > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithTopMultiNonDeterministicExpr() {
        String sqlQuery = "SELECT random_udf(a1) as a2, random_udf(a1) as a3 FROM (SELECT random_udf(a) as a1, b FROM MyTable) t WHERE b > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeTopFilterHasNonDeterministicExpr() {
        String sqlQuery = "SELECT a, c FROM (SELECT a, random_udf(b) as b1, c FROM MyTable) t WHERE b1 > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithBottomMultiNonDeterministicExpr() {
        String sqlQuery = "SELECT a1, b2 FROM (SELECT random_udf(a) as a1, random_udf(b) as b2, c FROM MyTable) t WHERE c > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithBottomMultiNonDeterministicInConditionExpr() {
        String sqlQuery = "SELECT c FROM (SELECT random_udf(a) as a1, random_udf(b) as b2, c FROM MyTable) t WHERE a1 > b2";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithoutInnerNonDeterministicExpr() {
        String sqlQuery = "SELECT a, c FROM (SELECT a, random_udf(a) as a1, c FROM MyTable) t WHERE c > 10";
        this.util().verifyRelPlan(sqlQuery);
    }
}

