/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.abilities.source.LimitPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.spec.TemporalTableSourceSpec;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
public class TemporalTableSourceSpecSerdeTest {
    private static final FlinkTypeFactory FACTORY = new FlinkTypeFactory(TemporalTableSourceSpecSerdeTest.class.getClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
    private static final FlinkContext FLINK_CONTEXT = JsonSerdeTestUtil.configuredSerdeContext().getFlinkContext();

    public static Stream<TemporalTableSourceSpec> testTemporalTableSourceSpecSerde() {
        HashMap<String, String> options1 = new HashMap<String, String>();
        options1.put("connector", "filesystem");
        options1.put("format", "testcsv");
        options1.put("path", "/tmp");
        ResolvedSchema resolvedSchema1 = new ResolvedSchema(Collections.singletonList(Column.physical((String)"a", (DataType)DataTypes.BIGINT())), Collections.emptyList(), null);
        CatalogTable catalogTable1 = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema1).build(), null, Collections.emptyList(), options1);
        ResolvedCatalogTable resolvedCatalogTable = new ResolvedCatalogTable(catalogTable1, resolvedSchema1);
        RelDataType relDataType1 = FACTORY.createSqlType(SqlTypeName.BIGINT);
        TestValuesTableFactory.MockedLookupTableSource lookupTableSource = new TestValuesTableFactory.MockedLookupTableSource();
        TableSourceTable tableSourceTable1 = new TableSourceTable(null, relDataType1, FlinkStatistic.UNKNOWN(), (DynamicTableSource)lookupTableSource, true, ContextResolvedTable.temporary((ObjectIdentifier)ObjectIdentifier.of((String)"default_catalog", (String)"default_db", (String)"MyTable"), (ResolvedCatalogBaseTable)resolvedCatalogTable), FLINK_CONTEXT, FACTORY, new SourceAbilitySpec[]{new LimitPushDownSpec(100L)});
        TemporalTableSourceSpec temporalTableSourceSpec1 = new TemporalTableSourceSpec((RelOptTable)tableSourceTable1);
        return Stream.of(temporalTableSourceSpec1);
    }

    @ParameterizedTest
    @MethodSource(value={"testTemporalTableSourceSpecSerde"})
    public void testTemporalTableSourceSpecSerde(TemporalTableSourceSpec spec) throws IOException {
        CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        catalogManager.createTemporaryTable((CatalogBaseTable)spec.getTableSourceSpec().getContextResolvedTable().getResolvedTable(), spec.getTableSourceSpec().getContextResolvedTable().getIdentifier(), false);
        SerdeContext serdeCtx = JsonSerdeTestUtil.configuredSerdeContext(catalogManager, TableConfig.getDefault());
        String json = JsonSerdeTestUtil.toJson(serdeCtx, spec);
        TemporalTableSourceSpec actual = JsonSerdeTestUtil.toObject(serdeCtx, json, TemporalTableSourceSpec.class);
        Assertions.assertThat((Object)actual.getTableSourceSpec().getContextResolvedTable()).isEqualTo((Object)spec.getTableSourceSpec().getContextResolvedTable());
        Assertions.assertThat((List)actual.getTableSourceSpec().getSourceAbilities()).isEqualTo((Object)spec.getTableSourceSpec().getSourceAbilities());
        Assertions.assertThat((Object)actual.getOutputType()).isEqualTo((Object)spec.getOutputType());
    }
}

