/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.runtime.groupwindow.WindowReference;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
class LogicalWindowSerdeTest {
    LogicalWindowSerdeTest() {
    }

    static List<LogicalWindow> testLogicalWindowSerde() {
        return Arrays.asList(new TumblingGroupWindow(new WindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofMinutes(10L))), new TumblingGroupWindow(new WindowReference("countWindow", (LogicalType)new BigIntType()), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)10L)), new SlidingGroupWindow(new WindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofSeconds(10L)), new ValueLiteralExpression((Object)Duration.ofSeconds(5L))), new SlidingGroupWindow(new WindowReference("countWindow", (LogicalType)new BigIntType()), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)10L), new ValueLiteralExpression((Object)5L)), new SessionGroupWindow(new WindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofDays(10L))));
    }

    @ParameterizedTest
    @MethodSource(value={"testLogicalWindowSerde"})
    void testLogicalWindowSerde(LogicalWindow window) throws IOException {
        JsonSerdeTestUtil.testJsonRoundTrip(window, LogicalWindow.class);
    }
}

