/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.operator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.collection.Seq;

@RunWith(value=Parameterized.class)
public abstract class OperatorNameTestBase
extends TableTestBase {
    @Parameterized.Parameter
    public boolean isNameSimplifyEnabled;
    protected TableTestUtil util;
    protected TableEnvironment tEnv;

    @Parameterized.Parameters(name="isNameSimplifyEnabled={0}")
    public static List<Boolean> testData() {
        return Arrays.asList(true, false);
    }

    @Before
    public void setup() {
        this.util = this.getTableTestUtil();
        this.util.getStreamEnv().setParallelism(2);
        this.tEnv = this.util.getTableEnv();
        this.tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SIMPLIFY_OPERATOR_NAME_ENABLED, (Object)this.isNameSimplifyEnabled);
    }

    protected void verifyQuery(String query) {
        this.util.verifyExplain(query, (Seq<ExplainDetail>)JavaScalaConversionUtil.toScala(Collections.singletonList(ExplainDetail.JSON_EXECUTION_PLAN)));
    }

    protected void verifyInsert(String statement) {
        this.util.verifyExplainInsert(statement, (Seq<ExplainDetail>)JavaScalaConversionUtil.toScala(Collections.singletonList(ExplainDetail.JSON_EXECUTION_PLAN)));
    }

    @Test
    public void testCorrelate() {
        this.createTestSource();
        this.util.addTemporarySystemFunction("func1", (UserDefinedFunction)new TableFunc1());
        this.verifyQuery("SELECT s FROM MyTable, LATERAL TABLE(func1(c)) AS T(s)");
    }

    @Test
    public void testLookupJoin() {
        this.createSourceWithTimeAttribute();
        String srcTableB = "CREATE TABLE LookupTable (\n  id int,\n  name varchar,\n  age int \n) with (\n  'connector' = 'values',\n  'bounded' = 'true')";
        this.tEnv.executeSql(srcTableB);
        this.verifyQuery("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id");
    }

    @Test
    public void testGroupWindowAggregate() {
        this.createSourceWithTimeAttribute();
        this.verifyQuery("SELECT\n  b,\n  TUMBLE_END(rowtime, INTERVAL '15' MINUTE) as window_end,\n  COUNT(*)\nFROM MyTable\nGROUP BY b, TUMBLE(rowtime, INTERVAL '15' MINUTE)");
    }

    @Test
    public void testOverAggregate() {
        this.createSourceWithTimeAttribute();
        String sql = "SELECT b,\n    COUNT(a) OVER (PARTITION BY b ORDER BY rowtime\n        ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) AS cnt1\nFROM MyTable";
        this.verifyQuery(sql);
    }

    @Test
    public void testRank() {
        this.createTestSource();
        String sql = "SELECT a, row_num\nFROM (\n  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) as row_num\n  FROM MyTable)\nWHERE row_num <= a";
        this.verifyQuery(sql);
    }

    protected void testGroupAggregateInternal() {
        this.createTestSource();
        this.verifyQuery("SELECT a, max(b) as b FROM MyTable GROUP BY a");
    }

    protected void testJoinInternal() {
        this.createTestSource("A");
        this.createTestSource("B");
        this.verifyQuery("SELECT * from A, B where A.a = B.d");
    }

    protected void createTestSource() {
        this.createTestSource("MyTable");
    }

    protected void createTestSource(String tableName) {
        String srcTableDdl = String.format("CREATE TABLE %s (\n  a bigint,\n  b int not null,\n  c varchar,\n  d bigint not null\n) with (\n  'connector' = 'values',\n  'bounded' = 'true')", tableName);
        this.tEnv.executeSql(srcTableDdl);
    }

    protected void createSourceWithTimeAttribute() {
        this.createSourceWithTimeAttribute("MyTable");
    }

    protected void createSourceWithTimeAttribute(String name) {
        String srcTableDdl = String.format("CREATE TABLE %s (\n  a bigint,\n  b int not null,\n  c varchar,\n  d bigint not null,\n  rowtime timestamp(3),\n  proctime as proctime(),\n  watermark for rowtime AS rowtime - interval '1' second\n) with (\n  'connector' = 'values',\n  'bounded' = 'true')", name);
        this.tEnv.executeSql(srcTableDdl);
    }

    protected abstract TableTestUtil getTableTestUtil();
}

