/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001#\t\u0019c\t\\5oWJ+G.\u00143D_2,XN\\(sS\u001eLgNT;mY\u000e{WO\u001c;UKN$(BA\u0002\u0005\u0003!iW\r^1eCR\f'BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\tIb\t\\5oWJ+G.\u00143IC:$G.\u001a:UKN$()Y:f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0014\u0001!)1\u0004\u0001C\u00019\u00059C/Z:u\u000f\u0016$8i\u001c7v[:|%/[4j]:+H\u000e\\\"pk:$xJ\u001c+bE2,7kY1o)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRD#A\u0007\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dr\u0011!\u00026v]&$\u0018BA\u0015'\u0005\u0011!Vm\u001d;\t\u000b-\u0002A\u0011\u0001\u000f\u0002MQ,7\u000f^$fi\u000e{G.^7o\u001fJLw-\u001b8Ok2d7i\\;oi>s7K\\1qg\"|G\u000f\u000b\u0002+I!)a\u0006\u0001C\u00019\u0005)C/Z:u\u000f\u0016$8i\u001c7v[:|%/[4j]:+H\u000e\\\"pk:$xJ\u001c)s_*,7\r\u001e\u0015\u0003[\u0011BQ!\r\u0001\u0005\u0002q\t!\u0005^3ti\u001e+GoQ8mk6twJ]5hS:tU\u000f\u001c7D_VtGo\u00148DC2\u001c\u0007F\u0001\u0019%\u0011\u0015!\u0004\u0001\"\u0001\u001d\u0003\t\"Xm\u001d;HKR\u001cu\u000e\\;n]>\u0013\u0018nZ5o\u001dVdGnQ8v]R|eNS8j]\"\u00121\u0007\n")
public class FlinkRelMdColumnOriginNullCountTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetColumnOriginNullCountOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentFlinkLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnOriginNullCountTest.$anonfun$testGetColumnOriginNullCountOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable3"}).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getColumnOriginNullCount(ts, 0));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(ts, 1));
    }

    @Test
    public void testGetColumnOriginNullCountOnSnapshot() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.flinkLogicalSnapshot().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)this.flinkLogicalSnapshot(), idx)));
    }

    @Test
    public void testGetColumnOriginNullCountOnProject() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 0));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 1));
        Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 2));
        Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 3));
        Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 4));
        Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 5));
        Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 6));
        Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 7));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 8));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 9));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 10));
        Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)this.logicalProject(), 11));
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable3"}).build();
        this.relBuilder().push(ts);
        .colon.colon projects = new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))}), (List)new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().field(1), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)this.relBuilder().literal(null), (List)Nil$.MODULE$)))));
        RelNode project = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projects)).build();
        Assert.assertEquals(null, (Object)this.mq().getColumnOriginNullCount(project, 0));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getColumnOriginNullCount(project, 1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(project, 2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(project, 3));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getColumnOriginNullCount(project, 4));
    }

    @Test
    public void testGetColumnOriginNullCountOnCalc() {
        this.relBuilder().push((RelNode)this.studentLogicalScan());
        RexNode expr = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        Calc calc1 = this.createLogicalCalc((RelNode)this.studentLogicalScan(), this.studentLogicalScan().getRowType(), (java.util.List<RexNode>)this.relBuilder().fields(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)expr, (List)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), calc1.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertNull((Object)this.mq().getColumnOriginNullCount((RelNode)calc1, idx)));
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable3"}).build();
        this.relBuilder().push(ts);
        .colon.colon projects = new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))}), (List)new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().field(1), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)this.relBuilder().literal(null), (List)Nil$.MODULE$)))));
        RelDataType outputRowType = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projects)).build().getRowType();
        Calc calc2 = this.createLogicalCalc(ts, outputRowType, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projects), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Nil$.MODULE$));
        Assert.assertEquals(null, (Object)this.mq().getColumnOriginNullCount((RelNode)calc2, 0));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getColumnOriginNullCount((RelNode)calc2, 1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount((RelNode)calc2, 2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount((RelNode)calc2, 3));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getColumnOriginNullCount((RelNode)calc2, 4));
    }

    @Test
    public void testGetColumnOriginNullCountOnJoin() {
        RelNode innerJoin1 = this.relBuilder().scan(new String[]{"MyTable3"}).project((Iterable)this.relBuilder().fields().subList(0, 2)).scan(new String[]{"MyTable4"}).join(JoinRelType.INNER, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 1), this.relBuilder().field(2, 1, 1)})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getColumnOriginNullCount(innerJoin1, 0));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(innerJoin1, 1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(innerJoin1, 2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(innerJoin1, 3));
        RelNode innerJoin2 = this.relBuilder().scan(new String[]{"MyTable3"}).project((Iterable)this.relBuilder().fields().subList(0, 2)).scan(new String[]{"MyTable4"}).join(JoinRelType.INNER, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 0), this.relBuilder().field(2, 1, 0)})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(innerJoin2, 0));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(innerJoin2, 1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(innerJoin2, 2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.mq().getColumnOriginNullCount(innerJoin2, 3));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalLeftJoinOnUniqueKeys(), this.logicalRightJoinNotOnUniqueKeys(), this.logicalFullJoinWithEquiAndNonEquiCond(), this.logicalSemiJoinNotOnUniqueKeys(), this.logicalSemiJoinWithEquiAndNonEquiCond()})).foreach((Function1 & Serializable & scala.Serializable)join -> {
            FlinkRelMdColumnOriginNullCountTest.$anonfun$testGetColumnOriginNullCountOnJoin$1(this, join);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testGetColumnOriginNullCountOnTableScan$1(FlinkRelMdColumnOriginNullCountTest $this, TableScan scan) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)$this.mq().getColumnOriginNullCount((RelNode)scan, 0));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)$this.mq().getColumnOriginNullCount((RelNode)scan, 1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)6.0), (Object)$this.mq().getColumnOriginNullCount((RelNode)scan, 2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)$this.mq().getColumnOriginNullCount((RelNode)scan, 3));
        Assert.assertNull((Object)$this.mq().getColumnOriginNullCount((RelNode)scan, 4));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)$this.mq().getColumnOriginNullCount((RelNode)scan, 5));
        Assert.assertNull((Object)$this.mq().getColumnOriginNullCount((RelNode)scan, 6));
    }

    public static final /* synthetic */ void $anonfun$testGetColumnOriginNullCountOnJoin$1(FlinkRelMdColumnOriginNullCountTest $this, RelNode join) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), join.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertNull((Object)$this.mq().getColumnOriginNullCount(join, idx)));
    }
}

