/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.hint;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.hint.OptionsHintTest$;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalLegacySink;
import org.apache.flink.table.planner.utils.OptionsTableSink;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u0001\u0003\u0001E\u0011qb\u00149uS>t7\u000fS5oiR+7\u000f\u001e\u0006\u0003\u0007\u0011\tA\u0001[5oi*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0015\u0001\u0018M]1n!\tY\u0012J\u0004\u0002\u001d[9\u0011Q\u0004\f\b\u0003=-r!a\b\u0016\u000f\u0005\u0001JcBA\u0011)\u001d\t\u0011sE\u0004\u0002$M5\tAE\u0003\u0002&!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)aF\u0001E\u0001_\u0005yq\n\u001d;j_:\u001c\b*\u001b8u)\u0016\u001cH\u000f\u0005\u00021c5\t!AB\u0003\u0002\u0005!\u0005!g\u0005\u00022gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001aDQAO\u0019\u0005\u0002m\na\u0001P5oSRtD#A\u0018\t\u000fu\n$\u0019!C\u0001}\u0005Q\u0011jU0C\u001fVsE)\u0012#\u0016\u0003}\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\t1\fgn\u001a\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1\u0015I\u0001\u0004TiJLgn\u001a\u0005\u0007\u0011F\u0002\u000b\u0011B \u0002\u0017%\u001bvLQ(V\u001d\u0012+E\t\t\u0004\u0005\u0015F\u00025JA\u0003QCJ\fWn\u0005\u0003Jg1{\u0005C\u0001\u001bN\u0013\tqUGA\u0004Qe>$Wo\u0019;\u0011\u0005Q\u0002\u0016BA)6\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\u0019\u0016J!f\u0001\n\u0003!\u0016\u0001D;uS2\u001cV\u000f\u001d9mS\u0016\u0014X#A+\u0011\tQ2&\u0003W\u0005\u0003/V\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005MI\u0016B\u0001.\u0015\u00055!\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"AA,\u0013B\tB\u0003%Q+A\u0007vi&d7+\u001e9qY&,'\u000f\t\u0005\t=&\u0013)\u001a!C\u0001?\u0006I\u0011n\u001d\"pk:$W\rZ\u000b\u0002AB\u0011A'Y\u0005\u0003EV\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005e\u0013\nE\t\u0015!\u0003a\u0003)I7OQ8v]\u0012,G\r\t\u0005\u0006u%#\tA\u001a\u000b\u0004O&T\u0007C\u00015J\u001b\u0005\t\u0004\"B*f\u0001\u0004)\u0006\"\u00020f\u0001\u0004\u0001\u0007\"\u00027J\t\u0003j\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u00039\u0004\"a\\:\u000f\u0005A\f\bCA\u00126\u0013\t\u0011X'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\rRT!A]\u001b\t\u000fYL\u0015\u0011!C\u0001o\u0006!1m\u001c9z)\r9\u00070\u001f\u0005\b'V\u0004\n\u00111\u0001V\u0011\u001dqV\u000f%AA\u0002\u0001Dqa_%\u0012\u0002\u0013\u0005A0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003uT#!\u0016@,\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011B\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0005\r!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011C%\u0012\u0002\u0013\u0005\u00111C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)B\u000b\u0002a}\"A\u0011\u0011D%\u0002\u0002\u0013\u0005c(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\n\u0003;I\u0015\u0011!C\u0001\u0003?\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\t\u0011\u0007Q\n\u0019#C\u0002\u0002&U\u00121!\u00138u\u0011%\tI#SA\u0001\n\u0003\tY#\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00121\u0007\t\u0004i\u0005=\u0012bAA\u0019k\t\u0019\u0011I\\=\t\u0015\u0005U\u0012qEA\u0001\u0002\u0004\t\t#A\u0002yIEB\u0011\"!\u000fJ\u0003\u0003%\t%a\u000f\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0010\u0011\r\u0005}\u0012QIA\u0017\u001b\t\t\tEC\u0002\u0002DU\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9%!\u0011\u0003\u0011%#XM]1u_JD\u0011\"a\u0013J\u0003\u0003%\t!!\u0014\u0002\u0011\r\fg.R9vC2$2\u0001YA(\u0011)\t)$!\u0013\u0002\u0002\u0003\u0007\u0011Q\u0006\u0005\n\u0003'J\u0015\u0011!C!\u0003+\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003CA\u0011\"!\u0017J\u0003\u0003%\t%a\u0017\u0002\r\u0015\fX/\u00197t)\r\u0001\u0017Q\f\u0005\u000b\u0003k\t9&!AA\u0002\u00055r!CA1c\u0005\u0005\t\u0012AA2\u0003\u0015\u0001\u0016M]1n!\rA\u0017Q\r\u0004\t\u0015F\n\t\u0011#\u0001\u0002hM)\u0011QMA5\u001fB9\u00111NA9+\u0002<WBAA7\u0015\r\ty'N\u0001\beVtG/[7f\u0013\u0011\t\u0019(!\u001c\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004;\u0003K\"\t!a\u001e\u0015\u0005\u0005\r\u0004\"\u00037\u0002f\u0005\u0005IQIA>)\u0005y\u0004BCA@\u0003K\n\t\u0011\"!\u0002\u0002\u0006)\u0011\r\u001d9msR)q-a!\u0002\u0006\"11+! A\u0002UCaAXA?\u0001\u0004\u0001\u0007BCAE\u0003K\n\t\u0011\"!\u0002\f\u00069QO\\1qa2LH\u0003BAG\u00033\u0003R\u0001NAH\u0003'K1!!%6\u0005\u0019y\u0005\u000f^5p]B)A'!&VA&\u0019\u0011qS\u001b\u0003\rQ+\b\u000f\\33\u0011%\tY*a\"\u0002\u0002\u0003\u0007q-A\u0002yIAB!\"a(\u0002f\u0005\u0005I\u0011BAQ\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\u0006c\u0001!\u0002&&\u0019\u0011qU!\u0003\r=\u0013'.Z2u\u0011\u001d\tY+\rC\u0001\u0003[\u000b!\u0002]1sC6,G/\u001a:t)\t\ty\u000b\u0005\u00035\u0003c;\u0017bAAZk\t)\u0011I\u001d:bs\"B\u0011\u0011VA\\\u0003+\f9\u000e\u0005\u0003\u0002:\u0006=g\u0002BA^\u0003\u0013tA!!0\u0002D:\u0019!%a0\n\u0007\u0005\u0005g\"A\u0003kk:LG/\u0003\u0003\u0002F\u0006\u001d\u0017a\u0002:v]:,'o\u001d\u0006\u0004\u0003\u0003t\u0011\u0002BAf\u0003\u001b\fQ\u0002U1sC6,G/\u001a:ju\u0016$'\u0002BAc\u0003\u000fLA!!5\u0002T\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005-\u0017QZ\u0001\u0005]\u0006lW-\t\u0002\u0002Z\u0006a10\u001b8eKbl(\bI>1{\"1!\b\u0001C\u0001\u0003;$B!a8\u0002bB\u0011\u0001\u0007\u0001\u0005\u00073\u0005m\u0007\u0019\u0001\u000e\t\u0013\u0005\u0015\bA1A\u0005\n\u0005\u001d\u0018\u0001B;uS2,\u0012\u0001\u0017\u0005\b\u0003W\u0004\u0001\u0015!\u0003Y\u0003\u0015)H/\u001b7!\u0011!\ty\u000f\u0001b\u0001\n\u0013y\u0016AC5t?\n|WO\u001c3fI\"9\u00111\u001f\u0001!\u0002\u0013\u0001\u0017aC5t?\n|WO\u001c3fI\u0002Bq!a>\u0001\t\u0003\tI0\u0001\u0004cK\u001a|'/\u001a\u000b\u0003\u0003w\u00042\u0001NA\u007f\u0013\r\ty0\u000e\u0002\u0005+:LG\u000f\u000b\u0003\u0002v\n\r\u0001\u0003\u0002B\u0003\u0005\u000fi!!a2\n\t\t%\u0011q\u0019\u0002\u0007\u0005\u00164wN]3\t\u000f\t5\u0001\u0001\"\u0001\u0002z\u0006\tC/Z:u\u001fB$\u0018n\u001c8t/&$\bn\u00127pE\u0006d7i\u001c8g\t&\u001c\u0018M\u00197fI\"\"!1\u0002B\t!\u0011\u0011)Aa\u0005\n\t\tU\u0011q\u0019\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0003\u001a\u0001!\t!!?\u00029Q,7\u000f^%og\u0016\u0014HoV5uQ\u0012Kh.Y7jG>\u0003H/[8og\"\"!q\u0003B\t\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003s\f\u0011\u0003^3ti\u0006\u0003\b/\u001a8e\u001fB$\u0018n\u001c8tQ\u0011\u0011iB!\u0005\t\u000f\t\u0015\u0002\u0001\"\u0001\u0002z\u0006\u0019B/Z:u\u001fZ,'O]5eK>\u0003H/[8og\"\"!1\u0005B\t\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0003s\f1\u0004^3ti*{\u0017N\\,ji\"\f\u0005\u000f]3oI\u0016$w\n\u001d;j_:\u001c\b\u0006\u0002B\u0015\u0005#AqA!\r\u0001\t\u0003\tI0A\u000fuKN$(j\\5o/&$\bn\u0014<feJLG\rZ3o\u001fB$\u0018n\u001c8tQ\u0011\u0011yC!\u0005\t\u000f\t]\u0002\u0001\"\u0001\u0002z\u0006iB/Z:u\u001fB$\u0018n\u001c8t\u0011&tGo\u00148UC\ndW-\u00119j-&,w\u000f\u000b\u0003\u00036\tE\u0001b\u0002B\u001f\u0001\u0011\u0005\u0011\u0011`\u0001\u0019i\u0016\u001cHo\u00149uS>t7\u000fS5oi>s7+\u0015'WS\u0016<\b\u0006\u0002B\u001e\u0005#As\u0001\u0001B\"\u0005\u001f\u0012\t\u0006\u0005\u0003\u0003F\t-SB\u0001B$\u0015\u0011\u0011I%a2\u0002\rI,hN\\3s\u0013\u0011\u0011iEa\u0012\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012!1\u000b\t\u0005\u0005+\u00129&\u0004\u0002\u0002N&!!\u0011LAg\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u0002")
public class OptionsHintTest
extends TableTestBase {
    private final TableTestUtil util;
    private final boolean is_bounded;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Param[] parameters() {
        return OptionsHintTest$.MODULE$.parameters();
    }

    public static String IS_BOUNDED() {
        return OptionsHintTest$.MODULE$.IS_BOUNDED();
    }

    private TableTestUtil util() {
        return this.util;
    }

    private boolean is_bounded() {
        return this.is_bounded;
    }

    @Before
    public void before() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n                     |create table t1(\n                     |  a int,\n                     |  b varchar,\n                     |  c as a + 1\n                     |) with (\n                     |  'connector' = 'OPTIONS',\n                     |  '").append(OptionsHintTest$.MODULE$.IS_BOUNDED()).append("' = '").append(this.is_bounded()).append("',\n                     |  'k1' = 'v1',\n                     |  'k2' = 'v2'\n                     |)\n       ").toString())).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(356).append("\n                     |create table t2(\n                     |  d int,\n                     |  e varchar,\n                     |  f bigint\n                     |) with (\n                     |  'connector' = 'OPTIONS',\n                     |  '").append(OptionsHintTest$.MODULE$.IS_BOUNDED()).append("' = '").append(this.is_bounded()).append("',\n                     |  'k3' = 'v3',\n                     |  'k4' = 'v4'\n                     |)\n       ").toString())).stripMargin());
    }

    @Test
    public void testOptionsWithGlobalConfDisabled() {
        this.util().tableEnv().getConfig().set(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectedException().expect(Matchers.isA(ValidationException.class));
        this.expectedException().expectMessage(new StringBuilder(34).append("OPTIONS hint is allowed only when ").append(new StringBuilder(15).append(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED.key()).append(" is set to true").toString()).toString());
        this.util().verifyExecPlan("select * from t1/*+ OPTIONS(connector='COLLECTION', k2='#v2') */");
    }

    @Test
    public void testInsertWithDynamicOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |insert into t1 /*+ OPTIONS(k1='#v1', k5='v5') */\n         |select d, e from t2\n         |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        StatementSetImpl testStmtSet = (StatementSetImpl)stmtSet;
        PlannerBase plannerBase = this.util().getPlanner();
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(testStmtSet.getOperations()).map((Function1 & Serializable & scala.Serializable)modifyOperation -> plannerBase.translateToRel(modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Assert.assertThat((Object)BoxesRunTime.boxToInteger((int)relNodes.length()), (Matcher)Matchers.is((Object)BoxesRunTime.boxToInteger((int)1)));
        Predef$.MODULE$.assert(relNodes.head() instanceof LogicalLegacySink);
        LogicalLegacySink sink = (LogicalLegacySink)relNodes.head();
        Assert.assertEquals((Object)"{k1=#v1, k2=v2, k5=v5}", (Object)((OptionsTableSink)sink.sink()).props().toString());
    }

    @Test
    public void testAppendOptions() {
        this.util().verifyExecPlan("select * from t1/*+ OPTIONS(k5='v5', 'a.b.c'='fakeVal') */");
    }

    @Test
    public void testOverrideOptions() {
        this.util().verifyExecPlan("select * from t1/*+ OPTIONS(k1='#v1', k2='#v2') */");
    }

    @Test
    public void testJoinWithAppendedOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select * from\n         |t1 /*+ OPTIONS(k5='v5', 'a.b.c'='fakeVal') */\n         |join\n         |t2 /*+ OPTIONS(k6='v6', 'd.e.f'='fakeVal') */\n         |on t1.a = t2.d\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinWithOverriddenOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select * from\n         |t1 /*+ OPTIONS(k1='#v1', k2='#v2') */\n         |join\n         |t2 /*+ OPTIONS(k3='#v3', k4='#v4') */\n         |on t1.a = t2.d\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testOptionsHintOnTableApiView() {
        Table view1 = this.util().tableEnv().sqlQuery("select * from t1 join t2 on t1.a = t2.d");
        this.util().tableEnv().createTemporaryView("view1", view1);
        String sql = "select * from view1/*+ OPTIONS(k1='#v1', k2='#v2', k3='#v3', k4='#v4') */";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("View '`default_catalog`.`default_database`.`view1`' cannot be enriched with new options. Hints can only be applied to tables.") instanceof ValidationException;
    }

    @Test
    public void testOptionsHintOnSQLView() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("k1", "v1");
        props.put("k2", "v2");
        props.put("k3", "v3");
        props.put("k4", "v4");
        CatalogViewImpl view1 = new CatalogViewImpl("select * from t1 join t2 on t1.a = t2.d", "select * from t1 join t2 on t1.a = t2.d", TableSchema.builder().field("a", DataTypes.INT()).field("b", DataTypes.STRING()).field("c", DataTypes.INT()).field("d", DataTypes.INT()).field("e", DataTypes.STRING()).field("f", DataTypes.BIGINT()).build(), props, "a view table");
        Catalog catalog = (Catalog)this.util().tableEnv().getCatalog(this.util().tableEnv().getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(this.util().tableEnv().getCurrentDatabase(), "view1"), (CatalogBaseTable)view1, false);
        String sql = "select * from view1/*+ OPTIONS(k1='#v1', k2='#v2', k3='#v3', k4='#v4') */";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("View '`default_catalog`.`default_database`.`view1`' cannot be enriched with new options. Hints can only be applied to tables.") instanceof ValidationException;
    }

    public OptionsHintTest(Param param) {
        this.util = (TableTestUtil)param.utilSupplier().apply((Object)this);
        this.is_bounded = param.isBounded();
    }

    public static class Param
    implements Product,
    scala.Serializable {
        private final Function1<TableTestBase, TableTestUtil> utilSupplier;
        private final boolean isBounded;

        public Function1<TableTestBase, TableTestUtil> utilSupplier() {
            return this.utilSupplier;
        }

        public boolean isBounded() {
            return this.isBounded;
        }

        public String toString() {
            return new StringBuilder(1).append(OptionsHintTest$.MODULE$.IS_BOUNDED()).append("=").append(this.isBounded()).toString();
        }

        public Param copy(Function1<TableTestBase, TableTestUtil> utilSupplier, boolean isBounded) {
            return new Param(utilSupplier, isBounded);
        }

        public Function1<TableTestBase, TableTestUtil> copy$default$1() {
            return this.utilSupplier();
        }

        public boolean copy$default$2() {
            return this.isBounded();
        }

        public String productPrefix() {
            return "Param";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.utilSupplier();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.isBounded());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Param;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.utilSupplier()));
            n = Statics.mix((int)n, (int)(this.isBounded() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Param)) return false;
            boolean bl = true;
            if (!bl) return false;
            Param param = (Param)x$1;
            Function1<TableTestBase, TableTestUtil> function1 = this.utilSupplier();
            Function1<TableTestBase, TableTestUtil> function12 = param.utilSupplier();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (this.isBounded() != param.isBounded()) return false;
            if (!param.canEqual(this)) return false;
            return true;
        }

        public Param(Function1<TableTestBase, TableTestUtil> utilSupplier, boolean isBounded) {
            this.utilSupplier = utilSupplier;
            this.isBounded = isBounded;
            Product.$init$((Product)this);
        }
    }
}

