/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.WindowTableFunctionTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001'\t9r+\u001b8e_^$\u0016M\u00197f\rVt7\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u0011!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\naAY3g_J,G#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\t\u0002\u000b),h.\u001b;\n\u0005Y\u001a$A\u0002\"fM>\u0014X\rC\u00039\u0001\u0011\u0005\u0011&\u0001\fuKN$\u0018J\u001c<bY&$G+[7f\u0007>dG+\u001f9fQ\t9$\b\u0005\u00023w%\u0011Ah\r\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005\u0011&A\u0007uKN$H+^7cY\u0016$fK\u0012\u0015\u0003{iBQ!\u0011\u0001\u0005\u0002%\nQ\u0003^3tiR+XN\u00197f)Z3\u0005K]8di&lW\r\u000b\u0002Au!)A\t\u0001C\u0001S\u0005QA/Z:u\u0011>\u0004HK\u0016$)\u0005\rS\u0004\"B$\u0001\t\u0003I\u0013A\u0005;fgRDu\u000e\u001d+W\rB\u0013xn\u0019;j[\u0016D#A\u0012\u001e\t\u000b)\u0003A\u0011A\u0015\u0002\u001fQ,7\u000f^\"v[Vd\u0017\r^3U-\u001aC#!\u0013\u001e\t\u000b5\u0003A\u0011A\u0015\u0002/Q,7\u000f^\"v[Vd\u0017\r^3U-\u001a\u0003&o\\2uS6,\u0007F\u0001';\u0011\u0015\u0001\u0006\u0001\"\u0001*\u0003M!Xm\u001d;XS:$wn^!hOJ,w-\u0019;fQ\ty%\bC\u0003T\u0001\u0011\u0005\u0011&\u0001\u000fuKN$8)Y:dC\u0012LgnZ,j]\u0012|w/Q4he\u0016<\u0017\r^3)\u0005IS\u0004\"\u0002,\u0001\t\u0003I\u0013A\u0004;fgR<\u0016N\u001c3po*{\u0017N\u001c\u0015\u0003+jBQ!\u0017\u0001\u0005\u0002%\na\u0002^3ti^Kg\u000eZ8x%\u0006t7\u000e\u000b\u0002Yu!)A\f\u0001C\u0001S\u0005YB/Z:u!J|'.Z2u/R3EK]1ogB|7/\u001a*vY\u0016D#a\u0017\u001e")
public class WindowTableFunctionTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple4<Timestamp, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Timestamp, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<Timestamp, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((Timestamp)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.WindowTableFunctionTest$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Timestamp)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.WindowTableFunctionTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |create table MyTable2 (\n                                |  a int,\n                                |  b bigint,\n                                |  c as proctime()\n                                |) with (\n                                |  'connector' = 'COLLECTION'\n                                |)\n                                |")).stripMargin());
    }

    @Test
    public void testInvalidTimeColType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(b), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("The window function TUMBLE(TABLE table_name, DESCRIPTOR(timecol), datetime interval[, datetime interval]) requires the timecol to be TIMESTAMP or TIMESTAMP_LTZ, but is BIGINT.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testTumbleTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(c), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Processing time Window TableFunction is not supported yet.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testHopTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(HOP(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '1' HOUR, INTERVAL '2' HOUR))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testHopTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(HOP(TABLE MyTable2, DESCRIPTOR(c), INTERVAL '1' HOUR, INTERVAL '2' HOUR))\n        |")).stripMargin();
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Processing time Window TableFunction is not supported yet.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testCumulateTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testCumulateTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable2, DESCRIPTOR(c), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Processing time Window TableFunction is not supported yet.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  a,\n        |  MAX(c)\n        |FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '3' SECOND))\n        |GROUP BY window_start, window_end, a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testCascadingWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, b, SUM(cnt)\n        |FROM (\n        |  SELECT\n        |    window_start, window_end, a, b, COUNT(1) AS cnt\n        |  FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '3' SECOND))\n        |  GROUP BY window_start, window_end, a, b\n        |)\n        |GROUP BY window_start, window_end, b\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(ts), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowRank() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |SELECT *,\n        |  RANK() OVER(PARTITION BY a, window_start, window_end ORDER BY b) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(ts), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testProjectWTFTransposeRule() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  MAX(c)\n        |FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '3' SECOND))\n        |GROUP BY window_start, window_end, a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }
}

