/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.dql.SqlRichExplain;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.factories.TestManagedTableFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.operations.BeginStatementSetOperation;
import org.apache.flink.table.operations.EndStatementSetOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.LoadModuleOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowModulesOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.table.operations.UnloadModuleOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.UseModulesOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.ClearOperation;
import org.apache.flink.table.operations.command.HelpOperation;
import org.apache.flink.table.operations.command.QuitOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterTableAddConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableDropConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableOptionsOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.Func8$;
import org.apache.flink.table.planner.operations.SqlToOperationConverter;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.parse.ExtendedParser;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.OperationMatchers;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.table.utils.ExpressionResolverMocks;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SqlToOperationConverterTest {
    private final boolean isStreamingMode = false;
    private final TableConfig tableConfig = TableConfig.getDefault();
    private final Catalog catalog = new GenericInMemoryCatalog("MockCatalog", "default");
    private final CatalogManager catalogManager = CatalogManagerMocks.preparedCatalogManager().defaultCatalog("builtin", this.catalog).config((ReadableConfig)Configuration.fromMap(Collections.singletonMap(ExecutionOptions.RUNTIME_MODE.key(), RuntimeExecutionMode.BATCH.name()))).build();
    private final PlannerMocks plannerMocks = PlannerMocks.newBuilder().withBatchMode(true).withTableConfig(this.tableConfig).withCatalogManager(this.catalogManager).withRootSchema(CalciteSchemaBuilder.asRootSchema((Schema)new CatalogManagerCalciteSchema(this.catalogManager, false))).build();
    private final PlannerContext plannerContext = this.plannerMocks.getPlannerContext();
    private final FunctionCatalog functionCatalog = this.plannerMocks.getFunctionCatalog();
    private final Supplier<FlinkPlannerImpl> plannerSupplier = () -> ((PlannerContext)this.plannerContext).createFlinkPlanner();
    private final Parser parser = new ParserImpl(this.catalogManager, this.plannerSupplier, () -> this.plannerSupplier.get().parser(), this.plannerContext.getRexFactory());

    @BeforeEach
    public void before() throws TableAlreadyExistException, DatabaseNotExistException {
        this.catalogManager.initSchemaResolver(false, ExpressionResolverMocks.basicResolver((CatalogManager)this.catalogManager, (FunctionCatalog)this.functionCatalog, (Parser)this.parser));
        ObjectPath path1 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t1");
        ObjectPath path2 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t2");
        TableSchema tableSchema = TableSchema.builder().field("a", DataTypes.BIGINT()).field("b", DataTypes.VARCHAR((int)Integer.MAX_VALUE)).field("c", DataTypes.INT()).field("d", DataTypes.VARCHAR((int)Integer.MAX_VALUE)).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "COLLECTION");
        CatalogTableImpl catalogTable = new CatalogTableImpl(tableSchema, options, "");
        this.catalog.createTable(path1, (CatalogBaseTable)catalogTable, true);
        this.catalog.createTable(path2, (CatalogBaseTable)catalogTable, true);
    }

    @AfterEach
    public void after() throws TableNotExistException {
        ObjectPath path1 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t1");
        ObjectPath path2 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t2");
        this.catalog.dropTable(path1, true);
        this.catalog.dropTable(path2, true);
    }

    @Test
    public void testUseCatalog() {
        String sql = "USE CATALOG cat1";
        Operation operation = this.parse("USE CATALOG cat1", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(UseCatalogOperation.class);
        Assertions.assertThat((String)((UseCatalogOperation)operation).getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("USE CATALOG cat1");
    }

    @Test
    public void testUseDatabase() {
        String sql1 = "USE db1";
        Operation operation1 = this.parse("USE db1", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation1).isInstanceOf(UseDatabaseOperation.class);
        Assertions.assertThat((String)((UseDatabaseOperation)operation1).getCatalogName()).isEqualTo("builtin");
        Assertions.assertThat((String)((UseDatabaseOperation)operation1).getDatabaseName()).isEqualTo("db1");
        String sql2 = "USE cat1.db1";
        Operation operation2 = this.parse("USE cat1.db1", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation2).isInstanceOf(UseDatabaseOperation.class);
        Assertions.assertThat((String)((UseDatabaseOperation)operation2).getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)((UseDatabaseOperation)operation2).getDatabaseName()).isEqualTo("db1");
    }

    @Test
    public void testUseDatabaseWithException() {
        String sql = "USE cat1.db1.tbl1";
        Assertions.assertThatThrownBy(() -> this.parse("USE cat1.db1.tbl1", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class);
    }

    @Test
    public void testCreateDatabase() {
        String[] createDatabaseSqls = new String[]{"create database db1", "create database if not exists cat1.db1", "create database cat1.db1 comment 'db1_comment'", "create database cat1.db1 comment 'db1_comment' with ('k1' = 'v1', 'K2' = 'V2')"};
        String[] expectedCatalogs = new String[]{"builtin", "cat1", "cat1", "cat1"};
        String expectedDatabase = "db1";
        String[] expectedComments = new String[]{null, null, "db1_comment", "db1_comment"};
        boolean[] expectedIgnoreIfExists = new boolean[]{false, true, false, false};
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("k1", "v1");
        properties.put("K2", "V2");
        Map[] expectedProperties = new Map[]{new HashMap(), new HashMap(), new HashMap(), new HashMap(properties)};
        for (int i = 0; i < createDatabaseSqls.length; ++i) {
            Operation operation = this.parse(createDatabaseSqls[i], SqlDialect.DEFAULT);
            Assertions.assertThat((Object)operation).isInstanceOf(CreateDatabaseOperation.class);
            CreateDatabaseOperation createDatabaseOperation = (CreateDatabaseOperation)operation;
            Assertions.assertThat((String)createDatabaseOperation.getCatalogName()).isEqualTo(expectedCatalogs[i]);
            Assertions.assertThat((String)createDatabaseOperation.getDatabaseName()).isEqualTo("db1");
            Assertions.assertThat((String)createDatabaseOperation.getCatalogDatabase().getComment()).isEqualTo(expectedComments[i]);
            Assertions.assertThat((boolean)createDatabaseOperation.isIgnoreIfExists()).isEqualTo(expectedIgnoreIfExists[i]);
            Assertions.assertThat((Map)createDatabaseOperation.getCatalogDatabase().getProperties()).isEqualTo((Object)expectedProperties[i]);
        }
    }

    @Test
    public void testDropDatabase() {
        String[] dropDatabaseSqls = new String[]{"drop database db1", "drop database if exists db1", "drop database if exists cat1.db1 CASCADE", "drop database if exists cat1.db1 RESTRICT"};
        String[] expectedCatalogs = new String[]{"builtin", "builtin", "cat1", "cat1"};
        String expectedDatabase = "db1";
        boolean[] expectedIfExists = new boolean[]{false, true, true, true};
        boolean[] expectedIsCascades = new boolean[]{false, false, true, false};
        for (int i = 0; i < dropDatabaseSqls.length; ++i) {
            Operation operation = this.parse(dropDatabaseSqls[i], SqlDialect.DEFAULT);
            Assertions.assertThat((Object)operation).isInstanceOf(DropDatabaseOperation.class);
            DropDatabaseOperation dropDatabaseOperation = (DropDatabaseOperation)operation;
            Assertions.assertThat((String)dropDatabaseOperation.getCatalogName()).isEqualTo(expectedCatalogs[i]);
            Assertions.assertThat((String)dropDatabaseOperation.getDatabaseName()).isEqualTo("db1");
            Assertions.assertThat((boolean)dropDatabaseOperation.isIfExists()).isEqualTo(expectedIfExists[i]);
            Assertions.assertThat((boolean)dropDatabaseOperation.isCascade()).isEqualTo(expectedIsCascades[i]);
        }
    }

    @Test
    public void testAlterDatabase() throws Exception {
        this.catalogManager.registerCatalog("cat1", (Catalog)new GenericInMemoryCatalog("default", "default"));
        ((Catalog)this.catalogManager.getCatalog("cat1").get()).createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), "db1_comment"), true);
        String sql = "alter database cat1.db1 set ('k1'='v1', 'K2'='V2')";
        Operation operation = this.parse("alter database cat1.db1 set ('k1'='v1', 'K2'='V2')", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(AlterDatabaseOperation.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("k1", "v1");
        properties.put("K2", "V2");
        AlterDatabaseOperation alterDatabaseOperation = (AlterDatabaseOperation)operation;
        Assertions.assertThat((String)alterDatabaseOperation.getDatabaseName()).isEqualTo("db1");
        Assertions.assertThat((String)alterDatabaseOperation.getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)alterDatabaseOperation.getCatalogDatabase().getComment()).isEqualTo("db1_comment");
        Assertions.assertThat((Map)alterDatabaseOperation.getCatalogDatabase().getProperties()).isEqualTo(properties);
    }

    @Test
    public void testLoadModule() {
        String sql = "LOAD MODULE dummy WITH ('k1' = 'v1', 'k2' = 'v2')";
        String expectedModuleName = "dummy";
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("k1", "v1");
        expectedOptions.put("k2", "v2");
        Operation operation = this.parse("LOAD MODULE dummy WITH ('k1' = 'v1', 'k2' = 'v2')", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(LoadModuleOperation.class);
        LoadModuleOperation loadModuleOperation = (LoadModuleOperation)operation;
        Assertions.assertThat((String)loadModuleOperation.getModuleName()).isEqualTo("dummy");
        Assertions.assertThat((Map)loadModuleOperation.getOptions()).isEqualTo(expectedOptions);
    }

    @Test
    public void testUnloadModule() {
        String sql = "UNLOAD MODULE dummy";
        String expectedModuleName = "dummy";
        Operation operation = this.parse("UNLOAD MODULE dummy", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(UnloadModuleOperation.class);
        UnloadModuleOperation unloadModuleOperation = (UnloadModuleOperation)operation;
        Assertions.assertThat((String)unloadModuleOperation.getModuleName()).isEqualTo("dummy");
    }

    @Test
    public void testUseOneModule() {
        String sql = "USE MODULES dummy";
        List<String> expectedModuleNames = Collections.singletonList("dummy");
        Operation operation = this.parse("USE MODULES dummy", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(UseModulesOperation.class);
        UseModulesOperation useModulesOperation = (UseModulesOperation)operation;
        Assertions.assertThat((List)useModulesOperation.getModuleNames()).isEqualTo(expectedModuleNames);
        Assertions.assertThat((String)useModulesOperation.asSummaryString()).isEqualTo("USE MODULES: [dummy]");
    }

    @Test
    public void testUseMultipleModules() {
        String sql = "USE MODULES x, y, z";
        List<String> expectedModuleNames = Arrays.asList("x", "y", "z");
        Operation operation = this.parse("USE MODULES x, y, z", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(UseModulesOperation.class);
        UseModulesOperation useModulesOperation = (UseModulesOperation)operation;
        Assertions.assertThat((List)useModulesOperation.getModuleNames()).isEqualTo(expectedModuleNames);
        Assertions.assertThat((String)useModulesOperation.asSummaryString()).isEqualTo("USE MODULES: [x, y, z]");
    }

    @Test
    public void testShowModules() {
        String sql = "SHOW MODULES";
        Operation operation = this.parse("SHOW MODULES", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(ShowModulesOperation.class);
        ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
        Assertions.assertThat((boolean)showModulesOperation.requireFull()).isFalse();
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW MODULES");
    }

    @Test
    public void testShowTables() {
        String sql = "SHOW TABLES from cat1.db1 not like 't%'";
        Operation operation = this.parse("SHOW TABLES from cat1.db1 not like 't%'", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(ShowTablesOperation.class);
        ShowTablesOperation showTablesOperation = (ShowTablesOperation)operation;
        Assertions.assertThat((String)showTablesOperation.getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)showTablesOperation.getDatabaseName()).isEqualTo("db1");
        Assertions.assertThat((String)showTablesOperation.getPreposition()).isEqualTo("FROM");
        Assertions.assertThat((boolean)showTablesOperation.isUseLike()).isTrue();
        Assertions.assertThat((boolean)showTablesOperation.isNotLike()).isTrue();
        String sql2 = "SHOW TABLES in db2";
        showTablesOperation = (ShowTablesOperation)this.parse("SHOW TABLES in db2", SqlDialect.DEFAULT);
        Assertions.assertThat((String)showTablesOperation.getCatalogName()).isEqualTo("builtin");
        Assertions.assertThat((String)showTablesOperation.getDatabaseName()).isEqualTo("db2");
        Assertions.assertThat((String)showTablesOperation.getPreposition()).isEqualTo("IN");
        Assertions.assertThat((boolean)showTablesOperation.isUseLike()).isFalse();
        Assertions.assertThat((boolean)showTablesOperation.isNotLike()).isFalse();
        String sql3 = "SHOW TABLES";
        showTablesOperation = (ShowTablesOperation)this.parse("SHOW TABLES", SqlDialect.DEFAULT);
        Assertions.assertThat((String)showTablesOperation.getCatalogName()).isNull();
        Assertions.assertThat((String)showTablesOperation.getDatabaseName()).isNull();
        Assertions.assertThat((String)showTablesOperation.getPreposition()).isNull();
    }

    @Test
    public void testShowFullModules() {
        String sql = "SHOW FULL MODULES";
        Operation operation = this.parse("SHOW FULL MODULES", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(ShowModulesOperation.class);
        ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
        Assertions.assertThat((boolean)showModulesOperation.requireFull()).isTrue();
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW FULL MODULES");
    }

    @Test
    public void testShowFunctions() {
        String sql1 = "SHOW FUNCTIONS";
        this.assertShowFunctions("SHOW FUNCTIONS", "SHOW FUNCTIONS", ShowFunctionsOperation.FunctionScope.ALL);
        String sql2 = "SHOW USER FUNCTIONS";
        this.assertShowFunctions("SHOW USER FUNCTIONS", "SHOW USER FUNCTIONS", ShowFunctionsOperation.FunctionScope.USER);
    }

    @Test
    public void testCreateTable() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar)\n  PARTITIONED BY (a, d)\n  with (\n    'connector' = 'kafka', \n    'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar)\n  PARTITIONED BY (a, d)\n  with (\n    'connector' = 'kafka', \n    'kafka.topic' = 'log.test'\n)\n", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(CreateTableOperation.class);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        Assertions.assertThat((List)catalogTable.getPartitionKeys()).hasSameElementsAs(Arrays.asList("a", "d"));
        Assertions.assertThat((Object[])catalogTable.getSchema().getFieldNames()).isEqualTo((Object)new String[]{"a", "b", "c", "d"});
        Assertions.assertThat((Object[])catalogTable.getSchema().getFieldDataTypes()).isEqualTo((Object)new DataType[]{DataTypes.BIGINT(), DataTypes.VARCHAR((int)Integer.MAX_VALUE), DataTypes.INT(), DataTypes.VARCHAR((int)Integer.MAX_VALUE)});
    }

    @Test
    public void testCreateTableWithPrimaryKey() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 primary key(a, b) not enforced\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 primary key(a, b) not enforced\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(CreateTableOperation.class);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        TableSchema tableSchema = catalogTable.getSchema();
        Assertions.assertThat((String)tableSchema.getPrimaryKey().map(UniqueConstraint::asSummaryString).orElse("fakeVal")).isEqualTo("CONSTRAINT ct1 PRIMARY KEY (a, b)");
        Assertions.assertThat((Object[])tableSchema.getFieldNames()).isEqualTo((Object)new String[]{"a", "b", "c", "d"});
        Assertions.assertThat((Object[])tableSchema.getFieldDataTypes()).isEqualTo((Object)new DataType[]{(DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.STRING().notNull(), DataTypes.INT(), DataTypes.STRING()});
    }

    @Test
    public void testCreateTableWithPrimaryKeyEnforced() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 primary key(a, b)\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 primary key(a, b)\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n", planner, parser)).isInstanceOf(ValidationException.class)).hasMessageContaining("Flink doesn't support ENFORCED mode for PRIMARY KEY constraint. ENFORCED/NOT ENFORCED  controls if the constraint checks are performed on the incoming/outgoing data. Flink does not own the data therefore the only supported mode is the NOT ENFORCED mode");
    }

    @Test
    public void testCreateTableWithUniqueKey() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 unique (a, b) not enforced\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE TABLE tbl1 (\n  a bigint,\n  b varchar, \n  c int, \n  d varchar, \n  constraint ct1 unique (a, b) not enforced\n) with (\n  'connector' = 'kafka', \n  'kafka.topic' = 'log.test'\n)\n", planner, parser)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("UNIQUE constraint is not supported yet");
    }

    @Test
    public void testPrimaryKeyOnGeneratedColumn() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint not null,\n  b varchar not null,\n  c as 2 * (a + 1),\n  constraint ct1 primary key (b, c) not enforced) with (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("CREATE TABLE tbl1 (\n  a bigint not null,\n  b varchar not null,\n  c as 2 * (a + 1),\n  constraint ct1 primary key (b, c) not enforced) with (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n")).isInstanceOf(ValidationException.class)).hasMessageContaining("Could not create a PRIMARY KEY with column 'c' at line 5, column 34.\nA PRIMARY KEY constraint must be declared on physical columns.");
    }

    @Test
    public void testPrimaryKeyNonExistentColumn() {
        String sql = "CREATE TABLE tbl1 (\n  a bigint not null,\n  b varchar not null,\n  c as 2 * (a + 1),\n  constraint ct1 primary key (b, d) not enforced) with (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("CREATE TABLE tbl1 (\n  a bigint not null,\n  b varchar not null,\n  c as 2 * (a + 1),\n  constraint ct1 primary key (b, d) not enforced) with (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n")).isInstanceOf(ValidationException.class)).hasMessageContaining("Primary key column 'd' is not defined in the schema at line 5, column 34");
    }

    @Test
    public void testCreateTableWithMinusInOptionKey() {
        String sql = "create table source_table(\n  a int,\n  b bigint,\n  c varchar\n) with (\n  'a-B-c-d124' = 'Ab',\n  'a.b-c-d.e-f.g' = 'ada',\n  'a.b-c-d.e-f1231.g' = 'ada',\n  'a.b-c-d.*' = 'adad')\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse("create table source_table(\n  a int,\n  b bigint,\n  c varchar\n) with (\n  'a-B-c-d124' = 'Ab',\n  'a.b-c-d.e-f.g' = 'ada',\n  'a.b-c-d.e-f1231.g' = 'ada',\n  'a.b-c-d.*' = 'adad')\n");
        Assertions.assertThat((Object)node).isInstanceOf(SqlCreateTable.class);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        Assertions.assertThat((Object)operation).isInstanceOf(CreateTableOperation.class);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        Map<String, String> options = catalogTable.getOptions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>(options);
        String expected = "{a-B-c-d124=Ab, a.b-c-d.*=adad, a.b-c-d.e-f.g=ada, a.b-c-d.e-f1231.g=ada}";
        Assertions.assertThat((String)((Object)sortedProperties).toString()).isEqualTo("{a-B-c-d124=Ab, a.b-c-d.*=adad, a.b-c-d.e-f.g=ada, a.b-c-d.e-f1231.g=ada}");
    }

    @Test
    public void testExplainWithSelect() {
        String sql = "explain select * from t1";
        this.checkExplainSql("explain select * from t1");
    }

    @Test
    public void testExplainWithInsert() {
        String sql = "explain insert into t2 select * from t1";
        this.checkExplainSql("explain insert into t2 select * from t1");
    }

    @Test
    public void testExplainWithUnion() {
        String sql = "explain select * from t1 union select * from t2";
        this.checkExplainSql("explain select * from t1 union select * from t2");
    }

    @Test
    public void testExplainWithExplainDetails() {
        String sql = "explain changelog_mode, estimated_cost, json_execution_plan select * from t1";
        this.checkExplainSql(sql);
    }

    @Test
    public void testCreateTableWithWatermark() throws FunctionAlreadyExistException, DatabaseNotExistException {
        CatalogFunctionImpl cf = new CatalogFunctionImpl(JavaUserDefinedScalarFunctions.JavaFunc5.class.getName());
        this.catalog.createFunction(ObjectPath.fromString((String)"default.myfunc"), (CatalogFunction)cf, true);
        String sql = "create table source_table(\n  a int,\n  b bigint,\n  c timestamp(3),\n  watermark for `c` as myfunc(c, 1) - interval '5' second\n) with (\n  'connector.type' = 'kafka')\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse("create table source_table(\n  a int,\n  b bigint,\n  c timestamp(3),\n  watermark for `c` as myfunc(c, 1) - interval '5' second\n) with (\n  'connector.type' = 'kafka')\n");
        Assertions.assertThat((Object)node).isInstanceOf(SqlCreateTable.class);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        Assertions.assertThat((Object)operation).isInstanceOf(CreateTableOperation.class);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        Map properties = catalogTable.toProperties();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("schema.0.name", "a");
        expected.put("schema.0.data-type", "INT");
        expected.put("schema.1.name", "b");
        expected.put("schema.1.data-type", "BIGINT");
        expected.put("schema.2.name", "c");
        expected.put("schema.2.data-type", "TIMESTAMP(3)");
        expected.put("schema.watermark.0.rowtime", "c");
        expected.put("schema.watermark.0.strategy.expr", "`builtin`.`default`.`myfunc`(`c`, 1) - INTERVAL '5' SECOND");
        expected.put("schema.watermark.0.strategy.data-type", "TIMESTAMP(3)");
        expected.put("connector.type", "kafka");
        Assertions.assertThat((Map)properties).isEqualTo(expected);
    }

    @Test
    public void testBasicCreateTableLike() {
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        sourceProperties.put("format.type", "json");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build(), null, Collections.emptyList(), sourceProperties);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nPARTITIONED BY (a, f0)\nwith (\n  'connector.type' = 'kafka')\nlike sourceTable";
        Operation operation = this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nPARTITIONED BY (a, f0)\nwith (\n  'connector.type' = 'kafka')\nlike sourceTable");
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withSchema(org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).column("a", (AbstractDataType)DataTypes.INT()).watermark("f1", "`f1` - INTERVAL '5' SECOND").build()), OperationMatchers.withOptions(OperationMatchers.entry("connector.type", "kafka"), OperationMatchers.entry("format.type", "json")), OperationMatchers.partitionedBy("a", "f0"))));
    }

    @Test
    public void testCreateTableLikeWithFullPath() {
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        sourceProperties.put("connector.type", "kafka");
        sourceProperties.put("format.type", "json");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build(), null, Collections.emptyList(), sourceProperties);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table mytable like `builtin`.`default`.sourceTable";
        Operation operation = this.parseAndConvert("create table mytable like `builtin`.`default`.sourceTable");
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withSchema(org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build()), OperationMatchers.withOptions(OperationMatchers.entry("connector.type", "kafka"), OperationMatchers.entry("format.type", "json")))));
    }

    @Test
    public void testMergingCreateTableLike() {
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        sourceProperties.put("format.type", "json");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).columnByExpression("f2", "`f0` + 12345").watermark("f1", "`f1` - interval '1' second").build(), null, Arrays.asList("f0", "f1"), sourceProperties);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nPARTITIONED BY (a, f0)\nwith (\n  'connector.type' = 'kafka')\nlike sourceTable (\n   EXCLUDING GENERATED\n   EXCLUDING PARTITIONS\n   OVERWRITING OPTIONS\n   OVERWRITING WATERMARKS)";
        Operation operation = this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nPARTITIONED BY (a, f0)\nwith (\n  'connector.type' = 'kafka')\nlike sourceTable (\n   EXCLUDING GENERATED\n   EXCLUDING PARTITIONS\n   OVERWRITING OPTIONS\n   OVERWRITING WATERMARKS)");
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withSchema(org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).column("a", (AbstractDataType)DataTypes.INT()).watermark("f1", "`f1` - INTERVAL '5' SECOND").build()), OperationMatchers.withOptions(OperationMatchers.entry("connector.type", "kafka"), OperationMatchers.entry("format.type", "json")), OperationMatchers.partitionedBy("a", "f0"))));
    }

    @Test
    public void testCreateTableInvalidPartition() {
        String sql = "create table derivedTable(\n  a int\n)\nPARTITIONED BY (f3)";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table derivedTable(\n  a int\n)\nPARTITIONED BY (f3)")).isInstanceOf(ValidationException.class)).hasMessageContaining("Partition column 'f3' not defined in the table schema. Available columns: ['a']");
    }

    @Test
    public void testCreateTableLikeInvalidPartition() {
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).build(), null, Collections.emptyList(), Collections.emptyMap());
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int\n)\nPARTITIONED BY (f3)\nlike sourceTable";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table derivedTable(\n  a int\n)\nPARTITIONED BY (f3)\nlike sourceTable")).isInstanceOf(ValidationException.class)).hasMessageContaining("Partition column 'f3' not defined in the table schema. Available columns: ['f0', 'a']");
    }

    @Test
    public void testCreateTableInvalidWatermark() {
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)")).isInstanceOf(ValidationException.class)).hasMessageContaining("The rowtime attribute field 'f1' is not defined in the table schema, at line 3, column 17\nAvailable fields: ['a']");
    }

    @Test
    public void testCreateTableLikeInvalidWatermark() {
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).build(), null, Collections.emptyList(), Collections.emptyMap());
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nlike sourceTable";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1 as `f1` - interval '5' second\n)\nlike sourceTable")).isInstanceOf(ValidationException.class)).hasMessageContaining("The rowtime attribute field 'f1' is not defined in the table schema, at line 3, column 17\nAvailable fields: ['f0', 'a']");
    }

    @Test
    public void testCreateTableLikeNestedWatermark() {
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"tmstmp", (DataType)DataTypes.TIMESTAMP((int)3))})).build(), null, Collections.emptyList(), Collections.emptyMap());
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable(\n  a int,\n  watermark for f1.t as f1.t - interval '5' second\n)\nlike sourceTable";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table derivedTable(\n  a int,\n  watermark for f1.t as f1.t - interval '5' second\n)\nlike sourceTable")).isInstanceOf(ValidationException.class)).hasMessageContaining("The rowtime attribute field 'f1.t' is not defined in the table schema, at line 3, column 20\nNested field 't' was not found in a composite type: ROW<`tmstmp` TIMESTAMP(3)>.");
    }

    @Test
    public void testSqlInsertWithStaticPartition() {
        String sql = "insert into t1 partition(a=1) select b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("insert into t1 partition(a=1) select b, c, d from t2", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
        SinkModifyOperation sinkModifyOperation = (SinkModifyOperation)operation;
        HashMap<String, String> expectedStaticPartitions = new HashMap<String, String>();
        expectedStaticPartitions.put("a", "1");
        Assertions.assertThat((Map)sinkModifyOperation.getStaticPartitions()).isEqualTo(expectedStaticPartitions);
    }

    @Test
    public void testSqlInsertWithDynamicTableOptions() {
        String sql = "insert into t1 /*+ OPTIONS('k1'='v1', 'k2'='v2') */\nselect a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("insert into t1 /*+ OPTIONS('k1'='v1', 'k2'='v2') */\nselect a, b, c, d from t2", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
        SinkModifyOperation sinkModifyOperation = (SinkModifyOperation)operation;
        Map dynamicOptions = sinkModifyOperation.getDynamicOptions();
        Assertions.assertThat((Map)dynamicOptions).isNotNull();
        Assertions.assertThat((int)dynamicOptions.size()).isEqualTo(2);
        Assertions.assertThat((String)dynamicOptions.toString()).isEqualTo("{k1=v1, k2=v2}");
    }

    @Test
    public void testDynamicTableWithInvalidOptions() {
        String sql = "select * from t1 /*+ OPTIONS('opt1', 'opt2') */";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("select * from t1 /*+ OPTIONS('opt1', 'opt2') */", planner, parser)).isInstanceOf(AssertionError.class)).hasMessageContaining("Hint [OPTIONS] only support non empty key value options");
    }

    @Test
    public void testCreateTableWithFullDataTypes() {
        List<TestItem> testItems = Arrays.asList(SqlToOperationConverterTest.createTestItem("CHAR", DataTypes.CHAR((int)1)), SqlToOperationConverterTest.createTestItem("CHAR NOT NULL", DataTypes.CHAR((int)1).notNull()), SqlToOperationConverterTest.createTestItem("CHAR NULL", DataTypes.CHAR((int)1)), SqlToOperationConverterTest.createTestItem("CHAR(33)", DataTypes.CHAR((int)33)), SqlToOperationConverterTest.createTestItem("VARCHAR", DataTypes.STRING()), SqlToOperationConverterTest.createTestItem("VARCHAR(33)", DataTypes.VARCHAR((int)33)), SqlToOperationConverterTest.createTestItem("STRING", DataTypes.STRING()), SqlToOperationConverterTest.createTestItem("BOOLEAN", DataTypes.BOOLEAN()), SqlToOperationConverterTest.createTestItem("BINARY", DataTypes.BINARY((int)1)), SqlToOperationConverterTest.createTestItem("BINARY(33)", DataTypes.BINARY((int)33)), SqlToOperationConverterTest.createTestItem("VARBINARY", DataTypes.BYTES()), SqlToOperationConverterTest.createTestItem("VARBINARY(33)", DataTypes.VARBINARY((int)33)), SqlToOperationConverterTest.createTestItem("BYTES", DataTypes.BYTES()), SqlToOperationConverterTest.createTestItem("DECIMAL", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("DEC", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("NUMERIC", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("DECIMAL(10)", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("DEC(10)", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("NUMERIC(10)", DataTypes.DECIMAL((int)10, (int)0)), SqlToOperationConverterTest.createTestItem("DECIMAL(10, 3)", DataTypes.DECIMAL((int)10, (int)3)), SqlToOperationConverterTest.createTestItem("DEC(10, 3)", DataTypes.DECIMAL((int)10, (int)3)), SqlToOperationConverterTest.createTestItem("NUMERIC(10, 3)", DataTypes.DECIMAL((int)10, (int)3)), SqlToOperationConverterTest.createTestItem("TINYINT", DataTypes.TINYINT()), SqlToOperationConverterTest.createTestItem("SMALLINT", DataTypes.SMALLINT()), SqlToOperationConverterTest.createTestItem("INTEGER", DataTypes.INT()), SqlToOperationConverterTest.createTestItem("INT", DataTypes.INT()), SqlToOperationConverterTest.createTestItem("BIGINT", DataTypes.BIGINT()), SqlToOperationConverterTest.createTestItem("FLOAT", DataTypes.FLOAT()), SqlToOperationConverterTest.createTestItem("DOUBLE", DataTypes.DOUBLE()), SqlToOperationConverterTest.createTestItem("DOUBLE PRECISION", DataTypes.DOUBLE()), SqlToOperationConverterTest.createTestItem("DATE", DataTypes.DATE()), SqlToOperationConverterTest.createTestItem("TIME", DataTypes.TIME()), SqlToOperationConverterTest.createTestItem("TIME WITHOUT TIME ZONE", DataTypes.TIME()), SqlToOperationConverterTest.createTestItem("TIME(3)", DataTypes.TIME()), SqlToOperationConverterTest.createTestItem("TIME(3) WITHOUT TIME ZONE", DataTypes.TIME()), SqlToOperationConverterTest.createTestItem("TIMESTAMP", DataTypes.TIMESTAMP((int)6)), SqlToOperationConverterTest.createTestItem("TIMESTAMP WITHOUT TIME ZONE", DataTypes.TIMESTAMP((int)6)), SqlToOperationConverterTest.createTestItem("TIMESTAMP(3)", DataTypes.TIMESTAMP((int)3)), SqlToOperationConverterTest.createTestItem("TIMESTAMP(3) WITHOUT TIME ZONE", DataTypes.TIMESTAMP((int)3)), SqlToOperationConverterTest.createTestItem("TIMESTAMP WITH LOCAL TIME ZONE", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)6)), SqlToOperationConverterTest.createTestItem("TIMESTAMP(3) WITH LOCAL TIME ZONE", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)), SqlToOperationConverterTest.createTestItem("ARRAY<TIMESTAMP(3) WITH LOCAL TIME ZONE>", DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3))), SqlToOperationConverterTest.createTestItem("ARRAY<INT NOT NULL>", DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()))), SqlToOperationConverterTest.createTestItem("INT ARRAY", DataTypes.ARRAY((DataType)DataTypes.INT())), SqlToOperationConverterTest.createTestItem("INT NOT NULL ARRAY", DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()))), SqlToOperationConverterTest.createTestItem("INT ARRAY NOT NULL", DataTypes.ARRAY((DataType)DataTypes.INT()).notNull()), SqlToOperationConverterTest.createTestItem("MULTISET<INT NOT NULL>", DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().notNull()))), SqlToOperationConverterTest.createTestItem("INT MULTISET", DataTypes.MULTISET((DataType)DataTypes.INT())), SqlToOperationConverterTest.createTestItem("INT NOT NULL MULTISET", DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().notNull()))), SqlToOperationConverterTest.createTestItem("INT MULTISET NOT NULL", DataTypes.MULTISET((DataType)DataTypes.INT()).notNull()), SqlToOperationConverterTest.createTestItem("MAP<BIGINT, BOOLEAN>", DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)DataTypes.BOOLEAN())), SqlToOperationConverterTest.createTestItem("ROW<f0 INT NOT NULL, f1 BOOLEAN>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), SqlToOperationConverterTest.createTestItem("ROW(f0 INT NOT NULL, f1 BOOLEAN)", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), SqlToOperationConverterTest.createTestItem("ROW<`f0` INT>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())})), SqlToOperationConverterTest.createTestItem("ROW(`f0` INT)", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT())})), SqlToOperationConverterTest.createTestItem("ROW<>", DataTypes.ROW()), SqlToOperationConverterTest.createTestItem("ROW()", DataTypes.ROW()), SqlToOperationConverterTest.createTestItem("ROW<f0 INT NOT NULL 'This is a comment.', f1 BOOLEAN 'This as well.'>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), SqlToOperationConverterTest.createTestItem("ARRAY<ROW<f0 INT, f1 BOOLEAN>>", DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())}))), SqlToOperationConverterTest.createTestItem("ROW<f0 INT, f1 BOOLEAN> MULTISET", DataTypes.MULTISET((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())}))), SqlToOperationConverterTest.createTestItem("MULTISET<ROW<f0 INT, f1 BOOLEAN>>", DataTypes.MULTISET((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())}))), SqlToOperationConverterTest.createTestItem("ROW<f0 Row<f00 INT, f01 BOOLEAN>, f1 INT ARRAY, f2 BOOLEAN MULTISET>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f00", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f01", (DataType)DataTypes.BOOLEAN())})), DataTypes.FIELD((String)"f1", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.FIELD((String)"f2", (DataType)DataTypes.MULTISET((DataType)DataTypes.BOOLEAN()))})));
        StringBuilder buffer = new StringBuilder("create table t1(\n");
        for (int i = 0; i < testItems.size(); ++i) {
            buffer.append("f").append(i).append(" ").append(testItems.get(i).testExpr);
            if (i == testItems.size() - 1) {
                buffer.append(")");
                continue;
            }
            buffer.append(",\n");
        }
        String sql = buffer.toString();
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        Assertions.assertThat((Object)node).isInstanceOf(SqlCreateTable.class);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        TableSchema schema = ((CreateTableOperation)operation).getCatalogTable().getSchema();
        Object[] expectedDataTypes = testItems.stream().map(item -> ((TestItem)item).expectedType).toArray();
        Assertions.assertThat((Object[])schema.getFieldDataTypes()).isEqualTo((Object)expectedDataTypes);
    }

    @Test
    public void testCreateTableWithComputedColumn() {
        String sql = "CREATE TABLE tbl1 (\n  a int,\n  b varchar, \n  c as a - 1, \n  d as b || '$$', \n  e as my_udf1(a),  f as `default`.my_udf2(a) + 1,  g as builtin.`default`.my_udf3(a) || '##'\n)\n  with (\n    'connector' = 'kafka', \n    'kafka.topic' = 'log.test'\n)\n";
        this.functionCatalog.registerTempCatalogScalarFunction(ObjectIdentifier.of((String)"builtin", (String)"default", (String)"my_udf1"), (ScalarFunction)Func0$.MODULE$);
        this.functionCatalog.registerTempCatalogScalarFunction(ObjectIdentifier.of((String)"builtin", (String)"default", (String)"my_udf2"), (ScalarFunction)Func1$.MODULE$);
        this.functionCatalog.registerTempCatalogScalarFunction(ObjectIdentifier.of((String)"builtin", (String)"default", (String)"my_udf3"), (ScalarFunction)Func8$.MODULE$);
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("CREATE TABLE tbl1 (\n  a int,\n  b varchar, \n  c as a - 1, \n  d as b || '$$', \n  e as my_udf1(a),  f as `default`.my_udf2(a) + 1,  g as builtin.`default`.my_udf3(a) || '##'\n)\n  with (\n    'connector' = 'kafka', \n    'kafka.topic' = 'log.test'\n)\n", planner, this.getParserBySqlDialect(SqlDialect.DEFAULT));
        Assertions.assertThat((Object)operation).isInstanceOf(CreateTableOperation.class);
        CreateTableOperation op = (CreateTableOperation)operation;
        CatalogTable catalogTable = op.getCatalogTable();
        Assertions.assertThat((Object[])catalogTable.getSchema().getFieldNames()).isEqualTo((Object)new String[]{"a", "b", "c", "d", "e", "f", "g"});
        Assertions.assertThat((Object[])catalogTable.getSchema().getFieldDataTypes()).isEqualTo((Object)new DataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.INT(), DataTypes.STRING(), (DataType)DataTypes.INT().notNull(), DataTypes.INT(), DataTypes.STRING()});
        Object[] columnExpressions = (String[])catalogTable.getSchema().getTableColumns().stream().filter(TableColumn.ComputedColumn.class::isInstance).map(TableColumn.ComputedColumn.class::cast).map(TableColumn.ComputedColumn::getExpression).toArray(String[]::new);
        String[] expected = new String[]{"`a` - 1", "`b` || '$$'", "`builtin`.`default`.`my_udf1`(`a`)", "`builtin`.`default`.`my_udf2`(`a`) + 1", "`builtin`.`default`.`my_udf3`(`a`) || '##'"};
        Assertions.assertThat((Object[])columnExpressions).isEqualTo((Object)expected);
    }

    @Test
    public void testCreateTableWithMetadataColumn() {
        String sql = "CREATE TABLE tbl1 (\n  a INT,\n  b STRING,\n  c INT METADATA,\n  d INT METADATA FROM 'other.key',\n  e INT METADATA VIRTUAL\n)\n  WITH (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("CREATE TABLE tbl1 (\n  a INT,\n  b STRING,\n  c INT METADATA,\n  d INT METADATA FROM 'other.key',\n  e INT METADATA VIRTUAL\n)\n  WITH (\n    'connector' = 'kafka',\n    'kafka.topic' = 'log.test'\n)\n", planner, this.getParserBySqlDialect(SqlDialect.DEFAULT));
        Assertions.assertThat((Object)operation).isInstanceOf(CreateTableOperation.class);
        CreateTableOperation op = (CreateTableOperation)operation;
        TableSchema actualSchema = op.getCatalogTable().getSchema();
        TableSchema expectedSchema = TableSchema.builder().add((TableColumn)TableColumn.physical((String)"a", (DataType)DataTypes.INT())).add((TableColumn)TableColumn.physical((String)"b", (DataType)DataTypes.STRING())).add((TableColumn)TableColumn.metadata((String)"c", (DataType)DataTypes.INT())).add((TableColumn)TableColumn.metadata((String)"d", (DataType)DataTypes.INT(), (String)"other.key")).add((TableColumn)TableColumn.metadata((String)"e", (DataType)DataTypes.INT(), (boolean)true)).build();
        Assertions.assertThat((Object)actualSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    public void testCreateFunction() {
        String sql = "CREATE FUNCTION test_udf AS 'org.apache.fink.function.function1' LANGUAGE JAVA USING JAR 'file:///path/to/test.jar'";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse(sql, planner, this.getParserBySqlDialect(SqlDialect.DEFAULT));
        Assertions.assertThat((Object)operation).isInstanceOf(CreateCatalogFunctionOperation.class);
        CatalogFunction actualFunction = ((CreateCatalogFunctionOperation)operation).getCatalogFunction();
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("CREATE CATALOG FUNCTION: (catalogFunction: [Optional[This is a user-defined function]], identifier: [`builtin`.`default`.`test_udf`], ignoreIfExists: [false], isTemporary: [false])");
        CatalogFunctionImpl expected = new CatalogFunctionImpl("org.apache.fink.function.function1", FunctionLanguage.JAVA, Collections.singletonList(new ResourceUri(ResourceType.JAR, "file:///path/to/test.jar")));
        Assertions.assertThat((Object)actualFunction).isEqualTo((Object)expected);
        sql = "CREATE TEMPORARY SYSTEM FUNCTION test_udf2 AS 'org.apache.fink.function.function2' LANGUAGE SCALA USING JAR 'file:///path/to/test.jar'";
        operation = this.parse(sql, planner, this.getParserBySqlDialect(SqlDialect.DEFAULT));
        Assertions.assertThat((Object)operation).isInstanceOf(CreateTempSystemFunctionOperation.class);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("CREATE TEMPORARY SYSTEM FUNCTION: (functionName: [test_udf2], catalogFunction: [CatalogFunctionImpl{className='org.apache.fink.function.function2', functionLanguage='SCALA', functionResource='[ResourceUri{resourceType=JAR, uri='file:///path/to/test.jar'}]'}], ignoreIfExists: [false], functionLanguage: [SCALA])");
    }

    @Test
    public void testAlterTable() throws Exception {
        this.prepareNonManagedTable(false);
        String[] renameTableSqls = new String[]{"alter table cat1.db1.tb1 rename to tb2", "alter table db1.tb1 rename to tb2", "alter table tb1 rename to cat1.db1.tb2"};
        ObjectIdentifier expectedIdentifier = ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tb1");
        ObjectIdentifier expectedNewIdentifier = ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tb2");
        for (int i = 0; i < renameTableSqls.length; ++i) {
            Operation operation = this.parse(renameTableSqls[i], SqlDialect.DEFAULT);
            Assertions.assertThat((Object)operation).isInstanceOf(AlterTableRenameOperation.class);
            AlterTableRenameOperation alterTableRenameOperation = (AlterTableRenameOperation)operation;
            Assertions.assertThat((Object)alterTableRenameOperation.getTableIdentifier()).isEqualTo((Object)expectedIdentifier);
            Assertions.assertThat((Object)alterTableRenameOperation.getNewTableIdentifier()).isEqualTo((Object)expectedNewIdentifier);
        }
        Operation operation = this.parse("alter table cat1.db1.tb1 set ('k1' = 'v1', 'K2' = 'V2')", SqlDialect.DEFAULT);
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("connector", "dummy");
        expectedOptions.put("k", "v");
        expectedOptions.put("k1", "v1");
        expectedOptions.put("K2", "V2");
        this.assertAlterTableOptions(operation, expectedIdentifier, expectedOptions);
        operation = this.parse("alter table cat1.db1.tb1 reset ('k')", SqlDialect.DEFAULT);
        this.assertAlterTableOptions(operation, expectedIdentifier, Collections.singletonMap("connector", "dummy"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table cat1.db1.tb1 reset ('connector')", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessageContaining("ALTER TABLE RESET does not support changing 'connector'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table cat1.db1.tb1 reset ()", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessageContaining("ALTER TABLE RESET does not support empty key");
    }

    @Test
    public void testAlterTableAddPkConstraint() throws Exception {
        this.prepareNonManagedTable(false);
        Operation operation = this.parse("alter table tb1 add constraint ct1 primary key(a, b) not enforced", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(AlterTableAddConstraintOperation.class);
        AlterTableAddConstraintOperation addConstraintOperation = (AlterTableAddConstraintOperation)operation;
        Assertions.assertThat((String)addConstraintOperation.asSummaryString()).isEqualTo("ALTER TABLE ADD CONSTRAINT: (identifier: [`cat1`.`db1`.`tb1`], constraintName: [ct1], columns: [a, b])");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb1 add constraint ct1 primary key(c) not enforced", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessageContaining("Could not create a PRIMARY KEY 'ct1'. Column 'c' is nullable.");
    }

    @Test
    public void testAlterTableAddPkConstraintEnforced() throws Exception {
        this.prepareNonManagedTable(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb1 add constraint ct1 primary key(a, b)", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessageContaining("Flink doesn't support ENFORCED mode for PRIMARY KEY constraint. ENFORCED/NOT ENFORCED  controls if the constraint checks are performed on the incoming/outgoing data. Flink does not own the data therefore the only supported mode is the NOT ENFORCED mode");
    }

    @Test
    public void testAlterTableAddUniqueConstraint() throws Exception {
        this.prepareNonManagedTable(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb1 add constraint ct1 unique(a, b) not enforced", SqlDialect.DEFAULT)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("UNIQUE constraint is not supported yet");
    }

    @Test
    public void testAlterTableAddUniqueConstraintEnforced() throws Exception {
        this.prepareNonManagedTable(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb1 add constraint ct1 unique(a, b)", SqlDialect.DEFAULT)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("UNIQUE constraint is not supported yet");
    }

    @Test
    public void testAlterTableDropConstraint() throws Exception {
        this.prepareNonManagedTable(true);
        Operation operation = this.parse("alter table tb1 drop constraint ct1", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(AlterTableDropConstraintOperation.class);
        AlterTableDropConstraintOperation dropConstraint = (AlterTableDropConstraintOperation)operation;
        Assertions.assertThat((String)dropConstraint.asSummaryString()).isEqualTo("ALTER TABLE cat1.db1.tb1 DROP CONSTRAINT ct1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb1 drop constraint ct2", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessageContaining("CONSTRAINT [ct2] does not exist");
    }

    @Test
    public void testAlterTableCompactOnNonManagedTable() throws Exception {
        this.prepareNonManagedTable(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb1 compact", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessage("ALTER TABLE COMPACT operation is not supported for non-managed table `cat1`.`db1`.`tb1`");
    }

    @Test
    public void testAlterTableCompactOnManagedNonPartitionedTable() throws Exception {
        this.prepareManagedTable(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb1 partition(dt = 'a') compact", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessage("Partition column 'dt' not defined in the table schema. Table `cat1`.`db1`.`tb1` is not partitioned.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb2 compact", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessage("Table `cat1`.`db1`.`tb2` doesn't exist or is a temporary table.");
        this.checkAlterTableCompact(this.parse("alter table tb1 compact", SqlDialect.DEFAULT), Collections.emptyMap());
    }

    @Test
    public void testAlterTableCompactOnManagedPartitionedTable() throws Exception {
        this.prepareManagedTable(true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("alter table tb1 partition (dt = 'a') compact", SqlDialect.DEFAULT)).isInstanceOf(ValidationException.class)).hasMessage("Partition column 'dt' not defined in the table schema. Available ordered partition columns: ['b', 'c']");
        Map<String, String> staticPartitions = new HashMap<String, String>();
        staticPartitions.put("b", "0");
        staticPartitions.put("c", "flink");
        this.checkAlterTableCompact(this.parse("alter table tb1 partition (b = 0, c = 'flink') compact", SqlDialect.DEFAULT), staticPartitions);
        staticPartitions = Collections.singletonMap("b", "0");
        this.checkAlterTableCompact(this.parse("alter table tb1 partition (b = 0) compact", SqlDialect.DEFAULT), staticPartitions);
        staticPartitions = Collections.singletonMap("c", "flink");
        this.checkAlterTableCompact(this.parse("alter table tb1 partition (c = 'flink') compact", SqlDialect.DEFAULT), staticPartitions);
        staticPartitions = Collections.emptyMap();
        this.checkAlterTableCompact(this.parse("alter table tb1 compact", SqlDialect.DEFAULT), staticPartitions);
    }

    @Test
    public void testCreateViewWithMatchRecognize() {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("connector", "values");
        prop.put("bounded", "true");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("id", DataTypes.INT().notNull()).column("measurement", DataTypes.BIGINT().notNull()).column("ts", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"tmstmp", (DataType)DataTypes.TIMESTAMP((int)3))})).build(), null, Collections.emptyList(), prop);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"events"), false);
        String sql = "CREATE TEMPORARY VIEW foo AS SELECT * FROM events MATCH_RECOGNIZE (    PARTITION BY id     ORDER BY ts ASC     MEASURES       next_step.measurement - this_step.measurement AS diff     AFTER MATCH SKIP TO NEXT ROW     PATTERN (this_step next_step)    DEFINE          this_step AS TRUE,         next_step AS TRUE)";
        Operation operation = this.parse("CREATE TEMPORARY VIEW foo AS SELECT * FROM events MATCH_RECOGNIZE (    PARTITION BY id     ORDER BY ts ASC     MEASURES       next_step.measurement - this_step.measurement AS diff     AFTER MATCH SKIP TO NEXT ROW     PATTERN (this_step next_step)    DEFINE          this_step AS TRUE,         next_step AS TRUE)", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(CreateViewOperation.class);
    }

    @Test
    public void testCreateViewWithDynamicTableOptions() {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("connector", "values");
        prop.put("bounded", "true");
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)org.apache.flink.table.api.Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).column("f1", (AbstractDataType)DataTypes.VARCHAR((int)20)).build(), null, Collections.emptyList(), prop);
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceA"), false);
        String sql = "create view test_view as\nselect *\nfrom sourceA /*+ OPTIONS('changelog-mode'='I') */";
        Operation operation = this.parse("create view test_view as\nselect *\nfrom sourceA /*+ OPTIONS('changelog-mode'='I') */", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(CreateViewOperation.class);
    }

    @Test
    public void testBeginStatementSet() {
        String sql = "BEGIN STATEMENT SET";
        Operation operation = this.parse("BEGIN STATEMENT SET", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(BeginStatementSetOperation.class);
        BeginStatementSetOperation beginStatementSetOperation = (BeginStatementSetOperation)operation;
        Assertions.assertThat((String)beginStatementSetOperation.asSummaryString()).isEqualTo("BEGIN STATEMENT SET");
    }

    @Test
    public void testEnd() {
        String sql = "END";
        Operation operation = this.parse("END", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(EndStatementSetOperation.class);
        EndStatementSetOperation endStatementSetOperation = (EndStatementSetOperation)operation;
        Assertions.assertThat((String)endStatementSetOperation.asSummaryString()).isEqualTo("END");
    }

    @Test
    public void testSqlRichExplainWithSelect() {
        String sql = "explain plan for select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("explain plan for select a, b, c, d from t2", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(ExplainOperation.class);
    }

    @Test
    public void testSqlRichExplainWithInsert() {
        String sql = "explain plan for insert into t1 select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("explain plan for insert into t1 select a, b, c, d from t2", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(ExplainOperation.class);
    }

    @Test
    public void testSqlRichExplainWithStatementSet() {
        String sql = "explain plan for statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("explain plan for statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(ExplainOperation.class);
    }

    @Test
    public void testExplainDetailsWithSelect() {
        String sql = "explain estimated_cost, changelog_mode select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.assertExplainDetails(this.parse("explain estimated_cost, changelog_mode select a, b, c, d from t2", planner, parser));
    }

    @Test
    public void testExplainDetailsWithInsert() {
        String sql = "explain estimated_cost, changelog_mode insert into t1 select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.assertExplainDetails(this.parse("explain estimated_cost, changelog_mode insert into t1 select a, b, c, d from t2", planner, parser));
    }

    @Test
    public void testExplainDetailsWithStatementSet() {
        String sql = "explain estimated_cost, changelog_mode statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.assertExplainDetails(this.parse("explain estimated_cost, changelog_mode statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end", planner, parser));
    }

    private void assertExplainDetails(Operation operation) {
        HashSet<String> expectedDetail = new HashSet<String>();
        expectedDetail.add(ExplainDetail.ESTIMATED_COST.toString());
        expectedDetail.add(ExplainDetail.CHANGELOG_MODE.toString());
        ((ObjectAssert)Assertions.assertThat((Object)operation).asInstanceOf(InstanceOfAssertFactories.type(ExplainOperation.class))).satisfies(new ThrowingConsumer[]{explain -> {
            AbstractCollectionAssert cfr_ignored_0 = (AbstractCollectionAssert)Assertions.assertThat((Collection)explain.getExplainDetails()).isEqualTo((Object)expectedDetail);
        }});
    }

    @Test
    public void testSqlExecuteWithStatementSet() {
        String sql = "execute statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("execute statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(StatementSetOperation.class);
    }

    @Test
    public void testSqlExecuteWithInsert() {
        String sql = "execute insert into t1 select a, b, c, d from t2 where a > 1";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("execute insert into t1 select a, b, c, d from t2 where a > 1", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
    }

    @Test
    public void testSqlExecuteWithSelect() {
        String sql = "execute select a, b, c, d from t2 where a > 1";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("execute select a, b, c, d from t2 where a > 1", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(QueryOperation.class);
    }

    @Test
    public void testAddJar() {
        Arrays.asList("./test.\njar", "file:///path/to/whatever", "../test-jar.jar", "/root/test.jar", "test\\ jar.jar", "oss://path/helloworld.go").forEach(jarPath -> {
            AddJarOperation operation = (AddJarOperation)this.parser.parse(String.format("ADD JAR '%s'", jarPath)).get(0);
            Assertions.assertThat((String)operation.getPath()).isEqualTo(jarPath);
        });
    }

    @Test
    public void testRemoveJar() {
        Arrays.asList("./test.\njar", "file:///path/to/whatever", "../test-jar.jar", "/root/test.jar", "test\\ jar.jar", "oss://path/helloworld.go").forEach(jarPath -> {
            RemoveJarOperation operation = (RemoveJarOperation)this.parser.parse(String.format("REMOVE JAR '%s'", jarPath)).get(0);
            Assertions.assertThat((String)operation.getPath()).isEqualTo(jarPath);
        });
    }

    @Test
    public void testShowJars() {
        String sql = "SHOW JARS";
        Operation operation = this.parse("SHOW JARS", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(ShowJarsOperation.class);
        ShowJarsOperation showModulesOperation = (ShowJarsOperation)operation;
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW JARS");
    }

    @Test
    public void testSet() {
        Operation operation1 = this.parse("SET", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation1).isInstanceOf(SetOperation.class);
        SetOperation setOperation1 = (SetOperation)operation1;
        Assertions.assertThat((Optional)setOperation1.getKey()).isNotPresent();
        Assertions.assertThat((Optional)setOperation1.getValue()).isNotPresent();
        Operation operation2 = this.parse("SET 'test-key' = 'test-value'", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation2).isInstanceOf(SetOperation.class);
        SetOperation setOperation2 = (SetOperation)operation2;
        Assertions.assertThat((Optional)setOperation2.getKey()).hasValue((Object)"test-key");
        Assertions.assertThat((Optional)setOperation2.getValue()).hasValue((Object)"test-value");
    }

    @Test
    public void testReset() {
        Operation operation1 = this.parse("RESET", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation1).isInstanceOf(ResetOperation.class);
        Assertions.assertThat((Optional)((ResetOperation)operation1).getKey()).isNotPresent();
        Operation operation2 = this.parse("RESET 'test-key'", SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation2).isInstanceOf(ResetOperation.class);
        Assertions.assertThat((Optional)((ResetOperation)operation2).getKey()).isPresent();
        Assertions.assertThat((Optional)((ResetOperation)operation2).getKey()).hasValue((Object)"test-key");
    }

    @ParameterizedTest
    @ValueSource(strings={"SET", "SET;", "SET ;", "SET\t;", "SET\n;"})
    public void testSetCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(SetOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"HELP", "HELP;", "HELP ;", "HELP\t;", "HELP\n;"})
    public void testHelpCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(HelpOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"CLEAR", "CLEAR;", "CLEAR ;", "CLEAR\t;", "CLEAR\n;"})
    public void testClearCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(ClearOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"QUIT;", "QUIT;", "QUIT ;", "QUIT\t;", "QUIT\n;", "EXIT;", "EXIT ;", "EXIT\t;", "EXIT\n;", "EXIT ; "})
    public void testQuitCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(QuitOperation.class);
    }

    private static TestItem createTestItem(Object ... args) {
        Assertions.assertThat((Object[])args).hasSize(2);
        String testExpr = (String)args[0];
        TestItem testItem = TestItem.fromTestExpr(testExpr);
        if (args[1] instanceof String) {
            testItem.withExpectedError((String)args[1]);
        } else {
            testItem.withExpectedType(args[1]);
        }
        return testItem;
    }

    private void checkExplainSql(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        Assertions.assertThat((Object)node).isInstanceOf(SqlRichExplain.class);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        Assertions.assertThat((Object)operation).isInstanceOf(ExplainOperation.class);
    }

    private void assertShowFunctions(String sql, String expectedSummary, ShowFunctionsOperation.FunctionScope expectedScope) {
        Operation operation = this.parse(sql, SqlDialect.DEFAULT);
        Assertions.assertThat((Object)operation).isInstanceOf(ShowFunctionsOperation.class);
        ShowFunctionsOperation showFunctionsOperation = (ShowFunctionsOperation)operation;
        Assertions.assertThat((Comparable)showFunctionsOperation.getFunctionScope()).isEqualTo((Object)expectedScope);
        Assertions.assertThat((String)showFunctionsOperation.asSummaryString()).isEqualTo(expectedSummary);
    }

    private void assertAlterTableOptions(Operation operation, ObjectIdentifier expectedIdentifier, Map<String, String> expectedOptions) {
        Assertions.assertThat((Object)operation).isInstanceOf(AlterTableOptionsOperation.class);
        AlterTableOptionsOperation alterTableOptionsOperation = (AlterTableOptionsOperation)operation;
        Assertions.assertThat((Object)alterTableOptionsOperation.getTableIdentifier()).isEqualTo((Object)expectedIdentifier);
        Assertions.assertThat((Map)alterTableOptionsOperation.getCatalogTable().getOptions()).isEqualTo(expectedOptions);
    }

    private Operation parse(String sql, FlinkPlannerImpl planner, CalciteParser parser) {
        SqlNode node = parser.parse(sql);
        return (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    private Operation parse(String sql, SqlDialect sqlDialect) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(sqlDialect);
        CalciteParser parser = this.getParserBySqlDialect(sqlDialect);
        SqlNode node = parser.parse(sql);
        return (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    private void prepareNonManagedTable(boolean hasConstraint) throws Exception {
        this.prepareTable(false, false, hasConstraint);
    }

    private void prepareManagedTable(boolean hasPartition) throws Exception {
        TestManagedTableFactory.MANAGED_TABLES.put(ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tb1"), new AtomicReference());
        this.prepareTable(true, hasPartition, false);
    }

    private void prepareTable(boolean managedTable, boolean hasPartition, boolean hasConstraint) throws Exception {
        GenericInMemoryCatalog catalog = new GenericInMemoryCatalog("default", "default");
        this.catalogManager.registerCatalog("cat1", (Catalog)catalog);
        catalog.createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), null), true);
        Schema.Builder builder = org.apache.flink.table.api.Schema.newBuilder().column("a", DataTypes.STRING().notNull()).column("b", DataTypes.BIGINT().notNull()).column("c", (AbstractDataType)DataTypes.BIGINT());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("k", "v");
        if (!managedTable) {
            options.put("connector", "dummy");
        }
        CatalogTable catalogTable = CatalogTable.of((org.apache.flink.table.api.Schema)(hasConstraint ? builder.primaryKeyNamed("ct1", new String[]{"a", "b"}).build() : builder.build()), (String)"tb1", hasPartition ? Arrays.asList("b", "c") : Collections.emptyList(), Collections.unmodifiableMap(options));
        this.catalogManager.setCurrentCatalog("cat1");
        this.catalogManager.setCurrentDatabase("db1");
        ObjectIdentifier tableIdentifier = ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tb1");
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, tableIdentifier, true);
    }

    private FlinkPlannerImpl getPlannerBySqlDialect(SqlDialect sqlDialect) {
        this.tableConfig.setSqlDialect(sqlDialect);
        return this.plannerContext.createFlinkPlanner();
    }

    private CalciteParser getParserBySqlDialect(SqlDialect sqlDialect) {
        this.tableConfig.setSqlDialect(sqlDialect);
        return this.plannerContext.createCalciteParser();
    }

    private void checkAlterTableCompact(Operation operation, Map<String, String> staticPartitions) {
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
        SinkModifyOperation modifyOperation = (SinkModifyOperation)operation;
        Assertions.assertThat((Map)modifyOperation.getStaticPartitions()).containsExactlyInAnyOrderEntriesOf(staticPartitions);
        Assertions.assertThat((boolean)modifyOperation.isOverwrite()).isFalse();
        Assertions.assertThat((Map)modifyOperation.getDynamicOptions()).containsEntry((Object)"ENRICHED_KEY", (Object)"ENRICHED_VALUE");
        ContextResolvedTable contextResolvedTable = modifyOperation.getContextResolvedTable();
        Assertions.assertThat((Object)contextResolvedTable.getIdentifier()).isEqualTo((Object)ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tb1"));
        Assertions.assertThat((Object)modifyOperation.getChild()).isInstanceOf(SourceQueryOperation.class);
        SourceQueryOperation child = (SourceQueryOperation)modifyOperation.getChild();
        Assertions.assertThat((List)child.getChildren()).isEmpty();
        Assertions.assertThat((Map)child.getDynamicOptions()).containsEntry((Object)"k", (Object)"v");
        Assertions.assertThat((Map)child.getDynamicOptions()).containsEntry((Object)"ENRICHED_KEY", (Object)"ENRICHED_VALUE");
    }

    private Operation parseAndConvert(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        return (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    private static class TestItem {
        private final String testExpr;
        @Nullable
        private Object expectedType;
        @Nullable
        private String expectedError;

        private TestItem(String testExpr) {
            this.testExpr = testExpr;
        }

        static TestItem fromTestExpr(String testExpr) {
            return new TestItem(testExpr);
        }

        TestItem withExpectedType(Object expectedType) {
            this.expectedType = expectedType;
            return this;
        }

        TestItem withExpectedError(String expectedError) {
            this.expectedError = expectedError;
            return this;
        }

        public String toString() {
            return this.testExpr;
        }
    }
}

