/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.match;

import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.match.PatternTranslatorTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001f\t)\u0002+\u0019;uKJtGK]1og2\fGo\u001c:UKN$(BA\u0002\u0005\u0003\u0015i\u0017\r^2i\u0015\t)a!A\u0004qY\u0006tg.\u001a:\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0011\u0004U1ui\u0016\u0014h\u000e\u0016:b]Nd\u0017\r^8s)\u0016\u001cHOQ1tK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u0003#\u0001AQ!\u0007\u0001\u0005\u0002i\tQb]5na2,\u0007+\u0019;uKJtG#A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u00031\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0007\u0002\u000b),h.\u001b;\n\u0005\u001d\"#\u0001\u0002+fgRDQ!\u000b\u0001\u0005\u0002i\ta\u0002^3ti\u00063G/\u001a:NCR\u001c\u0007\u000e\u000b\u0002)E!)A\u0006\u0001C\u00015\u0005yA/Z:u#V\fg\u000e^5gS\u0016\u00148\u000f\u000b\u0002,E!)q\u0006\u0001C\u00015\u0005aA/Z:u\u001fB$\u0018n\u001c8bY\"\u0012aF\t\u0005\u0006e\u0001!\tAG\u0001\u000ei\u0016\u001cHOU3mk\u000e$\u0018M\u001c;)\u0005E\u0012\u0003\"B\u001b\u0001\t\u0003Q\u0012!\b;fgR\u001cuN\u001c;s_2\u001c\u0005.\u0019:t\u0013:\u0004\u0016\r\u001e;fe:t\u0015-\\3)\u0005Q\u0012\u0003\"\u0002\u001d\u0001\t\u0003Q\u0012\u0001\u0005;fgR<\u0016\u000e\u001e5j]\u000ec\u0017-^:fQ\t9$\u0005C\u0003<\u0001\u0011\u0005!$A\u0014uKN$x+\u001b;iS:\u001cE.Y;tK^KG\u000f[-fCJluN\u001c;i%\u0016\u001cx\u000e\\;uS>t\u0007\u0006\u0002\u001e#{y\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!IB\u0001\u0004CBL\u0017B\u0001#B\u00059!\u0016M\u00197f\u000bb\u001cW\r\u001d;j_:DQA\u0012\u0001\u0005\u0002i\t\u0011\u0005^3tiJ+G.^2uC:$x\n\u001d;j_:\fGNT8u'V\u0004\bo\u001c:uK\u0012DC!\u0012\u0012>}!)\u0011\n\u0001C\u00015\u0005\u0001C/Z:u\u000fJ|W\u000f\u001d)biR,'O\\:Be\u0016tu\u000e^*vaB|'\u000f^3eQ\u0011A%%\u0010 \t\u000b1\u0003A\u0011\u0001\u000e\u0002?Q,7\u000f\u001e)fe6,H/\u0019;j_:\u001c\u0018I]3O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002LE!)q\n\u0001C\u00015\u0005iB/Z:u\u000bb\u001cG.^:j_:\u001c\u0018I]3O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002OE!)!\u000b\u0001C\u00015\u0005yB/Z:u\u00032$XM\u001d8bi&|gn]!sK:{GoU;qa>\u0014H/\u001a3)\u0005E\u0013\u0003\"B+\u0001\t\u0003Q\u0012A\t;fgR\u0004\u0006._:jG\u0006dwJ\u001a4tKR\u001c\u0018I]3O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002UE!)\u0001\f\u0001C\u00015\u0005\u0001C/Z:u!\u0006$H/\u001a:o-\u0006\u0014\u0018.\u00192mKNlUo\u001d;CKVs\u0017.];fQ\t9&\u0005")
public class PatternTranslatorTest
extends PatternTranslatorTestBase {
    @Test
    public void simplePattern() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B"));
    }

    @Test
    public void testAfterMatch() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO NEXT ROW\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO LAST A\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToLast((String)"A").throwExceptionOnMiss()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO FIRST A\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"A").throwExceptionOnMiss()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP PAST LAST ROW\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).next("B"));
    }

    @Test
    public void testQuantifiers() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,} B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).timesOrMore(2).consecutive().greedy().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A+ B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().greedy().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,6} B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).times(2, 6).consecutive().greedy().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2})\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).times(2).consecutive());
    }

    @Test
    public void testOptional() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A* B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().greedy().optional().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).optional().next("B"));
    }

    @Test
    public void testReluctant() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,}? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).timesOrMore(2).consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A+? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,6}? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).times(2, 6).consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A*? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().optional().next("B"));
    }

    @Test
    public void testControlCharsInPatternName() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    `A\"`.f0 AS aid\n        |  PATTERN (`A\"`? l C)\n        |  DEFINE\n        |    `A\"` as `A\"`.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A\"", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).optional().next("l").next("C"));
    }

    @Test
    public void testWithinClause() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    A.f0 AS aid\n        |  PATTERN (A B) WITHIN INTERVAL '10 00:00:00.004' DAY TO SECOND\n        |  DEFINE\n        |    A as A.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B").within(Time.milliseconds((long)864000004L)));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    A.f0 AS aid\n        |  PATTERN (A B) WITHIN INTERVAL '10 00' DAY TO HOUR\n        |  DEFINE\n        |    A as A.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B").within(Time.milliseconds((long)864000000L)));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    A.f0 AS aid\n        |  PATTERN (A B) WITHIN INTERVAL '10' MINUTE\n        |  DEFINE\n        |    A as A.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<RowData, ? extends RowData>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B").within(Time.milliseconds((long)600000L)));
    }

    @Test(expected=TableException.class)
    public void testWithinClauseWithYearMonthResolution() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    A.f0 AS aid\n        |  PATTERN (A B) WITHIN INTERVAL '2-10' YEAR TO MONTH\n        |  DEFINE\n        |    A as A.f0 = 1\n        |) AS T\n        |")).stripMargin(), null);
    }

    @Test(expected=TableException.class)
    public void testReluctantOptionalNotSupported() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A?? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test(expected=TableException.class)
    public void testGroupPatternsAreNotSupported() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN ((A B)+ C)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testPermutationsAreNotSupported() {
        this.thrown().expectMessage("Currently, CEP doesn't support PERMUTE patterns.");
        this.thrown().expect(TableException.class);
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (PERMUTE(A  C))\n        |   DEFINE\n        |     A AS A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testExclusionsAreNotSupported() {
        this.thrown().expectMessage("Currently, CEP doesn't support '{-' '-}' patterns.");
        this.thrown().expect(TableException.class);
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (A { - B - }  C)\n        |   DEFINE\n        |     A AS A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testAlternationsAreNotSupported() {
        this.thrown().expectMessage("Currently, CEP doesn't support branching patterns.");
        this.thrown().expect(TableException.class);
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (( A | B )  C)\n        |   DEFINE\n        |     A AS A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testPhysicalOffsetsAreNotSupported() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Flink does not support physical offsets within partition.");
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (A)\n        |   DEFINE\n        |     A AS PREV(A.f0) = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testPatternVariablesMustBeUnique() {
        this.thrown().expectMessage("Pattern variables must be unique. That might change in the future.");
        this.thrown().expect(TableException.class);
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (A B A)\n        |   DEFINE\n        |     A AS A.f0 = 1\n        |)")).stripMargin(), null);
    }
}

