/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.planner.functions.JsonFunctionsITCase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;

class CastFunctionMiscITCase
extends BuiltInFunctionTestBase {
    CastFunctionMiscITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "implicit with different field names").onFieldsWithData(Row.of((Object[])new Object[]{12, "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<otherNameInt INT, otherNameString STRING>")}).withFunction(RowToFirstField.class).testResult((Expression)Expressions.call((String)"RowToFirstField", (Object[])new Object[]{Expressions.$((String)"f0")}), "RowToFirstField(f0)", 12, (AbstractDataType<?>)DataTypes.INT()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "implicit with type widening").onFieldsWithData(Row.of((Object[])new Object[]{(byte)12, "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<i TINYINT, s STRING>")}).withFunction(RowToFirstField.class).testResult((Expression)Expressions.call((String)"RowToFirstField", (Object[])new Object[]{Expressions.$((String)"f0")}), "RowToFirstField(f0)", 12, (AbstractDataType<?>)DataTypes.INT()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "implicit with nested type widening").onFieldsWithData(Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{12, 42}), "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<r ROW<i1 INT, i2 INT>, s STRING>")}).withFunction(NestedRowToFirstField.class).testResult((Expression)Expressions.call((String)"NestedRowToFirstField", (Object[])new Object[]{Expressions.$((String)"f0")}), "NestedRowToFirstField(f0)", Row.of((Object[])new Object[]{12, 42.0}), (AbstractDataType<?>)DataTypes.of((String)"ROW<i INT, d DOUBLE>")), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "explicit with nested rows and implicit nullability change").onFieldsWithData(Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{12, 42, null}), "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<r ROW<i1 INT, i2 INT, i3 INT>, s STRING>")}).testResult((Expression)Expressions.$((String)"f0").cast(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"r", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"s", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())})), DataTypes.FIELD((String)"s", (DataType)DataTypes.STRING())})), "CAST(f0 AS ROW<r ROW<s STRING NOT NULL, b BOOLEAN, i INT>, s STRING>)", Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"12", true, null}), "Hello"}), (AbstractDataType<?>)DataTypes.of((String)"ROW<r ROW<s STRING, b BOOLEAN, i INT>, s STRING>")), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "explicit with nested rows and explicit nullability change").onFieldsWithData(Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{12, 42, null}), "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<r ROW<i1 INT, i2 INT, i3 INT>, s STRING>")}).testTableApiResult((Expression)Expressions.$((String)"f0").cast(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"r", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"s", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())})), DataTypes.FIELD((String)"s", (DataType)DataTypes.STRING())})), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"12", true, null}), "Hello"}), (AbstractDataType<?>)DataTypes.of((String)"ROW<r ROW<s STRING NOT NULL, b BOOLEAN, i INT>, s STRING>")), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "implicit between structured type and row").onFieldsWithData(12, "Ingo").withFunction(StructuredTypeConstructor.class).withFunction(RowToFirstField.class).testResult((Expression)Expressions.call((String)"RowToFirstField", (Object[])new Object[]{Expressions.call((String)"StructuredTypeConstructor", (Object[])new Object[]{Expressions.row((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f1")})})}), "RowToFirstField(StructuredTypeConstructor((f0, f1)))", 12, (AbstractDataType<?>)DataTypes.INT()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "explicit between structured type and row").onFieldsWithData(12, "Ingo").withFunction(StructuredTypeConstructor.class).testTableApiResult((Expression)Expressions.call((String)"StructuredTypeConstructor", (Object[])new Object[]{Expressions.row((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f1")})}).cast(DataTypes.ROW((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()})), Row.of((Object[])new Object[]{12L, "Ingo"}), (AbstractDataType<?>)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()})), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "cast from RAW(Integer) to BINARY(3)").onFieldsWithData(123456).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).withFunction(IntegerToRaw.class).testTableApiResult((Expression)Expressions.call((String)"IntegerToRaw", (Object[])new Object[]{Expressions.$((String)"f0")}).cast(DataTypes.BINARY((int)3)), new byte[]{0, 1, -30}, (AbstractDataType<?>)DataTypes.BINARY((int)3)), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "cast from RAW(Integer) to BYTES").onFieldsWithData(123456).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).withFunction(IntegerToRaw.class).testTableApiResult((Expression)Expressions.call((String)"IntegerToRaw", (Object[])new Object[]{Expressions.$((String)"f0")}).cast(DataTypes.BYTES()), new byte[]{0, 1, -30, 64}, (AbstractDataType<?>)DataTypes.BYTES()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "cast from RAW(Integer) to BINARY(6)").onFieldsWithData(123456).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).withFunction(IntegerToRaw.class).testTableApiResult((Expression)Expressions.call((String)"IntegerToRaw", (Object[])new Object[]{Expressions.$((String)"f0")}).cast(DataTypes.BINARY((int)6)), new byte[]{0, 1, -30, 64, 0, 0}, (AbstractDataType<?>)DataTypes.BINARY((int)6)), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "cast from RAW(UserPojo) to VARBINARY").onFieldsWithData(123456, "Flink").andDataTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()}).withFunction(StructuredTypeConstructor.class).withFunction(PojoToRaw.class).testTableApiResult((Expression)Expressions.call((String)"PojoToRaw", (Object[])new Object[]{Expressions.call((String)"StructuredTypeConstructor", (Object[])new Object[]{Expressions.row((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f1")})})}).cast(DataTypes.VARBINARY((int)50)), new byte[]{0, 1, -30, 64, 0, 70, 0, 108, 0, 105, 0, 110, 0, 107}, (AbstractDataType<?>)DataTypes.VARBINARY((int)50)), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "test the x'....' binary syntax").onFieldsWithData("foo").testSqlResult("CAST(CAST(x'68656C6C6F20636F6465' AS BINARY(10)) AS VARCHAR)", "hello code", DataTypes.STRING().notNull()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "test the x'....' binary syntax").onFieldsWithData("foo").testSqlResult("CAST(CAST(x'68656C6C6F20636F6465' AS BINARY(5)) AS VARCHAR)", "hello", DataTypes.STRING().notNull()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "cast STRUCTURED to STRING").onFieldsWithData(123456, "Flink").andDataTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()}).withFunction(StructuredTypeConstructor.class).testTableApiResult((Expression)Expressions.call((String)"StructuredTypeConstructor", (Object[])new Object[]{Expressions.row((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f1")})}).cast(DataTypes.STRING()), "(i=123456, s=Flink)", (AbstractDataType<?>)DataTypes.STRING()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "cast MULTISET to STRING").onFieldsWithData(CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)"a", (Object)1), CollectionUtil.entry((Object)"b", (Object)2)})).andDataTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT())}).withFunction(JsonFunctionsITCase.CreateMultiset.class).testTableApiResult((Expression)Expressions.call((String)"CreateMultiset", (Object[])new Object[]{Expressions.$((String)"f0")}).cast(DataTypes.STRING()), "{a=1, b=2}", (AbstractDataType<?>)DataTypes.STRING()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "cast RAW to STRING").onFieldsWithData("2020-11-11T18:08:01.123").andDataTypes(new AbstractDataType[]{DataTypes.STRING()}).withFunction(LocalDateTimeToRaw.class).testTableApiResult((Expression)Expressions.call((String)"LocalDateTimeToRaw", (Object[])new Object[]{Expressions.$((String)"f0")}).cast(DataTypes.STRING()), "2020-11-11T18:08:01.123", (AbstractDataType<?>)DataTypes.STRING()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TRY_CAST, "try cast from STRING to TIME").onFieldsWithData("Flink", "12:34:56").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").tryCast(DataTypes.TIME()), "TRY_CAST(f0 AS TIME)", null, DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").tryCast(DataTypes.TIME()), "TRY_CAST(f1 AS TIME)", LocalTime.of(12, 34, 56, 0), DataTypes.TIME().nullable()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TRY_CAST, "try cast from TIME NOT NULL to STRING NOT NULL").onFieldsWithData(LocalTime.parse("12:34:56")).andDataTypes(DataTypes.TIME().notNull()).testResult((Expression)Expressions.$((String)"f0").tryCast(DataTypes.STRING()), "TRY_CAST(f0 AS STRING)", "12:34:56", DataTypes.STRING().nullable()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TRY_CAST, "try cast from ROW<INT, STRING> to ROW<TINYINT, TIME>").onFieldsWithData(Row.of((Object[])new Object[]{1, "abc"}), Row.of((Object[])new Object[]{1, "12:34:56"})).andDataTypes(new AbstractDataType[]{DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()})}).testResult((Expression)Expressions.$((String)"f0").tryCast(DataTypes.ROW((DataType[])new DataType[]{DataTypes.TINYINT(), DataTypes.TIME()})), "TRY_CAST(f0 AS ROW(f0 TINYINT, f1 TIME))", null, DataTypes.ROW((DataType[])new DataType[]{DataTypes.TINYINT(), DataTypes.TIME()}).nullable()).testResult((Expression)Expressions.$((String)"f1").tryCast(DataTypes.ROW((DataType[])new DataType[]{DataTypes.TINYINT(), DataTypes.TIME()})), "TRY_CAST(f1 AS ROW(f0 TINYINT, f1 TIME))", Row.of((Object[])new Object[]{(byte)1, LocalTime.of(12, 34, 56, 0)}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.TINYINT(), DataTypes.TIME()}).nullable()));
    }

    public static class LocalDateTimeToRaw
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=LocalDateTime.class, rawSerializer=LocalDateTimeSerializer.class)
        public LocalDateTime eval(String str) {
            return LocalDateTime.parse(str);
        }
    }

    public static class PojoToRaw
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=byte[].class)
        public byte[] eval(UserPojo up) {
            ByteBuffer b = ByteBuffer.allocate(up.s.length() * 2 + 4);
            b.putInt(up.i);
            for (char c : up.s.toCharArray()) {
                b.putChar(c);
            }
            return b.array();
        }
    }

    public static class IntegerToRaw
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=byte[].class)
        public byte[] eval(Integer i) {
            ByteBuffer b = ByteBuffer.allocate(4);
            b.putInt(i);
            return b.array();
        }
    }

    public static class UserPojo {
        public final Integer i;
        public final String s;

        public UserPojo(Integer i, String s) {
            this.i = i;
            this.s = s;
        }
    }

    public static class StructuredTypeConstructor
    extends ScalarFunction {
        public UserPojo eval(UserPojo pojo) {
            return pojo;
        }
    }

    public static class NestedRowToFirstField
    extends ScalarFunction {
        @DataTypeHint(value="ROW<i INT, d DOUBLE>")
        public Row eval(@DataTypeHint(value="ROW<r ROW<i INT, d DOUBLE>, s STRING>") Row row) {
            Assertions.assertThat((Object)row.getField(0)).isInstanceOf(Row.class);
            Assertions.assertThat((Object)row.getField(1)).isInstanceOf(String.class);
            return (Row)row.getField(0);
        }
    }

    public static class RowToFirstField
    extends ScalarFunction {
        public Integer eval(@DataTypeHint(value="ROW<i INT, s STRING>") Row row) {
            Assertions.assertThat((Object)row.getField(0)).isInstanceOf(Integer.class);
            Assertions.assertThat((Object)row.getField(1)).isInstanceOf(String.class);
            return (Integer)row.getField(0);
        }
    }
}

