/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.planner.expressions.utils.ScalarTypesTestBase;
import org.junit.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001#\ti2kY1mCJ4UO\\2uS>t7OV1mS\u0012\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011aC3yaJ,7o]5p]NT!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)B!A\u0003vi&d7/\u0003\u0002\u0018)\t\u00192kY1mCJ$\u0016\u0010]3t)\u0016\u001cHOQ1tK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!\taH\u0001\u0010i\u0016\u001cH/\u00138wC2LGMQ5ocQ\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\b\u0006B\u000f([9\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\b\u0002\u000b),h.\u001b;\n\u00051J#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002_A\u0011\u0001gM\u0007\u0002c)\u0011!\u0007C\u0001\u0004CBL\u0017B\u0001\u001b2\u0005M1\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8o\u0011\u00151\u0004\u0001\"\u0001 \u0003=!Xm\u001d;J]Z\fG.\u001b3CS:\u0014\u0004\u0006B\u001b([9BQ!\u000f\u0001\u0005\u0002}\tq\u0002^3ti&sg/\u00197jI\nKgn\r\u0015\u0005q\u001djc\u0006C\u0003=\u0001\u0011\u0005q$\u0001\u000buKN$\u0018J\u001c<bY&$GK];oG\u0006$X-\r\u0015\u0005w\u001djc\u0006C\u0003@\u0001\u0011\u0005q$\u0001\u000buKN$\u0018J\u001c<bY&$GK];oG\u0006$XM\r\u0015\u0003}\u001dBQA\u0011\u0001\u0005\u0002}\tQ\u0003^3ti&sg/\u00197jIN+(m\u001d;sS:<\u0017\u0007\u000b\u0003BO5r\u0003\"B#\u0001\t\u0003y\u0012!\u0006;fgRLeN^1mS\u0012\u001cVOY:ue&twM\r\u0015\u0005\t\u001ejc\u0006C\u0003I\u0001\u0011\u0005q$\u0001\u0016uKN$H+[7fgR\fW\u000e]!eI^KG\u000f[,s_:<G+[7fgR\fW\u000e]%oi\u0016\u0014h/\u00197)\t\u001d;SFS\u0012\u0002\u0017B\u0011\u0001\u0007T\u0005\u0003\u001bF\u0012!cU9m!\u0006\u00148/\u001a:Fq\u000e,\u0007\u000f^5p]\")q\n\u0001C\u0001?\u0005AC/Z:u)&lWm\u001d;b[B\fE\rZ,ji\"<&o\u001c8h)&lWm\u001d;b[B4uN]7bi\"\"ajJ\u0017K\u0011\u0015\u0011\u0006\u0001\"\u0001 \u0003\u0005\"Xm\u001d;US6,7\u000f^1na\u0006#GmV5uQ^\u0013xN\\4Rk\u0006tG/\u001b;zQ\u0011\tv%\f\u0018\t\u000bU\u0003A\u0011A\u0010\u0002SQ,7\u000f^%o-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\\'pe\u0016$\u0006.\u00198P]\u0016$\u0016\u0010]3tQ\u0011!v%\f\u0018\t\u000ba\u0003A\u0011A\u0010\u0002_M\u001c\u0017\r\\1J]Z\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8ES\u001a4WM]3oi>\u0003XM]1oIN$Vm\u001d;)\t];SF\f\u0005\u00067\u0002!\taH\u0001\u001fi\u0016\u001cH\u000fV5nKN$\u0018-\u001c9ES\u001a4w+\u001b;i/J|gn\u001a+j[\u0016DCAW\u0014.]!)a\f\u0001C\u0001?\u0005)C/Z:u)&lWm\u001d;b[B$\u0015N\u001a4XSRDwK]8oORKW.Z!oIVs\u0017\u000e\u001e\u0015\u0005;\u001ejc\u0006C\u0003b\u0001\u0011\u0005q$\u0001\fuKN$\u0018J\u001c<bY&$7\u000b\u001e:j]\u001e$v.T1qQ\t\u0001w\u0005C\u0003e\u0001\u0011\u0005q$A\u0007uKN$\u0018J\u001c<bY&$\u0017J\u001a\u0015\u0003G\u001eBQa\u001a\u0001\u0005\u0002}\t1\u0003^3ti&sg/\u00197jIR{')Y:fmQB#AZ\u0014")
public class ScalarFunctionsValidationTest
extends ScalarTypesTestBase {
    @Test(expected=ValidationException.class)
    public void testInvalidBin1() {
        this.testSqlApi("BIN(f12)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidBin2() {
        this.testSqlApi("BIN(f15)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidBin3() {
        this.testSqlApi("BIN(f16)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidTruncate1() {
        this.testSqlApi("TRUNCATE('abc', 'def')", "FAIL");
        this.testSqlApi("TRUNCATE(f12, f0)", "FAIL");
        this.testSqlApi("TRUNCATE(f12,f12)", "FAIL");
        this.testSqlApi("TRUNCATE(f12, cast(f28 as DOUBLE))", "FAIL");
        this.testSqlApi("TRUNCATE(f12,f15)", "FAIL");
    }

    @Test
    public void testInvalidTruncate2() {
        this.thrown().expect(ValidationException.class);
        this.testSqlApi("TRUNCATE('abc')", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidSubstring1() {
        this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring((Object)package$.MODULE$.LiteralDoubleExpression(2.0).toExpr()), "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidSubstring2() {
        this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring((Object)package$.MODULE$.LiteralStringExpression("test").toExpr()), "FAIL");
    }

    @Test(expected=SqlParserException.class)
    public void testTimestampAddWithWrongTimestampInterval() {
        this.testSqlApi("TIMESTAMPADD(XXX, 1, timestamp '2016-02-24'))", "2016-06-16");
    }

    @Test(expected=SqlParserException.class)
    public void testTimestampAddWithWrongTimestampFormat() {
        this.testSqlApi("TIMESTAMPADD(YEAR, 1, timestamp '2016-02-24'))", "2016-06-16");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampAddWithWrongQuantity() {
        this.testSqlApi("TIMESTAMPADD(YEAR, 1.0, timestamp '2016-02-24 12:42:25')", "2016-06-16");
    }

    @Test(expected=ValidationException.class)
    public void testInValidationExceptionMoreThanOneTypes() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).in((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8"))}), "TRUE");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).in((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.int2Literal(4)}), "FALSE");
    }

    @Test(expected=ValidationException.class)
    public void scalaInValidationExceptionDifferentOperandsTest() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).in((Object[])new Expression[]{package$.MODULE$.string2Literal("Hi"), package$.MODULE$.string2Literal("Hello world"), package$.MODULE$.string2Literal("Comment#1")}), "TRUE");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampDiffWithWrongTime() {
        this.testTableApi(package$.MODULE$.timestampDiff(TimePointUnit.DAY, package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampDiffWithWrongTimeAndUnit() {
        this.testTableApi(package$.MODULE$.timestampDiff(TimePointUnit.MINUTE, package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL");
    }

    @Test
    public void testInvalidStringToMap() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Invalid number of arguments to function 'STR_TO_MAP'");
        this.testSqlApi("STR_TO_MAP('k1:v1;k2:v2', ';')", "EXCEPTION");
    }

    @Test
    public void testInvalidIf() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Cannot apply 'IF' to arguments");
        this.testSqlApi("IF(f7 > 5, f0, f1)", "FAIL");
    }

    @Test
    public void testInvalidToBase64() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Cannot apply 'TO_BASE64' to arguments of type 'TO_BASE64(<INTEGER>)'");
        this.testSqlApi("TO_BASE64(11)", "FAIL");
    }
}

