/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqOptimized;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ResizableArray;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011md!B\u0001\u0003\u0003\u0003\t\"AE#yaJ,7o]5p]R+7\u000f\u001e\"bg\u0016T!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u00151\u0011aC3yaJ,7o]5p]NT!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0003 \u0003)1\u0018\r\\5e\u000bb\u0004(o]\u000b\u0002AA\u0019\u0011E\n\u0015\u000e\u0003\tR!a\t\u0013\u0002\u000f5,H/\u00192mK*\u0011Q\u0005F\u0001\u000bG>dG.Z2uS>t\u0017BA\u0014#\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u000bMI3FN\u0016\n\u0005)\"\"A\u0002+va2,7\u0007\u0005\u0002-g9\u0011Q&\r\t\u0003]Qi\u0011a\f\u0006\u0003aA\ta\u0001\u0010:p_Rt\u0014B\u0001\u001a\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\"\u0002CA\u001c=\u001b\u0005A$BA\u001d;\u0003\r\u0011X\r\u001f\u0006\u0003w1\tqaY1mG&$X-\u0003\u0002>q\t9!+\u001a=O_\u0012,\u0007BB \u0001A\u0003%\u0001%A\u0006wC2LG-\u0012=qeN\u0004\u0003bB!\u0001\u0005\u0004%IAQ\u0001\u0010S:4\u0018\r\\5e'FdW\t\u001f9sgV\t1\tE\u0002\"M\u0011\u0003RaE\u0015F\u000b2\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\t1\fgn\u001a\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\t!t\t\r\u0002N%B\u0019aI\u0014)\n\u0005=;%!B\"mCN\u001c\bCA)S\u0019\u0001!\u0011b\u0015+\u0002\u0002\u0003\u0005)\u0011\u0001,\u0003\u0007}#\u0013\u0007\u0003\u0004V\u0001\u0001\u0006IaQ\u0001\u0011S:4\u0018\r\\5e'FdW\t\u001f9sg\u0002\n\"a\u0016.\u0011\u0005MA\u0016BA-\u0015\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AR.\n\u0005q;%!\u0003+ie><\u0018M\u00197f\u0011\u001dq\u0006A1A\u0005\n}\u000bA#\u001b8wC2LG\rV1cY\u0016\f\u0005/[#yaJ\u001cX#\u00011\u0011\u0007\u00052\u0013\rE\u0003\u0014S\t,u\r\u0005\u0002dK6\tAM\u0003\u0002\u0006\u0011%\u0011a\r\u001a\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007G\u00015k!\r1e*\u001b\t\u0003#*$\u0011b\u001b7\u0002\u0002\u0003\u0005)\u0011\u0001,\u0003\u0007}##\u0007\u0003\u0004n\u0001\u0001\u0006I\u0001Y\u0001\u0016S:4\u0018\r\\5e)\u0006\u0014G.Z!qS\u0016C\bO]:!\u0011\u001dy\u0007A1A\u0005\nA\f1!\u001a8w+\u0005\t\bC\u0001:z\u001b\u0005\u0019(B\u0001;v\u0003-)gN^5s_:lWM\u001c;\u000b\u0005Y<\u0018aA1qS*\u0011\u0001PC\u0001\ngR\u0014X-Y7j]\u001eL!A_:\u0003-1{7-\u00197TiJ,\u0017-\\#om&\u0014xN\\7f]RDa\u0001 \u0001!\u0002\u0013\t\u0018\u0001B3om\u0002BqA \u0001C\u0002\u0013%q0\u0001\u0005tKR$\u0018N\\4t+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005\u001dQBAA\u0003\u0015\t1\b\"\u0003\u0003\u0002\n\u0005\u0015!aE#om&\u0014xN\\7f]R\u001cV\r\u001e;j]\u001e\u001c\b\u0002CA\u0007\u0001\u0001\u0006I!!\u0001\u0002\u0013M,G\u000f^5oON\u0004\u0003\"CA\t\u0001\t\u0007I\u0011BA\n\u0003\u0011!XI\u001c<\u0016\u0005\u0005U\u0001\u0003BA\f\u0003Gi!!!\u0007\u000b\t\u0005m\u0011QD\u0001\tS:$XM\u001d8bY*\u0019!*a\b\u000b\t\u0005\u0005\u0012QA\u0001\u0007EJLGmZ3\n\t\u0005\u0015\u0012\u0011\u0004\u0002\u001b'R\u0014X-Y7UC\ndW-\u00128wSJ|g.\\3oi&k\u0007\u000f\u001c\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\u0016\u0005)A/\u00128wA!I\u0011Q\u0006\u0001C\u0002\u0013\u0005\u0011qF\u0001\fi\u0006\u0014G.Z\"p]\u001aLw-\u0006\u0002\u00022A!\u00111AA\u001a\u0013\u0011\t)$!\u0002\u0003\u0017Q\u000b'\r\\3D_:4\u0017n\u001a\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u00022\u0005aA/\u00192mK\u000e{gNZ5hA!I\u0011Q\b\u0001C\u0002\u0013%\u0011qH\u0001\u0011e\u0016\u001cx\u000e\u001c<fI\u0012\u000bG/\u0019+za\u0016,\"!!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012\t\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY%!\u0012\u0003\u0011\u0011\u000bG/\u0019+za\u0016D\u0001\"a\u0014\u0001A\u0003%\u0011\u0011I\u0001\u0012e\u0016\u001cx\u000e\u001c<fI\u0012\u000bG/\u0019+za\u0016\u0004\u0003\u0002C\u0004\u0001\u0005\u0004%I!a\u0015\u0016\u0005\u0005U\u0003\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005mc!\u0001\u0006eK2,w-\u0019;j_:LA!a\u0018\u0002Z\tY\u0001\u000b\\1o]\u0016\u0014()Y:f\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005U\u0013\u0001\u00039mC:tWM\u001d\u0011\t\u0013\u0005\u001d\u0004A1A\u0005\n\u0005%\u0014A\u0003:fY\n+\u0018\u000e\u001c3feV\u0011\u00111\u000e\t\u0005\u0003[\n\t(\u0004\u0002\u0002p)\u00111HB\u0005\u0005\u0003g\nyGA\bGY&t7NU3m\u0005VLG\u000eZ3s\u0011!\t9\b\u0001Q\u0001\n\u0005-\u0014a\u0003:fY\n+\u0018\u000e\u001c3fe\u0002B\u0011\"a\u001f\u0001\u0005\u0004%I!! \u0002\u001d\r\fGnY5uKBc\u0017M\u001c8feV\u0011\u0011q\u0010\t\u0005\u0003[\n\t)\u0003\u0003\u0002\u0004\u0006=$\u0001\u0005$mS:\\\u0007\u000b\\1o]\u0016\u0014\u0018*\u001c9m\u0011!\t9\t\u0001Q\u0001\n\u0005}\u0014aD2bY\u000eLG/\u001a)mC:tWM\u001d\u0011\t\u0013\u0005-\u0005A1A\u0005\n\u00055\u0015A\u00029beN,'/\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016\u001a\tQ\u0001]1sg\u0016LA!!'\u0002\u0014\ni1)\u00197dSR,\u0007+\u0019:tKJD\u0001\"!(\u0001A\u0003%\u0011qR\u0001\ba\u0006\u00148/\u001a:!\u0011%\t\t\u000b\u0001b\u0001\n\u0013\t\u0019+A\u0005uC\ndWMT1nKV\tQ\tC\u0004\u0002(\u0002\u0001\u000b\u0011B#\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005C\u0005\u0002,\u0002\u0011\r\u0011\"\u0005\u0002$\u0006Aa.\u001e7mC\ndW\rC\u0004\u00020\u0002\u0001\u000b\u0011B#\u0002\u00139,H\u000e\\1cY\u0016\u0004\u0003\"CAZ\u0001\t\u0007I\u0011AA[\u0003E)\u0007\u0010]3di\u0016$W\t_2faRLwN\\\u000b\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0003sk2,7OC\u0002\u0002B:\tQA[;oSRLA!!2\u0002<\n\tR\t\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8\t\u0011\u0005%\u0007\u0001)A\u0005\u0003o\u000b!#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8oA!9\u0011Q\u001a\u0001\u0005\u0002\u0005U\u0016A\u0002;ie><h\u000e\u000b\u0003\u0002L\u0006E\u0007\u0003BAj\u0003+l!!a0\n\t\u0005]\u0017q\u0018\u0002\u0005%VdW\rC\u0004\u0002\\\u0002!\t!!8\u0002\u000fA\u0014X\r]1sKR\u0011\u0011q\u001c\t\u0004'\u0005\u0005\u0018bAAr)\t!QK\\5uQ\u0011\tI.a:\u0011\t\u0005M\u0017\u0011^\u0005\u0005\u0003W\fyL\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003_\u0004A\u0011AAo\u00035)g/\u00197vCR,W\t\u001f9sg\"\"\u0011Q^Az!\u0011\t\u0019.!>\n\t\u0005]\u0018q\u0018\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003w\u0004A\u0011AA\u007f\u0003-!Xm\u001d;BY2\f\u0005/[:\u0015\u0011\u0005}\u0017q B\u0002\u0005\u000fAqA!\u0001\u0002z\u0002\u0007!-\u0001\u0003fqB\u0014\bb\u0002B\u0003\u0003s\u0004\raK\u0001\bgFdW\t\u001f9s\u0011\u001d\u0011I!!?A\u0002-\n\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u00031!Xm\u001d;UC\ndW-\u00119j)\u0019\tyN!\u0005\u0003\u0014!9!\u0011\u0001B\u0006\u0001\u0004\u0011\u0007b\u0002B\u0005\u0005\u0017\u0001\ra\u000b\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0003)!Xm\u001d;Tc2\f\u0005/\u001b\u000b\u0007\u0003?\u0014YB!\b\t\u000f\t\u0015!Q\u0003a\u0001W!9!\u0011\u0002B\u000b\u0001\u0004Y\u0003b\u0002B\u0011\u0001\u0011\u0005!1E\u0001\u001di\u0016\u001cH/\u0012=qK\u000e$X\rZ!mY\u0006\u0003\u0018n]#yG\u0016\u0004H/[8o))\tyN!\n\u0003(\t%\"Q\u0006\u0005\b\u0005\u0003\u0011y\u00021\u0001c\u0011\u001d\u0011)Aa\bA\u0002-BqAa\u000b\u0003 \u0001\u00071&\u0001\u0005lKf<xN\u001d3t\u0011)\u0011yCa\b\u0011\u0002\u0003\u0007!\u0011G\u0001\u0006G2\f'P\u001f\u0019\u0005\u0005g\u0011I\u0004E\u0003-\u0005k\u00119$\u0003\u0002PkA\u0019\u0011K!\u000f\u0005\u0019\tm\"QFA\u0001\u0002\u0003\u0015\tA!\u0010\u0003\u0007}#3'E\u0002X\u0005\u007f\u0001BA!\u0011\u0003L9!!1\tB$\u001d\rq#QI\u0005\u0002+%\u0019!\u0011\n\u000b\u0002\u000fA\f7m[1hK&\u0019AL!\u0014\u000b\u0007\t%C\u0003C\u0004\u0003R\u0001!\tAa\u0015\u00021Q,7\u000f^#ya\u0016\u001cG/\u001a3Tc2,\u0005pY3qi&|g\u000e\u0006\u0005\u0002`\nU#q\u000bB-\u0011\u001d\u0011)Aa\u0014A\u0002-BqAa\u000b\u0003P\u0001\u00071\u0006\u0003\u0006\u00030\t=\u0003\u0013!a\u0001\u00057\u0002DA!\u0018\u0003bA)AF!\u000e\u0003`A\u0019\u0011K!\u0019\u0005\u0019\t\r$\u0011LA\u0001\u0002\u0003\u0015\tA!\u0010\u0003\u0007}#C\u0007C\u0004\u0003h\u0001!\tA!\u001b\u0002;Q,7\u000f^#ya\u0016\u001cG/\u001a3UC\ndW-\u00119j\u000bb\u001cW\r\u001d;j_:$\u0002\"a8\u0003l\t5$q\u000e\u0005\b\u0005\u0003\u0011)\u00071\u0001c\u0011\u001d\u0011YC!\u001aA\u0002-B!Ba\f\u0003fA\u0005\t\u0019\u0001B9a\u0011\u0011\u0019Ha\u001e\u0011\u000b1\u0012)D!\u001e\u0011\u0007E\u00139\b\u0002\u0007\u0003z\t=\u0014\u0011!A\u0001\u0006\u0003\u0011iDA\u0002`IUBqA! \u0001\t\u0003\u0011y(A\nhKR\u001cu\u000eZ3HK:4UO\\2uS>t7\u000f\u0006\u0003\u0003\u0002\nm\u0006C\u0002BB\u0005\u001b\u0013\t*\u0004\u0002\u0003\u0006*!!q\u0011BE\u0003%9WM\\3sCR,GMC\u0002\u0003\f\"\tqA];oi&lW-\u0003\u0003\u0003\u0010\n\u0015%!E$f]\u0016\u0014\u0018\r^3e\rVt7\r^5p]BA!1\u0013BP\u0005G\u0013y+\u0004\u0002\u0003\u0016*!!q\u0013BM\u0003%1WO\\2uS>t7O\u0003\u0003\u0003\u001c\nu\u0015AB2p[6|gN\u0003\u0002w\u0015%!!\u0011\u0015BK\u0005-i\u0015\r\u001d$v]\u000e$\u0018n\u001c8\u0011\t\t\u0015&1V\u0007\u0003\u0005OS1A!+\t\u0003\u0011!\u0017\r^1\n\t\t5&q\u0015\u0002\b%><H)\u0019;b!\u0011\u0011\tLa.\u000e\u0005\tM&\u0002\u0002B[\u0005O\u000baAY5oCJL\u0018\u0002\u0002B]\u0005g\u0013QBQ5oCJL(k\\<ECR\f\u0007\u0002\u0003B_\u0005w\u0002\rAa0\u0002\u0011M\fH.\u0012=qeN\u0004RA!\u0011\u0003B.JAAa1\u0003N\t!A*[:u\u0011\u001d\u00119\r\u0001C\u0001\u0005\u0013\fa#\u001a<bYV\fG/\u001a$v]\u000e$\u0018n\u001c8SKN,H\u000e\u001e\u000b\u0005\u0005\u007f\u0013Y\r\u0003\u0005\u0003N\n\u0015\u0007\u0019\u0001BA\u0003E9WM\\3sCR,GMR;oGRLwN\u001c\u0005\b\u0005#\u0004A\u0011\u0002Bj\u00039\tG\rZ*rYR+7\u000f^#yaJ$\"\"a8\u0003V\n]'\u0011\u001cBx\u0011\u001d\u0011)Aa4A\u0002-BqA!\u0003\u0003P\u0002\u00071\u0006\u0003\u0005\u0003\\\n=\u0007\u0019\u0001Bo\u00039)\u0007\u0010\u001d:t\u0007>tG/Y5oKJ\u0004DAa8\u0003dB!\u0011E\nBq!\r\t&1\u001d\u0003\r\u0005K\u0014I.!A\u0001\u0002\u000b\u0005!q\u001d\u0002\u0005?\u0012\n\u0004'E\u0002X\u0005S\u00042a\u0005Bv\u0013\r\u0011i\u000f\u0006\u0002\u0004\u0003:L\bB\u0003By\u0005\u001f\u0004\n\u00111\u0001\u0003t\u0006qQ\r_2faRLwN\\\"mCN\u001c\b\u0007\u0002B{\u0005s\u0004R\u0001\fB\u001b\u0005o\u00042!\u0015B}\t1\u0011YPa<\u0002\u0002\u0003\u0005)\u0011\u0001B\u001f\u0005\u0011yF%M\u0019\t\u000f\t}\b\u0001\"\u0003\u0004\u0002\u0005\u0019\u0012\r\u001a3UC\ndW-\u00119j)\u0016\u001cH/\u0012=qeRQ\u0011q\\B\u0002\u0007\u000f\u0019Ia!\u0006\t\u000f\r\u0015!Q a\u0001E\u0006aA/\u00192mK\u0006\u0003\u0018.\u0012=qe\"9!\u0011\u0002B\u007f\u0001\u0004Y\u0003\u0002\u0003Bn\u0005{\u0004\raa\u00031\t\r51\u0011\u0003\t\u0005C\u0019\u001ay\u0001E\u0002R\u0007#!Aba\u0005\u0004\n\u0005\u0005\t\u0011!B\u0001\u0005O\u0014Aa\u0018\u00132e!Q!\u0011\u001fB\u007f!\u0003\u0005\raa\u00061\t\re1Q\u0004\t\u0006Y\tU21\u0004\t\u0004#\u000euA\u0001DB\u0010\u0007+\t\t\u0011!A\u0003\u0002\tu\"\u0001B0%cMBqaa\t\u0001\t\u0013\u0019)#A\u0006bI\u0012$Vm\u001d;FqB\u0014H\u0003DAp\u0007O\u00199d!\u000f\u0004>\r%\u0003\u0002CB\u0015\u0007C\u0001\raa\u000b\u0002\u000fI,GNT8eKB!1QFB\u001a\u001b\t\u0019yCC\u0002\u00042i\n1A]3m\u0013\u0011\u0019)da\f\u0003\u000fI+GNT8eK\"9!\u0011BB\u0011\u0001\u0004Y\u0003bBB\u001e\u0007C\u0001\raK\u0001\u000egVlW.\u0019:z'R\u0014\u0018N\\4\t\u0011\tE8\u0011\u0005a\u0001\u0007\u007f\u0001Da!\u0011\u0004FA)AF!\u000e\u0004DA\u0019\u0011k!\u0012\u0005\u0019\r\u001d3QHA\u0001\u0002\u0003\u0015\tA!\u0010\u0003\t}#\u0013\u0007\u000e\u0005\t\u0007\u0017\u001a\t\u00031\u0001\u0004N\u0005)Q\r\u001f9sgB\"1qJB*!\u0011\tce!\u0015\u0011\u0007E\u001b\u0019\u0006\u0002\u0007\u0004V\r%\u0013\u0011!A\u0001\u0006\u0003\u00119O\u0001\u0003`IE*\u0004bBB-\u0001\u0011%11L\u0001\u000fKb$(/Y2u%\u0016Dhj\u001c3f)\r14Q\f\u0005\t\u0007?\u001a9\u00061\u0001\u0004,\u0005!an\u001c3f\u0011\u001d\u0019\u0019\u0007\u0001C\u0005\u0007K\n!#\u001a<bYV\fG/Z$jm\u0016tW\t\u001f9sgR!\u0011q\\B4\u0011\u001d\u0019Ig!\u0019A\u0002\u0001\n\u0011\"\u001a=qe\u0006\u0013(/Y=\t\u000f\r5\u0004\u0001\"\u0003\u0004p\u0005\u0011r-\u001a;D_\u0012,w)\u001a8Gk:\u001cG/[8o)\u0011\u0011\ti!\u001d\t\u0011\rM41\u000ea\u0001\u0007k\n\u0001B]3y\u001d>$Wm\u001d\t\u0006\u0005\u0003\u0012\tM\u000e\u0005\b\u0007s\u0002a\u0011AB>\u0003!!Xm\u001d;ECR\fWCAB?!\u0011\u0019yha!\u000e\u0005\r\u0005%bAA$\u0015%!1QQBA\u0005\r\u0011vn\u001e\u0005\b\u0007\u0013\u0003A\u0011ABF\u00031!Xm\u001d;ECR\fG+\u001f9f+\t\u0019i\t\r\u0003\u0004\u0010\u000e]\u0005CBA\"\u0007#\u001b)*\u0003\u0003\u0004\u0014\u0006\u0015#\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f!\r\t6q\u0013\u0003\r\u00073\u001b9)!A\u0001\u0002\u000b\u0005!q\u001d\u0002\u0005?\u0012\nd\u0007C\u0004\u0004\u001e\u0002!\taa(\u0002'Q,7\u000f^*zgR,WNR;oGRLwN\\:\u0016\u0005\r\u0005\u0006cBBR\u0007S[3QV\u0007\u0003\u0007KS1aa*J\u0003\u0011)H/\u001b7\n\t\r-6Q\u0015\u0002\u0004\u001b\u0006\u0004\b\u0003BBX\u0007gk!a!-\u000b\u0007\t]\u0005\"\u0003\u0003\u00046\u000eE&AD*dC2\f'OR;oGRLwN\u001c\u0005\b\u0007s\u0003A\u0011AB^\u0003M\u0019wN\u001c;bS:\u001cH*Z4bGf$\u0016\u0010]3t+\t\u0019i\fE\u0002\u0014\u0007\u007fK1a!1\u0015\u0005\u001d\u0011un\u001c7fC:DqAa&\u0001\t\u0003\u0019)-\u0006\u0002\u0004HB1Af!3,\u0007[K1aa+6Q!\u0019\u0019m!4\u0004T\u000e\u001d\bcA\n\u0004P&\u00191\u0011\u001b\u000b\u0003\u0015\u0011,\u0007O]3dCR,G-\r\u0005$W\rU7Q\\Bl\u0013\u0011\u00199n!7\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\u0019Y\u000eF\u0001\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'C\u0012\u0004`\u000e\u000581]Bn\u001d\r\u00192\u0011]\u0005\u0004\u00077$\u0012'\u0002\u0012\u0014)\r\u0015(!B:dC2\f\u0017\u0007C\u0012,\u0007S\u001cioa;\n\t\r-8\u0011\\\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a2\u0013\r\u001ayn!9\u0004p\u000em\u0017'\u0002\u0012\u0014)\r\u0015\bbBBz\u0001\u0011\u00051Q_\u0001\tif\u0004X-\u00138g_V\u00111q\u001f\t\u0005\u0007s$\t!\u0004\u0002\u0004|*!1Q`B\u0000\u0003%!\u0018\u0010]3vi&d7OC\u0002K\u0005;KA\u0001b\u0001\u0004|\nY!k\\<UsB,\u0017J\u001c4pQ!\u0019\tp!4\u0005\b\u00115\u0011\u0007C\u0012,\u0007+$Iaa62\u0013\r\u001ayn!9\u0005\f\rm\u0017'\u0002\u0012\u0014)\r\u0015\u0018\u0007C\u0012,\u0007S$yaa;2\u0013\r\u001ayn!9\u0005\u0012\rm\u0017'\u0002\u0012\u0014)\r\u0015\bb\u0002C\u000b\u0001\u0011\u0005AqC\u0001\ri&lWm\u001d;b[BdEO\u001f\u000b\u0004W\u0011e\u0001b\u0002C\u000e\t'\u0001\raK\u0001\u0004gR\u0014\bb\u0002C\u000b\u0001\u0011\u0005Aq\u0004\u000b\u0006W\u0011\u0005B1\u0005\u0005\b\t7!i\u00021\u0001,\u0011!!)\u0003\"\bA\u0002\u0011\u001d\u0012!\u00039sK\u000eL7/[8o!\r\u0019B\u0011F\u0005\u0004\tW!\"aA%oi\"9Aq\u0006\u0001\u0005\n\u0011E\u0012\u0001E3yiJ\f7\r\u001e)sK\u000eL7/[8o)\u0011!9\u0003b\r\t\u000f\u0011mAQ\u0006a\u0001W!IAq\u0007\u0001\u0012\u0002\u0013\u0005A\u0011H\u0001#i\u0016\u001cH/\u0012=qK\u000e$X\rZ*rY\u0016C8-\u001a9uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0011m\u0002\u0007\u0002C\u001f\t\u0003\u0002R\u0001\fB\u001b\t\u007f\u00012!\u0015C!\t1\u0011\u0019\u0007\"\u000e\u0002\u0002\u0003\u0005)\u0011\u0001B\u001f\u0011%!)\u0005AI\u0001\n\u0003!9%\u0001\u0014uKN$X\t\u001f9fGR,G-\u00117m\u0003BL7/\u0012=dKB$\u0018n\u001c8%I\u00164\u0017-\u001e7uIQ*\"\u0001\"\u00131\t\u0011-Cq\n\t\u0006Y\tUBQ\n\t\u0004#\u0012=C\u0001\u0004B\u001e\t\u0007\n\t\u0011!A\u0003\u0002\tu\u0002\"\u0003C*\u0001E\u0005I\u0011\u0001C+\u0003\u001d\"Xm\u001d;FqB,7\r^3e)\u0006\u0014G.Z!qS\u0016C8-\u001a9uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0011]\u0003\u0007\u0002C-\t;\u0002R\u0001\fB\u001b\t7\u00022!\u0015C/\t1\u0011I\b\"\u0015\u0002\u0002\u0003\u0005)\u0011\u0001B\u001f\u0011%!\t\u0007AI\u0001\n\u0013!\u0019'\u0001\rbI\u0012\u001c\u0016\u000f\u001c+fgR,\u0005\u0010\u001d:%I\u00164\u0017-\u001e7uIQ*\"\u0001\"\u001a1\t\u0011\u001dD1\u000e\t\u0006Y\tUB\u0011\u000e\t\u0004#\u0012-D\u0001\u0004B~\t?\n\t\u0011!A\u0003\u0002\tu\u0002\"\u0003C8\u0001E\u0005I\u0011\u0002C9\u0003u\tG\r\u001a+bE2,\u0017\t]5UKN$X\t\u001f9sI\u0011,g-Y;mi\u0012\"TC\u0001C:a\u0011!)\b\"\u001f\u0011\u000b1\u0012)\u0004b\u001e\u0011\u0007E#I\b\u0002\u0007\u0004 \u00115\u0014\u0011!A\u0001\u0006\u0003\u0011i\u0004")
public abstract class ExpressionTestBase {
    private final ArrayBuffer<Tuple3<String, RexNode, String>> validExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final ArrayBuffer<Tuple3<String, String, Class<? extends Throwable>>> invalidSqlExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final ArrayBuffer<Tuple3<Expression, String, Class<? extends Throwable>>> invalidTableApiExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment((int)4);
    private final EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
    private final StreamTableEnvironmentImpl tEnv = (StreamTableEnvironmentImpl)StreamTableEnvironmentImpl.create((StreamExecutionEnvironment)this.env(), (EnvironmentSettings)this.settings());
    private final TableConfig tableConfig = this.tEnv().getConfig();
    private final DataType resolvedDataType = this.containsLegacyTypes() ? TypeConversions.fromLegacyInfoToDataType((TypeInformation)this.typeInfo()) : this.tEnv().getCatalogManager().getDataTypeFactory().createDataType(this.testDataType());
    private final PlannerBase planner = (PlannerBase)this.tEnv().getPlanner();
    private final FlinkRelBuilder relBuilder = this.planner().createRelBuilder();
    private final FlinkPlannerImpl calcitePlanner = this.planner().createFlinkPlanner();
    private final CalciteParser parser = this.planner().plannerContext().createCalciteParser();
    private final String tableName;
    private final String nullable;
    private final ExpectedException expectedException = ExpectedException.none();

    private ArrayBuffer<Tuple3<String, RexNode, String>> validExprs() {
        return this.validExprs;
    }

    private ArrayBuffer<Tuple3<String, String, Class<? extends Throwable>>> invalidSqlExprs() {
        return this.invalidSqlExprs;
    }

    private ArrayBuffer<Tuple3<Expression, String, Class<? extends Throwable>>> invalidTableApiExprs() {
        return this.invalidTableApiExprs;
    }

    private LocalStreamEnvironment env() {
        return this.env;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private StreamTableEnvironmentImpl tEnv() {
        return this.tEnv;
    }

    public TableConfig tableConfig() {
        return this.tableConfig;
    }

    private DataType resolvedDataType() {
        return this.resolvedDataType;
    }

    private PlannerBase planner() {
        return this.planner;
    }

    private FlinkRelBuilder relBuilder() {
        return this.relBuilder;
    }

    private FlinkPlannerImpl calcitePlanner() {
        return this.calcitePlanner;
    }

    private CalciteParser parser() {
        return this.parser;
    }

    private String tableName() {
        return this.tableName;
    }

    public String nullable() {
        return this.nullable;
    }

    public ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    @Before
    public void prepare() {
        this.tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR, (Object)ExecutionConfigOptions.LegacyCastBehaviour.DISABLED);
        if (this.containsLegacyTypes()) {
            DataStreamSource ds = this.env().fromCollection(Collections.emptyList(), (TypeInformation)this.typeInfo());
            this.tEnv().createTemporaryView(this.tableName(), (DataStream)ds, (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.typeInfo().getFieldNames())).map((Function1 & Serializable & scala.Serializable)name -> package$.MODULE$.$(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))));
            this.functions().foreach((Function1 & Serializable & scala.Serializable)f -> {
                ExpressionTestBase.$anonfun$prepare$2(this, f);
                return BoxedUnit.UNIT;
            });
        } else {
            this.tEnv().createTemporaryView(this.tableName(), this.tEnv().fromValues((AbstractDataType)this.resolvedDataType(), new Expression[0]));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.testSystemFunctions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                ExpressionTestBase.$anonfun$prepare$3(this, e);
                return BoxedUnit.UNIT;
            });
        }
        this.relBuilder().scan(new String[]{this.tableName()});
        this.validExprs().clear();
        this.invalidSqlExprs().clear();
        this.invalidTableApiExprs().clear();
    }

    @After
    public void evaluateExprs() {
        this.evaluateGivenExprs(this.validExprs());
        this.invalidSqlExprs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExpressionTestBase.$anonfun$evaluateExprs$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.invalidTableApiExprs().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Expression tableExpr = (Expression)tuple3._1();
            String keywords = (String)tuple3._2();
            Class clazz = (Class)tuple3._3();
            ThrowingConsumer assertion = keywords != null ? FlinkAssertions.anyCauseMatches((Class)clazz, (String)keywords) : FlinkAssertions.anyCauseMatches((Class)clazz);
            AbstractThrowableAssert abstractThrowableAssert = (AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                ArrayBuffer invalidExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.addTableApiTestExpr(tableExpr, keywords, invalidExprs, clazz);
                this.evaluateGivenExprs((ArrayBuffer<Tuple3<String, RexNode, String>>)invalidExprs);
            }).satisfies(new ThrowingConsumer[]{assertion});
            return abstractThrowableAssert;
        });
    }

    public void testAllApis(Expression expr, String sqlExpr, String expected) {
        this.addTableApiTestExpr(expr, expected, this.validExprs(), this.addTableApiTestExpr$default$4());
        this.addSqlTestExpr(sqlExpr, expected, this.validExprs(), this.addSqlTestExpr$default$4());
    }

    public void testTableApi(Expression expr, String expected) {
        this.addTableApiTestExpr(expr, expected, this.validExprs(), this.addTableApiTestExpr$default$4());
    }

    public void testSqlApi(String sqlExpr, String expected) {
        this.addSqlTestExpr(sqlExpr, expected, this.validExprs(), this.addSqlTestExpr$default$4());
    }

    public void testExpectedAllApisException(Expression expr, String sqlExpr, String keywords, Class<? extends Throwable> clazz) {
        this.invalidTableApiExprs().$plus$eq((Object)new Tuple3((Object)expr, (Object)keywords, clazz));
        this.invalidSqlExprs().$plus$eq((Object)new Tuple3((Object)sqlExpr, (Object)keywords, clazz));
    }

    public Class<? extends Throwable> testExpectedAllApisException$default$4() {
        return ValidationException.class;
    }

    public void testExpectedSqlException(String sqlExpr, String keywords, Class<? extends Throwable> clazz) {
        this.invalidSqlExprs().$plus$eq((Object)new Tuple3((Object)sqlExpr, (Object)keywords, clazz));
    }

    public Class<? extends Throwable> testExpectedSqlException$default$3() {
        return ValidationException.class;
    }

    public void testExpectedTableApiException(Expression expr, String keywords, Class<? extends Throwable> clazz) {
        this.invalidTableApiExprs().$plus$eq((Object)new Tuple3((Object)expr, (Object)keywords, clazz));
    }

    public Class<? extends Throwable> testExpectedTableApiException$default$3() {
        return ValidationException.class;
    }

    public GeneratedFunction<MapFunction<RowData, BinaryRowData>> getCodeGenFunctions(List<String> sqlExprs) {
        ArrayBuffer testSqlExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        sqlExprs.foreach((Function1 & Serializable & scala.Serializable)exp -> {
            this.addSqlTestExpr(exp, null, testSqlExprs, null);
            return BoxedUnit.UNIT;
        });
        return this.getCodeGenFunction((List<RexNode>)((IndexedSeqOptimized)testSqlExprs.map((Function1 & Serializable & scala.Serializable)r -> (RexNode)r._2(), ArrayBuffer$.MODULE$.canBuildFrom())).toList());
    }

    public List<String> evaluateFunctionResult(GeneratedFunction<MapFunction<RowData, BinaryRowData>> generatedFunction) {
        List list;
        RowData rowData;
        MapFunction mapper = (MapFunction)generatedFunction.newInstance(this.getClass().getClassLoader());
        boolean isRichFunction = mapper instanceof RichFunction;
        if (isRichFunction) {
            RichMapFunction richMapper = (RichMapFunction)mapper;
            RuntimeUDFContext t = new RuntimeUDFContext(new TaskInfo("ExpressionTest", 1, 0, 1, 1), ExpressionTestBase.class.getClassLoader(), this.env().getConfig(), Collections.emptyMap(), Collections.emptyMap(), null);
            richMapper.setRuntimeContext((RuntimeContext)t);
            richMapper.open(new Configuration());
        }
        if (this.containsLegacyTypes()) {
            DataFormatConverters.DataFormatConverter converter = DataFormatConverters.getConverterForDataType((DataType)this.resolvedDataType());
            rowData = (RowData)converter.toInternal((Object)this.testData());
        } else {
            DataStructureConverter converter = DataStructureConverters.getConverter((DataType)this.resolvedDataType());
            rowData = (RowData)converter.toInternalOrNull((Object)this.testData());
        }
        RowData testRow = rowData;
        try {
            BinaryRowData result = (BinaryRowData)mapper.map((Object)testRow);
            if (isRichFunction) {
                ((RichMapFunction)mapper).close();
            }
            list = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)result.getArity()), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)index -> ExpressionTestBase.$anonfun$evaluateFunctionResult$1(result, BoxesRunTime.unboxToInt((Object)index)), Seq$.MODULE$.canBuildFrom())).toList();
        }
        catch (TableException te) {
            throw te;
        }
        catch (Throwable e) {
            throw new AssertionError(new StringBuilder(54).append("Error when executing the expression. Expression code:\n").append(generatedFunction.getCode()).toString(), e);
        }
        return list;
    }

    private void addSqlTestExpr(String sqlExpr, String expected, ArrayBuffer<?> exprsContainer, Class<? extends Throwable> exceptionClass) {
        SqlNode parsed = this.parser().parse(new StringBuilder(13).append("SELECT ").append(sqlExpr).append(" FROM ").append(this.tableName()).toString());
        SqlNode validated = this.calcitePlanner().validate(parsed);
        RelNode converted = this.calcitePlanner().rel((SqlNode)validated).rel;
        this.addTestExpr(converted, expected, sqlExpr, exceptionClass, exprsContainer);
    }

    private Class<? extends Throwable> addSqlTestExpr$default$4() {
        return null;
    }

    private void addTableApiTestExpr(Expression tableApiExpr, String expected, ArrayBuffer<?> exprsContainer, Class<? extends Throwable> exceptionClass) {
        RelNode relNode = this.relBuilder().queryOperation(this.tEnv().from(this.tableName()).select(new Expression[]{tableApiExpr}).getQueryOperation()).build();
        this.addTestExpr(relNode, expected, tableApiExpr.asSummaryString(), null, exprsContainer);
    }

    private Class<? extends Throwable> addTableApiTestExpr$default$4() {
        return null;
    }

    private void addTestExpr(RelNode relNode, String expected, String summaryString, Class<? extends Throwable> exceptionClass, ArrayBuffer<?> exprs) {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleInstance((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS);
        builder.addRuleInstance((RelOptRule)CoreRules.PROJECT_TO_CALC);
        HepPlanner hep = new HepPlanner(builder.build());
        hep.setRoot(relNode);
        RelNode optimized = hep.findBestExp();
        if (!optimized.getInput(0).getInputs().isEmpty()) {
            Assert.fail((String)"Expression is converted into more than a Calc operation. Use a different test method.");
        }
        exprs.$plus$eq((Object)new Tuple3((Object)summaryString, (Object)this.extractRexNode(optimized), (Object)expected));
    }

    private RexNode extractRexNode(RelNode node) {
        RexProgram calcProgram = ((LogicalCalc)node).getProgram();
        return calcProgram.expandLocalRef((RexLocalRef)calcProgram.getProjectList().get(0));
    }

    private void evaluateGivenExprs(ArrayBuffer<Tuple3<String, RexNode, String>> exprArray) {
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> genFunc = this.getCodeGenFunction((List<RexNode>)((IndexedSeqOptimized)exprArray.map((Function1 & Serializable & scala.Serializable)exp -> (RexNode)exp._2(), ArrayBuffer$.MODULE$.canBuildFrom())).toList());
        List<String> result = this.evaluateFunctionResult(genFunc);
        ((ResizableArray)exprArray.zip(result, ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ExpressionTestBase.$anonfun$evaluateGivenExprs$2(x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private GeneratedFunction<MapFunction<RowData, BinaryRowData>> getCodeGenFunction(List<RexNode> rexNodes) {
        CodeGeneratorContext ctx = new CodeGeneratorContext((ReadableConfig)this.tableConfig(), Thread.currentThread().getContextClassLoader());
        LogicalType inputType = this.containsLegacyTypes() ? TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)this.typeInfo()) : this.resolvedDataType().getLogicalType();
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        LogicalType x$1 = inputType;
        String x$2 = qual$1.bindInput$default$2();
        Option x$3 = qual$1.bindInput$default$3();
        ExprCodeGenerator exprGenerator = qual$1.bindInput(x$1, x$2, x$3);
        List stringTestExprs = (List)rexNodes.map((Function1 & Serializable & scala.Serializable)expr -> this.relBuilder().cast(expr, SqlTypeName.VARCHAR), List$.MODULE$.canBuildFrom());
        RowType resultType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)Seq$.MODULE$.fill(rexNodes.size(), (Function0 & Serializable & scala.Serializable)() -> VarCharType.STRING_TYPE)).toArray(ClassTag$.MODULE$.apply(VarCharType.class))));
        List exprs = (List)stringTestExprs.map((Function1 & Serializable & scala.Serializable)rex -> exprGenerator.generateExpression(rex), List$.MODULE$.canBuildFrom());
        GeneratedExpression genExpr = exprGenerator.generateResultExpression((Seq)exprs, resultType, BinaryRowData.class, exprGenerator.generateResultExpression$default$4(), exprGenerator.generateResultExpression$default$5(), exprGenerator.generateResultExpression$default$6(), exprGenerator.generateResultExpression$default$7());
        String bodyCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(39).append("\n         |").append(genExpr.code()).append("\n         |return ").append(genExpr.resultTerm()).append(";\n        ").toString())).stripMargin();
        return FunctionCodeGenerator$.MODULE$.generateFunction(ctx, "TestFunction", MapFunction.class, bodyCode, (LogicalType)resultType, inputType, FunctionCodeGenerator$.MODULE$.generateFunction$default$7(), FunctionCodeGenerator$.MODULE$.generateFunction$default$8(), FunctionCodeGenerator$.MODULE$.generateFunction$default$9(), FunctionCodeGenerator$.MODULE$.generateFunction$default$10(), FunctionCodeGenerator$.MODULE$.generateFunction$default$11());
    }

    public abstract Row testData();

    public AbstractDataType<?> testDataType() {
        throw new IllegalArgumentException("Implement this if no legacy types are expected.");
    }

    public Map<String, ScalarFunction> testSystemFunctions() {
        return Collections.emptyMap();
    }

    public boolean containsLegacyTypes() {
        return true;
    }

    public scala.collection.immutable.Map<String, ScalarFunction> functions() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public RowTypeInfo typeInfo() {
        throw new IllegalArgumentException("Implement this if legacy types are expected.");
    }

    public String timestampLtz(String str) {
        int precision = this.extractPrecision(str);
        return this.timestampLtz(str, precision);
    }

    public String timestampLtz(String str, int precision) {
        return new StringBuilder(37).append("CAST(TIMESTAMP '").append(str).append("' AS TIMESTAMP_LTZ(").append(precision).append("))").toString();
    }

    private int extractPrecision(String str) {
        int dot = str.indexOf(46);
        return dot == -1 ? 0 : str.length() - dot - 1;
    }

    public static final /* synthetic */ void $anonfun$prepare$2(ExpressionTestBase $this, Tuple2 f) {
        $this.tEnv().registerFunction((String)f._1(), (ScalarFunction)f._2());
    }

    public static final /* synthetic */ void $anonfun$prepare$3(ExpressionTestBase $this, Tuple2 e) {
        $this.tEnv().createTemporarySystemFunction((String)e._1(), (UserDefinedFunction)e._2());
    }

    public static final /* synthetic */ void $anonfun$evaluateExprs$1(ExpressionTestBase $this, Tuple3 x0$1) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            String sqlExpr = (String)tuple3._1();
            String keywords = (String)tuple3._2();
            Class clazz = (Class)tuple3._3();
            try {
                ArrayBuffer invalidExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                $this.addSqlTestExpr(sqlExpr, keywords, invalidExprs, clazz);
                $this.evaluateGivenExprs((ArrayBuffer<Tuple3<String, RexNode, String>>)invalidExprs);
                Assert.fail((String)new StringBuilder(40).append("Expected a ").append(clazz).append(", but no exception is thrown.").toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Class<?> clazz2 = throwable2.getClass();
                Class clazz3 = clazz;
                if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                    BoxedUnit boxedUnit2;
                    if (keywords != null) {
                        Assert.assertTrue((String)new StringBuilder(31).append("The actual exception message \n").append(throwable2.getMessage()).append("\n").append(new StringBuilder(35).append("doesn't contain expected keyword \n").append(keywords).append("\n").toString()).toString(), (boolean)throwable2.getMessage().contains(keywords));
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    throwable3.printStackTrace();
                    Assert.fail((String)new StringBuilder(25).append("Expected throw ").append(clazz.getSimpleName()).append(", but is ").append(throwable3).append(".").toString());
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit5 = boxedUnit;
    }

    public static final /* synthetic */ String $anonfun$evaluateFunctionResult$1(BinaryRowData result$1, int index) {
        return !result$1.isNullAt(index) ? result$1.getString(index).toString() : null;
    }

    public static final /* synthetic */ void $anonfun$evaluateGivenExprs$2(Tuple2 x0$3) {
        String actual;
        Tuple3 tuple3;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$3;
                if (tuple2 == null) break block2;
                tuple3 = (Tuple3)tuple2._1();
                actual = (String)tuple2._2();
                if (tuple3 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String originalExpr = (String)tuple3._1();
        RexNode optimizedExpr = (RexNode)tuple3._2();
        String expected = (String)tuple3._3();
        String original = originalExpr == null ? "" : new StringBuilder(7).append("for: [").append(originalExpr).append("]").toString();
        Assert.assertEquals((String)new StringBuilder(30).append("Wrong result ").append(original).append(" optimized to: [").append(optimizedExpr).append("]").toString(), (Object)expected, (Object)(actual == null ? "NULL" : actual));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ExpressionTestBase() {
        this.tableName = "testTable";
        this.nullable = "NULL";
    }
}

