/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ScalarOperatorsTestBase;
import org.junit.Test;

public class TypeConversionsTest
extends ScalarOperatorsTestBase {
    @Test
    public void testTimestampWithLocalTimeZoneToString() {
        this.tableConfig().setLocalTimeZone((ZoneId)ZoneOffset.ofHours(2));
        this.testTableApi((Expression)Expressions.lit((Object)Instant.EPOCH).cast(DataTypes.STRING()), "1970-01-01 02:00:00");
    }

    @Test
    public void testTimestampWithLocalTimeZoneToDate() {
        this.tableConfig().setLocalTimeZone((ZoneId)ZoneOffset.ofHours(4));
        this.testTableApi((Expression)Expressions.lit((Object)Instant.EPOCH).cast(DataTypes.DATE()), "1970-01-01");
    }

    @Test
    public void testTimestampWithLocalTimeZoneToTime() {
        this.tableConfig().setLocalTimeZone((ZoneId)ZoneOffset.ofHours(4));
        this.testTableApi((Expression)Expressions.lit((Object)Instant.EPOCH).cast(DataTypes.TIME((int)0)), "04:00:00");
    }

    @Test
    public void testTimestampWithLocalTimeZoneToTimestamp() {
        this.tableConfig().setLocalTimeZone((ZoneId)ZoneOffset.ofHours(3));
        this.testTableApi((Expression)Expressions.lit((Object)Instant.EPOCH).cast(DataTypes.TIMESTAMP((int)0)), "1970-01-01 03:00:00");
    }

    @Test
    public void testStringToTimestampWithLocalTimeZone() {
        this.tableConfig().setLocalTimeZone((ZoneId)ZoneOffset.ofHours(2));
        this.testTableApi((Expression)Expressions.lit((Object)"1970-01-01 00:00:00").cast(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)0)), "1970-01-01 00:00:00");
        this.testSqlApi("cast('1970-01-01 00:00:00' AS TIMESTAMP(0) WITH LOCAL TIME ZONE)", "1970-01-01 00:00:00");
    }

    @Test
    public void testTimestampToTimestampWithLocalTimeZone() {
        this.tableConfig().setLocalTimeZone((ZoneId)ZoneOffset.ofHours(2));
        this.testTableApi((Expression)Expressions.lit((Object)LocalDateTime.parse("1970-01-01T00:00:00")).cast(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)0)), "1970-01-01 00:00:00");
        this.testSqlApi("cast(TIMESTAMP '1970-01-01 00:00:00' AS TIMESTAMP(0) WITH LOCAL TIME ZONE)", "1970-01-01 00:00:00");
    }

    @Test
    public void testTimeToTimestampWithLocalTimeZone() {
        this.tableConfig().setLocalTimeZone((ZoneId)ZoneOffset.ofHours(2));
        this.testTableApi((Expression)Expressions.lit((Object)LocalTime.parse("12:00:00")).cast(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)0)), "1970-01-01 12:00:00");
        this.testSqlApi("cast(TIME '12:00:00' AS TIMESTAMP(0) WITH LOCAL TIME ZONE)", "1970-01-01 12:00:00");
    }

    @Test
    public void testDateToTimestampWithLocalTimeZone() {
        this.tableConfig().setLocalTimeZone((ZoneId)ZoneOffset.ofHours(2));
        this.testTableApi((Expression)Expressions.lit((Object)LocalDate.parse("1970-02-01")).cast(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)0)), "1970-02-01 00:00:00");
        this.testSqlApi("cast(DATE '1970-02-01' AS TIMESTAMP(0) WITH LOCAL TIME ZONE)", "1970-02-01 00:00:00");
    }
}

