/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.testcsv;

import java.nio.charset.StandardCharsets;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.Row;

class TestCsvSerializationSchema
implements SerializationSchema<RowData> {
    private final DynamicTableSink.DataStructureConverter converter;

    public TestCsvSerializationSchema(DynamicTableSink.DataStructureConverter converter) {
        this.converter = converter;
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
    }

    public byte[] serialize(RowData element) {
        Row row = (Row)this.converter.toExternal((Object)element);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < row.getArity(); ++i) {
            Object o;
            if (i > 0) {
                builder.append(CsvOutputFormat.DEFAULT_FIELD_DELIMITER);
            }
            if ((o = row.getField(i)) == null) continue;
            builder.append(o);
        }
        String str = builder.toString();
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

