/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.json.JsonRowSchemaConverter;
import org.apache.flink.formats.json.TimeFormats;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingRuntimeException;

@PublicEvolving
public class JsonRowSerializationSchema
implements SerializationSchema<Row> {
    private static final long serialVersionUID = -2885556750743978636L;
    private final RowTypeInfo typeInfo;
    private final ObjectMapper mapper = new ObjectMapper();
    private final SerializationRuntimeConverter runtimeConverter;
    private transient ObjectNode node;

    @Deprecated
    public JsonRowSerializationSchema(TypeInformation<Row> typeInfo) {
        Preconditions.checkNotNull(typeInfo, (String)"Type information");
        Preconditions.checkArgument((boolean)(typeInfo instanceof RowTypeInfo), (Object)"Only RowTypeInfo is supported");
        this.typeInfo = (RowTypeInfo)typeInfo;
        this.runtimeConverter = this.createConverter(typeInfo);
    }

    public byte[] serialize(Row row) {
        if (this.node == null) {
            this.node = this.mapper.createObjectNode();
        }
        try {
            this.runtimeConverter.convert(this.mapper, (JsonNode)this.node, row);
            return this.mapper.writeValueAsBytes((Object)this.node);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + row + "'. Make sure that the schema matches the input.", t);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRowSerializationSchema that = (JsonRowSerializationSchema)o;
        return Objects.equals(this.typeInfo, that.typeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.typeInfo);
    }

    private SerializationRuntimeConverter createConverter(TypeInformation<?> typeInfo) {
        SerializationRuntimeConverter baseConverter = this.createConverterForSimpleType(typeInfo).orElseGet(() -> this.createContainerConverter(typeInfo).orElseGet(this::createFallbackConverter));
        return this.wrapIntoNullableConverter(baseConverter);
    }

    private SerializationRuntimeConverter wrapIntoNullableConverter(SerializationRuntimeConverter converter) {
        return (mapper, reuse, object) -> {
            if (object == null) {
                return mapper.getNodeFactory().nullNode();
            }
            return converter.convert(mapper, reuse, object);
        };
    }

    private Optional<SerializationRuntimeConverter> createContainerConverter(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof RowTypeInfo) {
            return Optional.of(this.createRowConverter((RowTypeInfo)typeInfo));
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            return Optional.of(this.createObjectArrayConverter(((ObjectArrayTypeInfo)typeInfo).getComponentInfo()));
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            return Optional.of(this.createObjectArrayConverter(((BasicArrayTypeInfo)typeInfo).getComponentInfo()));
        }
        if (this.isPrimitiveByteArray(typeInfo)) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().binaryNode((byte[])object));
        }
        return Optional.empty();
    }

    private boolean isPrimitiveByteArray(TypeInformation<?> typeInfo) {
        return typeInfo instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)typeInfo).getComponentType() == Types.BYTE;
    }

    private SerializationRuntimeConverter createObjectArrayConverter(TypeInformation elementTypeInfo) {
        SerializationRuntimeConverter elementConverter = this.createConverter(elementTypeInfo);
        return this.assembleArrayConverter(elementConverter);
    }

    private SerializationRuntimeConverter createRowConverter(RowTypeInfo typeInfo) {
        List<SerializationRuntimeConverter> fieldConverters = Arrays.stream(typeInfo.getFieldTypes()).map(this::createConverter).collect(Collectors.toList());
        return this.assembleRowConverter(typeInfo.getFieldNames(), fieldConverters);
    }

    private SerializationRuntimeConverter createFallbackConverter() {
        return (mapper, reuse, object) -> {
            try {
                return mapper.valueToTree(object);
            }
            catch (IllegalArgumentException e) {
                throw new WrappingRuntimeException(String.format("Could not convert object: %s", object), (Throwable)e);
            }
        };
    }

    private Optional<SerializationRuntimeConverter> createConverterForSimpleType(TypeInformation<?> simpleTypeInfo) {
        if (simpleTypeInfo == Types.VOID) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().nullNode());
        }
        if (simpleTypeInfo == Types.BOOLEAN) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().booleanNode(((Boolean)object).booleanValue()));
        }
        if (simpleTypeInfo == Types.STRING) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().textNode((String)object));
        }
        if (simpleTypeInfo == Types.INT) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().numberNode((Integer)object));
        }
        if (simpleTypeInfo == Types.LONG) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().numberNode((Long)object));
        }
        if (simpleTypeInfo == Types.DOUBLE) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().numberNode((Double)object));
        }
        if (simpleTypeInfo == Types.FLOAT) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().numberNode((Float)object));
        }
        if (simpleTypeInfo == Types.SHORT) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().numberNode((Short)object));
        }
        if (simpleTypeInfo == Types.BYTE) {
            return Optional.of((mapper, reuse, object) -> mapper.getNodeFactory().numberNode((Byte)object));
        }
        if (simpleTypeInfo == Types.BIG_DEC) {
            return Optional.of(this.createBigDecimalConverter());
        }
        if (simpleTypeInfo == Types.BIG_INT) {
            return Optional.of(this.createBigIntegerConverter());
        }
        if (simpleTypeInfo == Types.SQL_DATE) {
            return Optional.of(this::convertDate);
        }
        if (simpleTypeInfo == Types.SQL_TIME) {
            return Optional.of(this::convertTime);
        }
        if (simpleTypeInfo == Types.SQL_TIMESTAMP) {
            return Optional.of(this::convertTimestamp);
        }
        if (simpleTypeInfo == Types.LOCAL_DATE) {
            return Optional.of(this::convertLocalDate);
        }
        if (simpleTypeInfo == Types.LOCAL_TIME) {
            return Optional.of(this::convertLocalTime);
        }
        if (simpleTypeInfo == Types.LOCAL_DATE_TIME) {
            return Optional.of(this::convertLocalDateTime);
        }
        return Optional.empty();
    }

    private JsonNode convertLocalDate(ObjectMapper mapper, JsonNode reuse, Object object) {
        return mapper.getNodeFactory().textNode(DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)object));
    }

    private JsonNode convertDate(ObjectMapper mapper, JsonNode reuse, Object object) {
        Date date = (Date)object;
        return this.convertLocalDate(mapper, reuse, date.toLocalDate());
    }

    private JsonNode convertLocalDateTime(ObjectMapper mapper, JsonNode reuse, Object object) {
        return mapper.getNodeFactory().textNode(TimeFormats.RFC3339_TIMESTAMP_FORMAT.format((LocalDateTime)object));
    }

    private JsonNode convertTimestamp(ObjectMapper mapper, JsonNode reuse, Object object) {
        Timestamp timestamp = (Timestamp)object;
        return this.convertLocalDateTime(mapper, reuse, timestamp.toLocalDateTime());
    }

    private JsonNode convertLocalTime(ObjectMapper mapper, JsonNode reuse, Object object) {
        JsonNodeFactory nodeFactory = mapper.getNodeFactory();
        return nodeFactory.textNode(TimeFormats.RFC3339_TIME_FORMAT.format((LocalTime)object));
    }

    private JsonNode convertTime(ObjectMapper mapper, JsonNode reuse, Object object) {
        Time time = (Time)object;
        return this.convertLocalTime(mapper, reuse, time.toLocalTime());
    }

    private SerializationRuntimeConverter createBigDecimalConverter() {
        return (mapper, reuse, object) -> {
            JsonNodeFactory nodeFactory = mapper.getNodeFactory();
            if (object instanceof BigDecimal) {
                return nodeFactory.numberNode((BigDecimal)object);
            }
            return nodeFactory.numberNode(BigDecimal.valueOf(((Number)object).doubleValue()));
        };
    }

    private SerializationRuntimeConverter createBigIntegerConverter() {
        return (mapper, reuse, object) -> {
            JsonNodeFactory nodeFactory = mapper.getNodeFactory();
            if (object instanceof BigInteger) {
                return nodeFactory.numberNode((BigInteger)object);
            }
            return nodeFactory.numberNode(BigInteger.valueOf(((Number)object).longValue()));
        };
    }

    private SerializationRuntimeConverter assembleRowConverter(String[] fieldNames, List<SerializationRuntimeConverter> fieldConverters) {
        return (mapper, reuse, object) -> {
            ObjectNode node = reuse == null ? mapper.createObjectNode() : (ObjectNode)reuse;
            Row row = (Row)object;
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                node.set(fieldName, ((SerializationRuntimeConverter)fieldConverters.get(i)).convert(mapper, node.get(fieldNames[i]), row.getField(i)));
            }
            return node;
        };
    }

    private SerializationRuntimeConverter assembleArrayConverter(SerializationRuntimeConverter elementConverter) {
        return (mapper, reuse, object) -> {
            Object[] array;
            ArrayNode node;
            if (reuse == null) {
                node = mapper.createArrayNode();
            } else {
                node = (ArrayNode)reuse;
                node.removeAll();
            }
            for (Object element : array = (Object[])object) {
                node.add(elementConverter.convert(mapper, null, element));
            }
            return node;
        };
    }

    @FunctionalInterface
    private static interface SerializationRuntimeConverter
    extends Serializable {
        public JsonNode convert(ObjectMapper var1, JsonNode var2, Object var3);
    }

    @PublicEvolving
    public static class Builder {
        private final RowTypeInfo typeInfo;

        public Builder(TypeInformation<Row> typeInfo) {
            Preconditions.checkArgument((boolean)(typeInfo instanceof RowTypeInfo), (Object)"Only RowTypeInfo is supported");
            this.typeInfo = (RowTypeInfo)typeInfo;
        }

        public Builder(String jsonSchema) {
            this(JsonRowSchemaConverter.convert((String)Preconditions.checkNotNull((Object)jsonSchema)));
        }

        public JsonRowSerializationSchema build() {
            return new JsonRowSerializationSchema((TypeInformation<Row>)this.typeInfo);
        }
    }
}

