/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import org.apache.flink.addons.hbase.AbstractTableInputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;

public abstract class TableInputFormat<T extends Tuple>
extends AbstractTableInputFormat<T> {
    private static final long serialVersionUID = 1L;

    @Override
    protected abstract Scan getScanner();

    @Override
    protected abstract String getTableName();

    protected abstract T mapResultToTuple(Result var1);

    @Override
    public void configure(Configuration parameters) {
        this.table = this.createTable();
        if (this.table != null) {
            this.scan = this.getScanner();
        }
    }

    private HTable createTable() {
        LOG.info("Initializing HBaseConfiguration");
        org.apache.hadoop.conf.Configuration hConf = HBaseConfiguration.create();
        try {
            return new HTable(hConf, this.getTableName());
        }
        catch (Exception e) {
            LOG.error("Error instantiating a new HTable instance", (Throwable)e);
            return null;
        }
    }

    @Override
    protected T mapResultToOutType(Result r) {
        return this.mapResultToTuple(r);
    }
}

