/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class HBaseWriteOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long bufferFlushMaxSizeInBytes;
    private final long bufferFlushMaxRows;
    private final long bufferFlushIntervalMillis;

    private HBaseWriteOptions(long bufferFlushMaxSizeInBytes, long bufferFlushMaxMutations, long bufferFlushIntervalMillis) {
        this.bufferFlushMaxSizeInBytes = bufferFlushMaxSizeInBytes;
        this.bufferFlushMaxRows = bufferFlushMaxMutations;
        this.bufferFlushIntervalMillis = bufferFlushIntervalMillis;
    }

    long getBufferFlushMaxSizeInBytes() {
        return this.bufferFlushMaxSizeInBytes;
    }

    long getBufferFlushMaxRows() {
        return this.bufferFlushMaxRows;
    }

    long getBufferFlushIntervalMillis() {
        return this.bufferFlushIntervalMillis;
    }

    public String toString() {
        return "HBaseWriteOptions{bufferFlushMaxSizeInBytes=" + this.bufferFlushMaxSizeInBytes + ", bufferFlushMaxRows=" + this.bufferFlushMaxRows + ", bufferFlushIntervalMillis=" + this.bufferFlushIntervalMillis + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HBaseWriteOptions that = (HBaseWriteOptions)o;
        return this.bufferFlushMaxSizeInBytes == that.bufferFlushMaxSizeInBytes && this.bufferFlushMaxRows == that.bufferFlushMaxRows && this.bufferFlushIntervalMillis == that.bufferFlushIntervalMillis;
    }

    public int hashCode() {
        return Objects.hash(this.bufferFlushMaxSizeInBytes, this.bufferFlushMaxRows, this.bufferFlushIntervalMillis);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long bufferFlushMaxSizeInBytes = 0x200000L;
        private long bufferFlushMaxRows = -1L;
        private long bufferFlushIntervalMillis = -1L;

        public Builder setBufferFlushMaxSizeInBytes(long bufferFlushMaxSizeInBytes) {
            Preconditions.checkArgument((bufferFlushMaxSizeInBytes > 0L ? 1 : 0) != 0, (Object)"Max byte size of buffered rows must be larger than 0.");
            this.bufferFlushMaxSizeInBytes = bufferFlushMaxSizeInBytes;
            return this;
        }

        public Builder setBufferFlushMaxRows(long bufferFlushMaxRows) {
            Preconditions.checkArgument((bufferFlushMaxRows > 0L ? 1 : 0) != 0, (Object)"Max number of buffered rows must be larger than 0.");
            this.bufferFlushMaxRows = bufferFlushMaxRows;
            return this;
        }

        public Builder setBufferFlushIntervalMillis(long bufferFlushIntervalMillis) {
            Preconditions.checkArgument((bufferFlushIntervalMillis > 0L ? 1 : 0) != 0, (Object)"Interval (in milliseconds) between each flush must be larger than 0.");
            this.bufferFlushIntervalMillis = bufferFlushIntervalMillis;
            return this;
        }

        public HBaseWriteOptions build() {
            return new HBaseWriteOptions(this.bufferFlushMaxSizeInBytes, this.bufferFlushMaxRows, this.bufferFlushIntervalMillis);
        }
    }
}

