/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.util.Arrays;
import org.apache.flink.addons.hbase.HBaseLookupFunction;
import org.apache.flink.addons.hbase.HBaseRowInputFormat;
import org.apache.flink.addons.hbase.HBaseTableSchema;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.LookupableTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

public class HBaseTableSource
implements BatchTableSource<Row>,
ProjectableTableSource<Row>,
StreamTableSource<Row>,
LookupableTableSource<Row> {
    private final Configuration conf;
    private final String tableName;
    private final HBaseTableSchema hbaseSchema;
    private final int[] projectFields;

    public HBaseTableSource(Configuration conf, String tableName) {
        this(conf, tableName, new HBaseTableSchema(), null);
    }

    HBaseTableSource(Configuration conf, String tableName, HBaseTableSchema hbaseSchema, int[] projectFields) {
        this.conf = conf;
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (String)"Table  name");
        this.hbaseSchema = hbaseSchema;
        this.projectFields = projectFields;
    }

    public void addColumn(String family, String qualifier, Class<?> clazz) {
        this.hbaseSchema.addColumn(family, qualifier, clazz);
    }

    public void setRowKey(String rowKeyName, Class<?> clazz) {
        this.hbaseSchema.setRowKey(rowKeyName, clazz);
    }

    public void setCharset(String charset) {
        this.hbaseSchema.setCharset(charset);
    }

    public TypeInformation<Row> getReturnType() {
        HBaseTableSchema projectedSchema = this.hbaseSchema.getProjectedHBaseTableSchema(this.projectFields);
        return projectedSchema.convertsToTableSchema().toRowType();
    }

    public TableSchema getTableSchema() {
        return this.hbaseSchema.convertsToTableSchema();
    }

    public DataSet<Row> getDataSet(ExecutionEnvironment execEnv) {
        HBaseTableSchema projectedSchema = this.hbaseSchema.getProjectedHBaseTableSchema(this.projectFields);
        return execEnv.createInput((InputFormat)new HBaseRowInputFormat(this.conf, this.tableName, projectedSchema), this.getReturnType()).name(this.explainSource());
    }

    public HBaseTableSource projectFields(int[] fields) {
        return new HBaseTableSource(this.conf, this.tableName, this.hbaseSchema, fields);
    }

    public String explainSource() {
        return "HBaseTableSource[schema=" + Arrays.toString(this.getTableSchema().getFieldNames()) + ", projectFields=" + Arrays.toString(this.projectFields) + "]";
    }

    public TableFunction<Row> getLookupFunction(String[] lookupKeys) {
        Preconditions.checkArgument((null != lookupKeys && lookupKeys.length == 1 ? 1 : 0) != 0, (Object)"HBase table can only be retrieved by rowKey for now.");
        Preconditions.checkState((boolean)this.hbaseSchema.getRowKeyName().isPresent(), (Object)"HBase schema must have a row key when used in lookup mode.");
        Preconditions.checkState((boolean)this.hbaseSchema.getRowKeyName().get().equals(lookupKeys[0]), (Object)"The lookup key is not row key of HBase.");
        return new HBaseLookupFunction(this.conf, this.tableName, this.hbaseSchema.getProjectedHBaseTableSchema(this.projectFields));
    }

    public AsyncTableFunction<Row> getAsyncLookupFunction(String[] lookupKeys) {
        throw new UnsupportedOperationException("HBase table doesn't support async lookup currently.");
    }

    public boolean isAsyncEnabled() {
        return false;
    }

    public boolean isBounded() {
        return true;
    }

    public DataStream<Row> getDataStream(StreamExecutionEnvironment execEnv) {
        HBaseTableSchema projectedSchema = this.hbaseSchema.getProjectedHBaseTableSchema(this.projectFields);
        return execEnv.createInput((InputFormat)new HBaseRowInputFormat(this.conf, this.tableName, projectedSchema), this.getReturnType()).name(this.explainSource());
    }

    @VisibleForTesting
    HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseSchema;
    }
}

