/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.io.IOException;
import org.apache.flink.addons.hbase.AbstractTableInputFormat;
import org.apache.flink.addons.hbase.HBaseTableSchema;
import org.apache.flink.addons.hbase.util.HBaseReadWriteHelper;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRowInputFormat
extends AbstractTableInputFormat<Row>
implements ResultTypeQueryable<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRowInputFormat.class);
    private final String tableName;
    private final HBaseTableSchema schema;
    private transient org.apache.hadoop.conf.Configuration conf;
    private transient HBaseReadWriteHelper readHelper;

    public HBaseRowInputFormat(org.apache.hadoop.conf.Configuration conf, String tableName, HBaseTableSchema schema) {
        this.tableName = tableName;
        this.conf = conf;
        this.schema = schema;
    }

    @Override
    public void configure(Configuration parameters) {
        LOG.info("Initializing HBase configuration.");
        this.readHelper = new HBaseReadWriteHelper(this.schema);
        this.connectToTable();
        if (this.table != null) {
            this.scan = this.getScanner();
        }
    }

    @Override
    protected Scan getScanner() {
        return this.readHelper.createScan();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    protected Row mapResultToOutType(Result res) {
        return this.readHelper.parseToRow(res);
    }

    private void connectToTable() {
        if (this.conf == null) {
            this.conf = HBaseConfiguration.create();
        }
        try {
            Connection conn = ConnectionFactory.createConnection((org.apache.hadoop.conf.Configuration)this.conf);
            this.table = (HTable)conn.getTable(TableName.valueOf((String)this.tableName));
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("The table " + this.tableName + " not found ", (Throwable)tnfe);
            throw new RuntimeException("HBase table '" + this.tableName + "' not found.", tnfe);
        }
        catch (IOException ioe) {
            LOG.error("Exception while creating connection to HBase.", (Throwable)ioe);
            throw new RuntimeException("Cannot create connection to HBase.", ioe);
        }
    }

    public TypeInformation<Row> getProducedType() {
        String[] famNames = this.schema.getFamilyNames();
        TypeInformation[] typeInfos = new TypeInformation[famNames.length];
        int i = 0;
        for (String family : famNames) {
            typeInfos[i] = new RowTypeInfo(this.schema.getQualifierTypes(family), this.schema.getQualifierNames(family));
            ++i;
        }
        return new RowTypeInfo(typeInfos, famNames);
    }
}

