/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.io.IOException;
import org.apache.flink.addons.hbase.HBaseTableSchema;
import org.apache.flink.addons.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.addons.hbase.util.HBaseReadWriteHelper;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseLookupFunction
extends TableFunction<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseLookupFunction.class);
    private static final long serialVersionUID = 1L;
    private final String hTableName;
    private final byte[] serializedConfig;
    private final HBaseTableSchema hbaseTableSchema;
    private transient HBaseReadWriteHelper readHelper;
    private transient Connection hConnection;
    private transient HTable table;

    public HBaseLookupFunction(Configuration configuration, String hTableName, HBaseTableSchema hbaseTableSchema) {
        this.serializedConfig = HBaseConfigurationUtil.serializeConfiguration(configuration);
        this.hTableName = hTableName;
        this.hbaseTableSchema = hbaseTableSchema;
    }

    public void eval(Object rowKey) throws IOException {
        Result result = this.table.get(this.readHelper.createGet(rowKey));
        if (!result.isEmpty()) {
            this.collect(this.readHelper.parseToRow(result, rowKey));
        }
    }

    public TypeInformation<Row> getResultType() {
        return this.hbaseTableSchema.convertsToTableSchema().toRowType();
    }

    private Configuration prepareRuntimeConfiguration() {
        Configuration runtimeConfig = HBaseConfigurationUtil.deserializeConfiguration(this.serializedConfig, HBaseConfiguration.create());
        if (StringUtils.isNullOrWhitespaceOnly((String)runtimeConfig.get("hbase.zookeeper.quorum"))) {
            LOG.error("can not connect to HBase without {} configuration", (Object)"hbase.zookeeper.quorum");
            throw new IllegalArgumentException("check HBase configuration failed, lost: 'hbase.zookeeper.quorum'!");
        }
        return runtimeConfig;
    }

    public void open(FunctionContext context) {
        LOG.info("start open ...");
        Configuration config = this.prepareRuntimeConfiguration();
        try {
            this.hConnection = ConnectionFactory.createConnection((Configuration)config);
            this.table = (HTable)this.hConnection.getTable(TableName.valueOf((String)this.hTableName));
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("Table '{}' not found ", (Object)this.hTableName, (Object)tnfe);
            throw new RuntimeException("HBase table '" + this.hTableName + "' not found.", tnfe);
        }
        catch (IOException ioe) {
            LOG.error("Exception while creating connection to HBase.", (Throwable)ioe);
            throw new RuntimeException("Cannot create connection to HBase.", ioe);
        }
        this.readHelper = new HBaseReadWriteHelper(this.hbaseTableSchema);
        LOG.info("end open.");
    }

    public void close() {
        LOG.info("start close ...");
        if (null != this.table) {
            try {
                this.table.close();
                this.table = null;
            }
            catch (IOException e) {
                LOG.warn("exception when close table", (Throwable)e);
            }
        }
        if (null != this.hConnection) {
            try {
                this.hConnection.close();
                this.hConnection = null;
            }
            catch (IOException e) {
                LOG.warn("exception when close connection", (Throwable)e);
            }
        }
        LOG.info("end close.");
    }

    @VisibleForTesting
    String getHTableName() {
        return this.hTableName;
    }
}

