/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.options;

import java.io.Serializable;
import java.util.Objects;

public class JdbcLookupOptions
implements Serializable {
    private final long cacheMaxSize;
    private final long cacheExpireMs;
    private final int maxRetryTimes;
    private final boolean cacheMissingKey;

    public JdbcLookupOptions(long cacheMaxSize, long cacheExpireMs, int maxRetryTimes, boolean cacheMissingKey) {
        this.cacheMaxSize = cacheMaxSize;
        this.cacheExpireMs = cacheExpireMs;
        this.maxRetryTimes = maxRetryTimes;
        this.cacheMissingKey = cacheMissingKey;
    }

    public long getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public long getCacheExpireMs() {
        return this.cacheExpireMs;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public boolean getCacheMissingKey() {
        return this.cacheMissingKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o instanceof JdbcLookupOptions) {
            JdbcLookupOptions options = (JdbcLookupOptions)o;
            return Objects.equals(this.cacheMaxSize, options.cacheMaxSize) && Objects.equals(this.cacheExpireMs, options.cacheExpireMs) && Objects.equals(this.maxRetryTimes, options.maxRetryTimes) && Objects.equals(this.cacheMissingKey, options.cacheMissingKey);
        }
        return false;
    }

    public static class Builder {
        private long cacheMaxSize = -1L;
        private long cacheExpireMs = -1L;
        private int maxRetryTimes = 3;
        private boolean cacheMissingKey = true;

        public Builder setCacheMaxSize(long cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        public Builder setCacheExpireMs(long cacheExpireMs) {
            this.cacheExpireMs = cacheExpireMs;
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public Builder setCacheMissingKey(boolean cacheMissingKey) {
            this.cacheMissingKey = cacheMissingKey;
            return this;
        }

        public JdbcLookupOptions build() {
            return new JdbcLookupOptions(this.cacheMaxSize, this.cacheExpireMs, this.maxRetryTimes, this.cacheMissingKey);
        }
    }
}

