/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.options;

import java.util.stream.IntStream;
import org.apache.flink.connector.jdbc.internal.options.JdbcTypedQueryOptions;
import org.apache.flink.util.Preconditions;

public class JdbcInsertOptions
extends JdbcTypedQueryOptions {
    private static final long serialVersionUID = 1L;
    private final String query;

    public JdbcInsertOptions(String query, int[] typesArray) {
        super(typesArray);
        this.query = (String)Preconditions.checkNotNull((Object)query, (String)"query is empty");
    }

    public String getQuery() {
        return this.query;
    }

    public static JdbcInsertOptions from(String query, int firstFieldType, int ... nextFieldTypes) {
        return new JdbcInsertOptions(query, JdbcInsertOptions.concat(firstFieldType, nextFieldTypes));
    }

    private static int[] concat(int first, int ... next) {
        if (next == null || next.length == 0) {
            return new int[]{first};
        }
        return IntStream.concat(IntStream.of(new int[]{first}), IntStream.of(next)).toArray();
    }
}

