/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslationUtil;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.runtime.jobgraph.JobGraph;

public class PackagedProgramUtils {
    private static final String PYTHON_DRIVER_CLASS_NAME = "org.apache.flink.client.python.PythonDriver";
    private static final String PYTHON_GATEWAY_CLASS_NAME = "org.apache.flink.client.python.PythonGatewayServer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobGraph createJobGraph(PackagedProgram packagedProgram, Configuration configuration, int defaultParallelism, @Nullable JobID jobID, boolean suppressOutput) throws ProgramInvocationException {
        JobGraph jobGraph;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Pipeline pipeline = PackagedProgramUtils.getPipelineFromProgram(packagedProgram, configuration, defaultParallelism, suppressOutput);
        try {
            Thread.currentThread().setContextClassLoader(packagedProgram.getUserCodeClassLoader());
            jobGraph = FlinkPipelineTranslationUtil.getJobGraph(pipeline, configuration, defaultParallelism);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        if (jobID != null) {
            jobGraph.setJobID(jobID);
        }
        jobGraph.addJars(packagedProgram.getJobJarAndDependencies());
        jobGraph.setClasspaths(packagedProgram.getClasspaths());
        jobGraph.setSavepointRestoreSettings(packagedProgram.getSavepointSettings());
        return jobGraph;
    }

    public static JobGraph createJobGraph(PackagedProgram packagedProgram, Configuration configuration, int defaultParallelism, boolean suppressOutput) throws ProgramInvocationException {
        return PackagedProgramUtils.createJobGraph(packagedProgram, configuration, defaultParallelism, null, suppressOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pipeline getPipelineFromProgram(PackagedProgram prog, Configuration configuration, int parallelism, boolean suppressOutput) throws CompilerException, ProgramInvocationException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(prog.getUserCodeClassLoader());
            OptimizerPlanEnvironment env = new OptimizerPlanEnvironment(configuration, prog.getUserCodeClassLoader());
            if (parallelism > 0) {
                env.setParallelism(parallelism);
            }
            Pipeline pipeline = env.getPipeline(prog, suppressOutput);
            return pipeline;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static Boolean isPython(String entryPointClassName) {
        return entryPointClassName != null && (entryPointClassName.equals(PYTHON_DRIVER_CLASS_NAME) || entryPointClassName.equals(PYTHON_GATEWAY_CLASS_NAME));
    }

    private PackagedProgramUtils() {
    }
}

