/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.client.program.ContextEnvironmentFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.DetachedJobExecutionResult;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextEnvironment
extends ExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionEnvironment.class);

    ContextEnvironment(PipelineExecutorServiceLoader executorServiceLoader, Configuration configuration, ClassLoader userCodeClassLoader) {
        super(executorServiceLoader, configuration, userCodeClassLoader);
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        JobClient jobClient = this.executeAsync(jobName);
        List jobListeners = this.getJobListeners();
        try {
            JobExecutionResult jobExecutionResult = this.getJobExecutionResult(jobClient);
            jobListeners.forEach(jobListener -> jobListener.onJobExecuted(jobExecutionResult, null));
            return jobExecutionResult;
        }
        catch (Throwable t) {
            jobListeners.forEach(jobListener -> jobListener.onJobExecuted(null, ExceptionUtils.stripExecutionException((Throwable)t)));
            ExceptionUtils.rethrowException((Throwable)t);
            return null;
        }
    }

    private JobExecutionResult getJobExecutionResult(JobClient jobClient) throws Exception {
        DetachedJobExecutionResult jobExecutionResult;
        Preconditions.checkNotNull((Object)jobClient);
        if (this.getConfiguration().getBoolean(DeploymentOptions.ATTACHED)) {
            CompletableFuture jobExecutionResultFuture = jobClient.getJobExecutionResult(this.getUserCodeClassLoader());
            if (this.getConfiguration().getBoolean(DeploymentOptions.SHUTDOWN_IF_ATTACHED)) {
                Thread shutdownHook = ShutdownHookUtil.addShutdownHook(() -> jobClient.cancel().get(1L, TimeUnit.SECONDS), (String)ContextEnvironment.class.getSimpleName(), (Logger)LOG);
                jobExecutionResultFuture.whenComplete((ignored, throwable) -> ShutdownHookUtil.removeShutdownHook((Thread)shutdownHook, (String)ContextEnvironment.class.getSimpleName(), (Logger)LOG));
            }
            jobExecutionResult = (JobExecutionResult)jobExecutionResultFuture.get();
            System.out.println(jobExecutionResult);
        } else {
            jobExecutionResult = new DetachedJobExecutionResult(jobClient.getJobID());
        }
        return jobExecutionResult;
    }

    public JobClient executeAsync(String jobName) throws Exception {
        JobClient jobClient = super.executeAsync(jobName);
        System.out.println("Job has been submitted with JobID " + jobClient.getJobID());
        return jobClient;
    }

    public String toString() {
        return "Context Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ")";
    }

    public static void setAsContext(ContextEnvironmentFactory factory) {
        ContextEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void unsetContext() {
        ContextEnvironment.resetContextEnvironment();
    }
}

