/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.ContextEnvironmentFactory;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.DetachedJobExecutionResult;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ClientUtils {

    private static final Logger LOG = LoggerFactory.getLogger(ClientUtils.class);

    public static ClassLoader buildUserCodeClassLoader(List<URL> jars, List<URL> classpaths, ClassLoader parent, Configuration configuration) {
        int i;
        URL[] urls = new URL[jars.size() + classpaths.size()];
        for (i = 0; i < jars.size(); ++i) {
            urls[i] = jars.get(i);
        }
        for (i = 0; i < classpaths.size(); ++i) {
            urls[i + jars.size()] = classpaths.get(i);
        }
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns((Configuration)configuration);
        String classLoaderResolveOrder = configuration.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        FlinkUserCodeClassLoaders.ResolveOrder resolveOrder = FlinkUserCodeClassLoaders.ResolveOrder.fromString((String)classLoaderResolveOrder);
        return FlinkUserCodeClassLoaders.create((FlinkUserCodeClassLoaders.ResolveOrder)resolveOrder, (URL[])urls, (ClassLoader)parent, (String[])alwaysParentFirstLoaderPatterns, (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER);
    }

    public static JobExecutionResult submitJob(ClusterClient<?> client, JobGraph jobGraph) throws ProgramInvocationException {
        Preconditions.checkNotNull(client);
        Preconditions.checkNotNull((Object)jobGraph);
        try {
            return (JobExecutionResult)((CompletableFuture)client.submitJob(jobGraph).thenApply(DetachedJobExecutionResult::new)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ExceptionUtils.checkInterrupted((Throwable)e);
            throw new ProgramInvocationException("Could not run job in detached mode.", jobGraph.getJobID(), e);
        }
    }

    public static JobExecutionResult submitJobAndWaitForResult(ClusterClient<?> client, JobGraph jobGraph, ClassLoader classLoader) throws ProgramInvocationException {
        JobResult jobResult;
        Preconditions.checkNotNull(client);
        Preconditions.checkNotNull((Object)jobGraph);
        Preconditions.checkNotNull((Object)classLoader);
        try {
            jobResult = (JobResult)((CompletableFuture)client.submitJob(jobGraph).thenCompose(client::requestJobResult)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ExceptionUtils.checkInterrupted((Throwable)e);
            throw new ProgramInvocationException("Could not run job", jobGraph.getJobID(), e);
        }
        try {
            return jobResult.toJobExecutionResult(classLoader);
        }
        catch (IOException | ClassNotFoundException | JobExecutionException e) {
            throw new ProgramInvocationException("Job failed", jobGraph.getJobID(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeProgram(PipelineExecutorServiceLoader executorServiceLoader, Configuration configuration, PackagedProgram program) throws ProgramInvocationException {
        Preconditions.checkNotNull((Object)executorServiceLoader);
        ClassLoader userCodeClassLoader = program.getUserCodeClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userCodeClassLoader);
            LOG.info("Starting program (detached: {})", (Object)(!configuration.getBoolean(DeploymentOptions.ATTACHED) ? 1 : 0));
            ContextEnvironmentFactory factory = new ContextEnvironmentFactory(executorServiceLoader, configuration, userCodeClassLoader);
            ContextEnvironment.setAsContext(factory);
            try {
                program.invokeInteractiveModeForExecution();
            }
            finally {
                ContextEnvironment.unsetContext();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

