/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import reactor.kafka.receiver.ReceiverOffset;

public class ReceiverRecord<K, V>
extends ConsumerRecord<K, V> {
    private static final Method CHECKSUM_METHOD;
    private final ReceiverOffset receiverOffset;

    public ReceiverRecord(ConsumerRecord<K, V> consumerRecord, ReceiverOffset receiverOffset) {
        super(consumerRecord.topic(), consumerRecord.partition(), consumerRecord.offset(), consumerRecord.timestamp(), consumerRecord.timestampType(), ReceiverRecord.checksum(consumerRecord), consumerRecord.serializedKeySize(), consumerRecord.serializedValueSize(), consumerRecord.key(), consumerRecord.value(), consumerRecord.headers());
        this.receiverOffset = receiverOffset;
    }

    private static Long checksum(ConsumerRecord consumerRecord) {
        Long checksum = -1L;
        if (CHECKSUM_METHOD != null) {
            try {
                checksum = (Long)CHECKSUM_METHOD.invoke((Object)consumerRecord, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return checksum;
    }

    public ReceiverOffset receiverOffset() {
        return this.receiverOffset;
    }

    static {
        Method method;
        try {
            method = ConsumerRecord.class.getDeclaredMethod("checksum", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            method = null;
        }
        CHECKSUM_METHOD = method;
    }
}

