/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.nacos;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.parser.el.ClassXmlFlowELParser;
import com.yomahub.liteflow.parser.nacos.exception.NacosException;
import com.yomahub.liteflow.parser.nacos.util.NacosParserHelper;
import com.yomahub.liteflow.parser.nacos.vo.NacosParserVO;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class NacosXmlELParser
extends ClassXmlFlowELParser {
    private final NacosParserHelper helper;

    public NacosXmlELParser() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        try {
            NacosParserVO nacosParserVO = null;
            if (MapUtil.isNotEmpty((Map)liteflowConfig.getRuleSourceExtDataMap())) {
                nacosParserVO = (NacosParserVO)BeanUtil.toBean((Object)liteflowConfig.getRuleSourceExtDataMap(), NacosParserVO.class, (CopyOptions)CopyOptions.create());
            } else if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getRuleSourceExtData())) {
                nacosParserVO = (NacosParserVO)JsonUtil.parseObject((String)liteflowConfig.getRuleSourceExtData(), NacosParserVO.class);
            }
            if (Objects.isNull(nacosParserVO)) {
                throw new NacosException("rule-source-ext-data is empty");
            }
            if (StrUtil.isBlank((CharSequence)nacosParserVO.getServerAddr())) {
                nacosParserVO.setServerAddr("127.0.0.1:8848");
            }
            if (StrUtil.isBlank((CharSequence)nacosParserVO.getNamespace())) {
                nacosParserVO.setNamespace("");
            }
            if (StrUtil.isBlank((CharSequence)nacosParserVO.getDataId())) {
                nacosParserVO.setDataId("LiteFlow");
            }
            if (StrUtil.isBlank((CharSequence)nacosParserVO.getGroup())) {
                nacosParserVO.setGroup("LITE_FLOW_GROUP");
            }
            if (StrUtil.isBlank((CharSequence)nacosParserVO.getUsername())) {
                nacosParserVO.setUsername("");
            }
            if (StrUtil.isBlank((CharSequence)nacosParserVO.getPassword())) {
                nacosParserVO.setPassword("");
            }
            if (StrUtil.isBlank((CharSequence)nacosParserVO.getAccessKey())) {
                nacosParserVO.setAccessKey("");
            }
            if (StrUtil.isBlank((CharSequence)nacosParserVO.getSecretKey())) {
                nacosParserVO.setSecretKey("");
            }
            this.helper = new NacosParserHelper(nacosParserVO);
        }
        catch (Exception e) {
            throw new NacosException(e.getMessage());
        }
    }

    public String parseCustom() {
        Consumer<String> parseConsumer = t -> {
            try {
                this.parse((String)t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        try {
            String content = this.helper.getContent();
            this.helper.checkContent(content);
            this.helper.listener(parseConsumer);
            return content;
        }
        catch (Exception e) {
            throw new NacosException(e.getMessage());
        }
    }
}

