/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectionTool {
    private static Integer INTEGER_ONE = 1;

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionTool.isEmpty(coll);
    }

    public static boolean contains(Collection<?> collection, Object value) {
        return CollectionTool.isNotEmpty(collection) && collection.contains(value);
    }

    public static Collection union(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionTool.getCardinalityMap(a);
        Map mapb = CollectionTool.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.max(CollectionTool.getFreq(obj, mapa), CollectionTool.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    private static final int getFreq(Object obj, Map freqMap) {
        Integer count = (Integer)freqMap.get(obj);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public static Map getCardinalityMap(Collection coll) {
        HashMap count = new HashMap();
        for (Object obj : coll) {
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, INTEGER_ONE);
                continue;
            }
            count.put(obj, c + 1);
        }
        return count;
    }

    public static Collection intersection(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionTool.getCardinalityMap(a);
        Map mapb = CollectionTool.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.min(CollectionTool.getFreq(obj, mapa), CollectionTool.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static Collection disjunction(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionTool.getCardinalityMap(a);
        Map mapb = CollectionTool.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.max(CollectionTool.getFreq(obj, mapa), CollectionTool.getFreq(obj, mapb)) - Math.min(CollectionTool.getFreq(obj, mapa), CollectionTool.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static Collection subtract(Collection a, Collection b) {
        ArrayList list = new ArrayList(a);
        Iterator it = b.iterator();
        while (it.hasNext()) {
            list.remove(it.next());
        }
        return list;
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    public static <E> List<List<E>> split(List<E> list, int batchSize) {
        if (list == null || list.isEmpty() || batchSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<List<List<E>>> result = new ArrayList<List<List<E>>>();
        int totalSize = list.size();
        for (int i = 0; i < totalSize; i += batchSize) {
            int end = Math.min(i + batchSize, totalSize);
            result.add(list.subList(i, end));
        }
        return result;
    }
}

