/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.tree;

import com.diffplug.common.tree.TreeDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TreeQuery {
    private TreeQuery() {
    }

    public static <T> boolean isDescendantOf(TreeDef.Parented<T> treeDef, T child, T parent) {
        Objects.requireNonNull(child);
        Objects.requireNonNull(parent);
        T candidateParent = treeDef.parentOf(child);
        while (candidateParent != null) {
            if (candidateParent.equals(parent)) {
                return true;
            }
            candidateParent = treeDef.parentOf(candidateParent);
        }
        return false;
    }

    public static <T> boolean isDescendantOfOrEqualTo(TreeDef.Parented<T> treeDef, T child, T parent) {
        Objects.requireNonNull(treeDef);
        Objects.requireNonNull(parent);
        if (child.equals(parent)) {
            return true;
        }
        return TreeQuery.isDescendantOf(treeDef, child, parent);
    }

    public static <T> T root(TreeDef.Parented<T> treeDef, T node) {
        T lastParent;
        T parent = node;
        while ((parent = treeDef.parentOf(lastParent = parent)) != null) {
        }
        return lastParent;
    }

    public static <T> List<T> toRoot(TreeDef.Parented<T> treeDef, T node) {
        Objects.requireNonNull(node);
        ArrayList<T> list = new ArrayList<T>();
        T tip = node;
        while (tip != null) {
            list.add(tip);
            tip = treeDef.parentOf(tip);
        }
        return list;
    }

    public static <T, CopyType> CopyType copyLeavesIn(TreeDef<T> def, T root, BiFunction<T, List<CopyType>, CopyType> nodeMapper) {
        List childrenMapped = def.childrenOf(root).stream().map(child -> TreeQuery.copyLeavesIn(def, child, nodeMapper)).collect(Collectors.toList());
        return nodeMapper.apply(root, childrenMapped);
    }

    public static <T, CopyType> CopyType copyRootOut(TreeDef<T> def, T root, BiFunction<T, CopyType, CopyType> mapper) {
        List<T> children = def.childrenOf(root);
        CopyType copyRoot = mapper.apply(root, null);
        TreeQuery.copyMutableRecurse(def, root, children, copyRoot, mapper);
        return copyRoot;
    }

    private static <T, CopyType> void copyMutableRecurse(TreeDef<T> def, T root, List<T> children, CopyType copiedRoot, BiFunction<T, CopyType, CopyType> mapper) {
        for (T child : children) {
            List<T> grandChildren = def.childrenOf(child);
            TreeQuery.copyMutableRecurse(def, root, grandChildren, mapper.apply(child, copiedRoot), mapper);
        }
    }

    public static <T> List<T> toParent(TreeDef.Parented<T> treeDef, T node, T parent) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(parent);
        ArrayList<T> list = new ArrayList<T>();
        T tip = node;
        do {
            list.add(tip);
            tip = treeDef.parentOf(tip);
            if (tip != null) continue;
            throw new IllegalArgumentException(parent + " is not a parent of " + node);
        } while (!tip.equals(parent));
        list.add(parent);
        return list;
    }

    private static <T> Optional<T> lowestCommonAncestor(TreeDef.Parented<T> treeDef, T nodeA, T nodeB) {
        class TreeSearcher {
            private T tip;
            private final Set<T> visited;
            final /* synthetic */ TreeDef.Parented val$treeDef;

            public TreeSearcher(T t) {
                this.val$treeDef = t;
                this.tip = start;
                this.visited = new HashSet();
            }

            public boolean hasMore() {
                return this.tip != null;
            }

            public Optional<T> march(TreeSearcher other) {
                if (other.visited.contains(this.tip)) {
                    return Optional.of(this.tip);
                }
                this.visited.add(this.tip);
                this.tip = this.val$treeDef.parentOf(this.tip);
                return Optional.empty();
            }
        }
        TreeSearcher searchA = new TreeSearcher(nodeA, treeDef);
        TreeSearcher searchB = new TreeSearcher(nodeB, treeDef);
        Optional commonAncestor = searchB.march(searchA);
        while (searchA.hasMore() && searchB.hasMore()) {
            commonAncestor = searchA.march(searchB);
            if (commonAncestor.isPresent()) {
                return commonAncestor;
            }
            commonAncestor = searchB.march(searchA);
            if (!commonAncestor.isPresent()) continue;
            return commonAncestor;
        }
        while (searchA.hasMore() && !commonAncestor.isPresent()) {
            commonAncestor = searchA.march(searchB);
        }
        while (searchB.hasMore() && !commonAncestor.isPresent()) {
            commonAncestor = searchB.march(searchA);
        }
        return commonAncestor;
    }

    @SafeVarargs
    public static <T> Optional<T> lowestCommonAncestor(TreeDef.Parented<T> treeDef, T ... nodes) {
        return TreeQuery.lowestCommonAncestor(treeDef, Arrays.asList(nodes));
    }

    public static <T> Optional<T> lowestCommonAncestor(TreeDef.Parented<T> treeDef, List<T> nodes) {
        Objects.requireNonNull(treeDef);
        if (nodes.size() == 0) {
            return Optional.empty();
        }
        Optional<T> soFar = Optional.of(nodes.get(0));
        for (int i = 1; i < nodes.size() && soFar.isPresent(); ++i) {
            soFar = TreeQuery.lowestCommonAncestor(treeDef, soFar.get(), nodes.get(i));
        }
        return soFar;
    }

    public static <T> String path(TreeDef.Parented<T> treeDef, T node, Function<? super T, String> toString, String delimiter) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(delimiter);
        List<T> toRoot = TreeQuery.toRoot(treeDef, node);
        ListIterator<T> iterator = toRoot.listIterator(toRoot.size());
        StringBuilder builder = new StringBuilder();
        while (iterator.hasPrevious()) {
            T segment = iterator.previous();
            builder.append(toString.apply(segment));
            if (!iterator.hasPrevious()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static <T> String path(TreeDef.Parented<T> treeDef, T node, Function<? super T, String> toString) {
        return TreeQuery.path(treeDef, node, toString, "/");
    }

    public static <T> String path(TreeDef.Parented<T> treeDef, T node) {
        return TreeQuery.path(treeDef, node, Object::toString);
    }

    public static <T, P> Optional<T> findByPath(TreeDef<T> treeDef, T node, List<P> path, BiPredicate<T, P> equality) {
        Objects.requireNonNull(treeDef);
        Objects.requireNonNull(node);
        Objects.requireNonNull(equality);
        Object value = node;
        for (Object segment : path) {
            Optional<Object> valueOpt = treeDef.childrenOf(value).stream().filter(n -> equality.test(n, segment)).findFirst();
            if (!valueOpt.isPresent()) {
                return valueOpt;
            }
            value = valueOpt.get();
        }
        return Optional.of(value);
    }

    public static <T, P> Optional<T> findByPath(TreeDef<T> treeDef, T node, Function<? super T, ?> treeMapper, List<P> path, Function<? super P, ?> pathMapper) {
        Objects.requireNonNull(treeMapper);
        Objects.requireNonNull(path);
        Objects.requireNonNull(pathMapper);
        return TreeQuery.findByPath(treeDef, node, path, (T treeSide, P pathSide) -> Objects.equals(treeMapper.apply(treeSide), pathMapper.apply((Object)pathSide)));
    }

    public static <T> Optional<T> findByPath(TreeDef<T> treeDef, T node, List<T> path, Function<? super T, ?> mapper) {
        return TreeQuery.findByPath(treeDef, node, mapper, path, mapper);
    }

    public static <T> String toString(TreeDef<T> treeDef, T root) {
        return TreeQuery.toString(treeDef, root, Object::toString);
    }

    public static <T> String toString(TreeDef<T> treeDef, T root, Function<? super T, String> toString) {
        return TreeQuery.toString(treeDef, root, toString, " ");
    }

    public static <T> String toString(TreeDef<T> treeDef, T root, Function<? super T, String> toString, String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(toString.apply(root));
        builder.append("\n");
        TreeQuery.toStringHelper(treeDef, root, toString, indent, builder, indent);
        return builder.toString();
    }

    private static <T> void toStringHelper(TreeDef<T> treeDef, T root, Function<? super T, String> toString, String indent, StringBuilder builder, String prefix) {
        Objects.requireNonNull(prefix);
        for (T child : treeDef.childrenOf(root)) {
            builder.append(prefix);
            builder.append(toString.apply(child));
            builder.append("\n");
            TreeQuery.toStringHelper(treeDef, child, toString, indent, builder, prefix + indent);
        }
    }
}

