/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.h8900.oauth.handle;

import com.dahuatech.h8900.oauth.http.H8900HttpRequest;
import com.dahuatech.h8900.oauth.http.H8900Token;
import com.dahuatech.h8900.oauth.profile.GrantType;
import com.dahuatech.h8900.oauth.profile.H8900Profile;
import com.dahuatech.hutool.core.thread.NamedThreadFactory;
import com.dahuatech.hutool.http.HttpRequest;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.http.Method;
import com.dahuatech.hutool.json.JSONObject;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.exception.ServerException;
import com.dahuatech.icc.util.BeanUtil;
import com.dahuatech.icc.util.SignUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TokenHandleSingle {
    private static final Log logger = LogFactory.get();
    private static final AtomicBoolean TOKEN_INITED = new AtomicBoolean(Boolean.FALSE);
    private static final long FRESH_TOKEN_INTERVAL = 30000L;
    private final ScheduledExecutorService REFRESH_TOKEN_SCHEDULED = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Icc-Refresh-Token", true));
    private final Map<String, H8900Token> tokenMap = new ConcurrentHashMap<String, H8900Token>();
    private final Boolean ipmsInstall = Boolean.FALSE;

    public Map<String, H8900Token> getTokenMap() {
        return this.tokenMap;
    }

    private TokenHandleSingle() {
        this.REFRESH_TOKEN_SCHEDULED.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    TokenHandleSingle.this.refreshTokenAndKeepAlive();
                }
                catch (Throwable t) {
                    logger.error("Unexpected error occur at token refresh, cause: " + t.getMessage(), new Object[]{t});
                }
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public static synchronized TokenHandleSingle getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized H8900Token refreshToken(GrantType grantType) {
        H8900Token token = null;
        try {
            switch (grantType) {
                case password: {
                    token = this.password();
                    break;
                }
            }
        }
        catch (ClientException e) {
            logger.error("get token failure", new Object[0]);
        }
        if (!TOKEN_INITED.get() && token != null) {
            TOKEN_INITED.set(Boolean.TRUE);
        }
        return token;
    }

    private H8900Token password() throws ClientException, ServerException {
        H8900HttpRequest pubRequest = new H8900HttpRequest(H8900Profile.HTTP_PROTOCOL + H8900Profile.host + "/WPMS/getPublicKey", Method.POST);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("loginName", H8900Profile.username);
        pubRequest.body(JSONUtil.toJsonStr(map));
        String pubBody = pubRequest.execute();
        JSONObject pubKey = JSONUtil.parseObj((String)pubBody);
        if (pubKey == null || pubKey != null && !pubKey.containsKey((Object)"publicKey")) {
            logger.error("get public key faiure [{}]", new Object[]{"/WPMS/getPublicKey"});
            throw new ServerException("get public key faiure");
        }
        HashMap<String, String> pass = new HashMap<String, String>();
        pass.put("loginName", H8900Profile.username);
        pass.put("loginPass", SignUtil.encryptRSA((String)H8900Profile.password, (String)pubKey.getStr((Object)"publicKey")));
        H8900HttpRequest pr = new H8900HttpRequest(H8900Profile.HTTP_PROTOCOL + H8900Profile.host + "/WPMS/login", Method.POST, JSONUtil.toJsonStr(pass));
        String prBody = pr.execute();
        H8900Token token = (H8900Token)BeanUtil.toBean((String)prBody, H8900Token.class);
        if (token == null || !"true".equals(token.getSuccess())) {
            logger.error(" h8900 auth failure [{}] reason [{}]", new Object[]{"/WPMS/login", token == null ? "" : token.getErrMsg()});
            throw new ClientException("h8900 [password] username=[" + H8900Profile.username + "],password=[" + H8900Profile.password + "] get token failure");
        }
        token.setTtl(System.currentTimeMillis() + 30000L);
        this.tokenMap.put(H8900Profile.host, token);
        this.refreshIpmsAccessToken();
        return token;
    }

    private void refreshIpmsAccessToken() {
        HttpRequest ipmsRequest = HttpRequest.get((String)(H8900Profile.HTTPS_PROTOCOL + H8900Profile.host + "/ipms/subSystem/generate/token?userName=system"));
        try {
            JSONObject rs;
            HttpResponse result = ipmsRequest.execute();
            if (result.getStatus() == 200 && "true".equals((rs = JSONUtil.parseObj((String)result.body())).getStr((Object)"success"))) {
                String accessToken = rs.getJSONObject((Object)"data").getStr((Object)"accessToken");
                H8900Token token = this.tokenMap.get(H8900Profile.host);
                token.setIpmsAccessToken(accessToken);
                this.tokenMap.put(H8900Profile.host, token);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public H8900Token getTokenCache() {
        return this.tokenMap.get(H8900Profile.host);
    }

    public H8900Token refreshToken() {
        try {
            return this.password();
        }
        catch (Exception e) {
            logger.error("fresh token error {}", new Object[]{e});
            return null;
        }
    }

    private void refreshTokenAndKeepAlive() {
        if (TOKEN_INITED.get() && this.tokenMap.size() > 0) {
            for (Map.Entry<String, H8900Token> entry : this.tokenMap.entrySet()) {
                H8900Token token = entry.getValue();
                Long currentTime = System.currentTimeMillis();
                this.refreshIpmsAccessToken();
                if (token.getTtl() - currentTime > 120000L || (token = this.refreshToken()) == null) continue;
                this.tokenMap.put(entry.getKey(), token);
                logger.debug("refresh token success, [{}],token=[{}]", new Object[]{entry.getKey(), token});
            }
        }
    }

    private String enGrantKeyName(String grantType) {
        return grantType + ":" + H8900Profile.host;
    }

    private GrantType deGrantType(String grantKeyName) {
        return GrantType.valueOf(grantKeyName.substring(0, grantKeyName.indexOf(":")));
    }

    private static class SingletonHolder {
        private static final TokenHandleSingle INSTANCE = new TokenHandleSingle();

        private SingletonHolder() {
        }
    }
}

