/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.h8900.oauth.constant;

import com.dahuatech.h8900.oauth.profile.H8900Profile;
import com.dahuatech.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class H8900OauthConstant {
    public static final String SYSTEM_NAME = "admin";
    public static final String OAUTH_URL_PUBLIC_KEY_POST = "/WPMS/getPublicKey";
    public static final String OAUTH_URL_PWD_AUTH_POST = "/WPMS/login";
    public static final String IPMS_TOKEN_GET = "/ipms/subSystem/generate/token?userName=system";
    private static String HTTP_PREFIX = H8900Profile.HTTP_PROTOCOL + H8900Profile.host;
    private static String HTTPS_PREFIX = H8900Profile.HTTPS_PROTOCOL + H8900Profile.host;
    private static List<String> PORT_8314 = new ArrayList<String>(Arrays.asList("/CardSolution/", "/admin/rest/api"));
    private static List<String> PORT_8103 = new ArrayList<String>(Arrays.asList("/ipms/"));
    public static String version = "1.0.0";
    private static boolean initVersionFromBrm = Boolean.FALSE;

    public static String urls(String url) {
        if (StrUtil.startWith((CharSequence)url, (CharSequence)"http")) {
            return url;
        }
        if (H8900OauthConstant.urlContains(url, PORT_8314)) {
            return H8900Profile.HTTP_PROTOCOL + H8900Profile.host + ":8314" + url;
        }
        return H8900Profile.HTTPS_PROTOCOL + H8900Profile.host + url;
    }

    private static boolean urlContains(String url, Collection<?> collection) {
        for (Object ct : collection) {
            if (!url.contains((String)ct)) continue;
            return true;
        }
        return false;
    }

    public static String url(String url) {
        boolean containsHttpPrefix = false;
        if (StrUtil.startWith((CharSequence)url, (CharSequence)"http")) {
            return String.format(url, version);
        }
        return String.format(H8900Profile.URL_SCHEME + url, version);
    }

    public static enum ClientType {
        WEB(1),
        CLIENT(2),
        APP(3);

        private int clientType;

        private ClientType(int clientType) {
            this.clientType = clientType;
        }

        public int getClientType() {
            return this.clientType;
        }
    }
}

