/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.sentry.bo.QueryAlertIdDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskCreateKafkaBO;
import com.ifourthwall.dbm.sentry.bo.UpMonitorRecordDoBO;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.kafka.DataHandler;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="UpdateTaskIdHandler")
public class UpdateTaskIdHandler
implements DataHandler {
    private static final Logger log = LoggerFactory.getLogger(UpdateTaskIdHandler.class);
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Autowired
    private RedisTemplate redisTemplate;

    public void handle(String jsonStrData) {
        log.info("\u63a5\u6536\u5230dbm_task_alert_auto_create\u7684\u6570\u636e" + jsonStrData);
        TaskCreateKafkaBO taskId = (TaskCreateKafkaBO)JSONUtils.jacksonFromJson((String)jsonStrData, TaskCreateKafkaBO.class);
        if (taskId != null && !StringUtils.isEmpty((CharSequence)taskId.getAlertId())) {
            QueryAlertIdDoBO queryAlertIdDoBO = new QueryAlertIdDoBO();
            queryAlertIdDoBO.setAlertId(taskId.getAlertId());
            queryAlertIdDoBO.setLanguageCode("CN");
            Boolean aBoolean = this.monitorRepository.queryAlertId(queryAlertIdDoBO);
            if (aBoolean.booleanValue()) {
                UpMonitorRecordDoBO upMonitorRecordDoBO = new UpMonitorRecordDoBO();
                upMonitorRecordDoBO.setAlertId(taskId.getAlertId());
                upMonitorRecordDoBO.setTaskStatusId("1");
                upMonitorRecordDoBO.setTaskWorkSheetId(taskId.getTaskId());
                this.monitorRepository.upMonitorRecord(upMonitorRecordDoBO);
                if (this.redisTemplate.hasKey((Object)RedisKeyPrefixUtil.getTaskAutoCreateTaskPrefix((String)taskId.getAlertId())).booleanValue()) {
                    this.redisTemplate.delete((Object)RedisKeyPrefixUtil.getTaskAutoCreateTaskPrefix((String)taskId.getAlertId()));
                }
            }
        }
    }

    public boolean judge(String topic) {
        return StringUtils.equals((CharSequence)"dbm_task_alert_auto_create", (CharSequence)topic);
    }
}

