/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.sentry.bo.QueryTaskIdQuDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskWorksheetStatusKafkaBO;
import com.ifourthwall.dbm.sentry.bo.UpMonitorRecordDoBO;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.kafka.DataHandler;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="UpdateStatusHandler")
public class UpdateStatusHandler
implements DataHandler {
    private static final Logger log = LoggerFactory.getLogger(UpdateStatusHandler.class);
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Autowired
    private RedisTemplate redisTemplate;

    public void handle(String jsonStrData) {
        log.info("\u63a5\u6536\u5230dbm_task_alert_update_status\u7684\u6570\u636e" + jsonStrData);
        TaskWorksheetStatusKafkaBO taskStatus = (TaskWorksheetStatusKafkaBO)JSONUtils.jacksonFromJson((String)jsonStrData, TaskWorksheetStatusKafkaBO.class);
        QueryTaskIdQuDoBO query = new QueryTaskIdQuDoBO();
        query.setTaskWorkSheetId(taskStatus.getTaskId());
        Boolean aBoolean = this.monitorRepository.queryTaskId(query);
        if (aBoolean.booleanValue()) {
            UpMonitorRecordDoBO upMonitorRecordDoBO = new UpMonitorRecordDoBO();
            if ("6".equals(taskStatus.getWorksheetStatusId()) || "8".equals(taskStatus.getWorksheetStatusId())) {
                upMonitorRecordDoBO.setTaskStatusId("3");
            } else if ("1".equals(taskStatus.getWorksheetStatusId())) {
                upMonitorRecordDoBO.setTaskStatusId("1");
            } else {
                upMonitorRecordDoBO.setTaskStatusId("2");
            }
            upMonitorRecordDoBO.setTaskWorkSheetId(taskStatus.getTaskId());
            this.monitorRepository.upMonitorByTaskId(upMonitorRecordDoBO);
        } else {
            log.info("\u8be5taskId\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0\u81ea\u52a8\u544a\u8b66\u4efb\u52a1\u72b6\u6001");
        }
    }

    public boolean judge(String topic) {
        return StringUtils.equals((CharSequence)"dbm_task_alert_update_status", (CharSequence)topic);
    }
}

