/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.dbm.asset.dto.file.SeerFileQuDTO;
import com.ifourthwall.dbm.sentry.bo.AssetInfoQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.FileExportBO;
import com.ifourthwall.dbm.sentry.bo.GetNewPathBatchQueryBO;
import com.ifourthwall.dbm.sentry.bo.GodzillaInfoBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpacePathBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetByDPDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetByDPDoQuBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetInfoDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.bo.SeerFileQuBO;
import com.ifourthwall.dbm.sentry.bo.file.SentryExcelBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.config.SentryExcelConfig;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.domain.SpaceRepository;
import com.ifourthwall.dbm.sentry.service.SentryFileService;
import com.ifourthwall.dbm.sentry.util.TimeUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SentryFileServiceImpl")
public class SentryFileServiceImpl
implements SentryFileService {
    private static final Logger log = LoggerFactory.getLogger(SentryFileServiceImpl.class);
    @Autowired
    private SentryExcelConfig excelConfig;
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Resource(name="AssetRepository")
    private AssetRepository assetRepository;
    @Resource(name="SpaceRepository")
    private SpaceRepository spaceRepository;

    public FileExportBO download(SeerFileQuDTO query, IFWUser user) {
        FileExportBO result = new FileExportBO();
        String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
        query.setTenantId(tenantId);
        SentryExcelBO sentryExcelBO = new SentryExcelBO();
        if ("CN".equals(query.getLanguageCode())) {
            sentryExcelBO = (SentryExcelBO)this.excelConfig.getList().get(0);
        }
        if ("EN".equals(query.getLanguageCode())) {
            sentryExcelBO = (SentryExcelBO)this.excelConfig.getList().get(1);
        }
        if ("JP".equals(query.getLanguageCode())) {
            sentryExcelBO = (SentryExcelBO)this.excelConfig.getList().get(2);
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(query.getMonitorMetricName());
        XSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue(sentryExcelBO.getSpace());
        row.createCell(1).setCellValue(sentryExcelBO.getName());
        row.createCell(2).setCellValue(sentryExcelBO.getTime());
        row.createCell(3).setCellValue(sentryExcelBO.getValue());
        row.createCell(4).setCellValue(sentryExcelBO.getMax());
        row.createCell(5).setCellValue(sentryExcelBO.getMin());
        row.createCell(6).setCellValue(sentryExcelBO.getUnit());
        row.createCell(7).setCellValue(sentryExcelBO.getUser());
        row.createCell(8).setCellValue(sentryExcelBO.getType());
        QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
        queryAppIdQueryDoBO.setTenantId(tenantId);
        QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDoBO);
        if (queryAppIdBO != null) {
            MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
            metricValueRecordListReqBO.setDataPointId(query.getDataPointId());
            metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
            metricValueRecordListReqBO.setStartTime(query.getStartTime());
            metricValueRecordListReqBO.setEndTime(query.getEndTime());
            MetricValueRecordListBO metricValueRecordListBO = this.godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
            if (metricValueRecordListBO != null) {
                QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                queryRuleAndStartBO.setDataPointId(query.getDataPointId());
                QueryRuleAndStartDoBO queryRuleAndStartDoBO = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                if (queryRuleAndStartDoBO != null) {
                    int fistRow = 1;
                    for (GodzillaInfoBO godzillaInfoBO : metricValueRecordListBO.getCollectDataList()) {
                        XSSFRow row1 = sheet.createRow(fistRow);
                        row1.createCell(0).setCellValue(query.getSpaceName());
                        row1.createCell(1).setCellValue(query.getAssetName());
                        row1.createCell(2).setCellValue(godzillaInfoBO.getTime());
                        row1.createCell(3).setCellValue(godzillaInfoBO.getValue());
                        row1.createCell(4).setCellValue(godzillaInfoBO.getAlarmMax());
                        row1.createCell(5).setCellValue(godzillaInfoBO.getAlarmMin());
                        row1.createCell(6).setCellValue(queryRuleAndStartDoBO.getUnit());
                        row1.createCell(7).setCellValue(godzillaInfoBO.getUserName());
                        row1.createCell(8).setCellValue(query.getMetricType());
                        ++fistRow;
                    }
                }
            }
        }
        result.setFile(wb);
        result.setFilename(query.getMonitorMetricName());
        return result;
    }

    public FileExportBO downloadByDataPoint(SeerFileQuBO query, IFWUser user) {
        FileExportBO result = new FileExportBO();
        String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
        query.setTenantId(tenantId);
        queryDataPointIdQuBO queryDataByMonitorQuDoBO = new queryDataPointIdQuBO();
        queryDataByMonitorQuDoBO.setDataPointId(query.getDataPointId());
        queryDataByMonitorQuDoBO.setTenantId(query.getTenantId());
        queryDataByMonitorQuDoBO.setLanguageCode(query.getLanguageCode());
        queryDataPointIdBO queryDataByMonitorDoBO = this.monitorRepository.queryDataPointId(queryDataByMonitorQuDoBO);
        QueryAssetByDPDoQuBO queryAsset = new QueryAssetByDPDoQuBO();
        queryAsset.setDataPointId(query.getDataPointId());
        QueryAssetByDPDoBO asset = this.monitorRepository.queryAssetByDP(queryAsset);
        String assetName = "unknown";
        String spaceName = "unknown";
        if (asset != null) {
            AssetInfoQueryDoBO assetInfoQueryDoBO = new AssetInfoQueryDoBO();
            assetInfoQueryDoBO.setAssetId(asset.getAssetId());
            assetInfoQueryDoBO.setLanguageCode(query.getLanguageCode());
            QueryAssetInfoDoBO queryAssetInfoDoBO = this.assetRepository.queryAssetInfo(assetInfoQueryDoBO);
            if (queryAssetInfoDoBO != null) {
                assetName = queryAssetInfoDoBO.getAssetName();
            }
            GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
            ArrayList<String> spaceIds = new ArrayList<String>();
            spaceIds.add(queryAssetInfoDoBO.getProjectSpaceId());
            getNewPathBatchQueryBO.setProjectSpaceId(spaceIds);
            getNewPathBatchQueryBO.setProjectId(queryAssetInfoDoBO.getProjectId());
            getNewPathBatchQueryBO.setLanguageCode(query.getLanguageCode());
            getNewPathBatchQueryBO.setTenantId(tenantId);
            List newPathBatch = this.spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
            if (newPathBatch != null) {
                spaceName = ((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr();
            }
        }
        SentryExcelBO sentryExcelBO = new SentryExcelBO();
        if ("CN".equals(query.getLanguageCode())) {
            sentryExcelBO = (SentryExcelBO)this.excelConfig.getList().get(0);
        }
        if ("EN".equals(query.getLanguageCode())) {
            sentryExcelBO = (SentryExcelBO)this.excelConfig.getList().get(1);
        }
        if ("JP".equals(query.getLanguageCode())) {
            sentryExcelBO = (SentryExcelBO)this.excelConfig.getList().get(2);
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(queryDataByMonitorDoBO.getMonitorMetricName());
        XSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue(sentryExcelBO.getSpace());
        row.createCell(1).setCellValue(sentryExcelBO.getName());
        row.createCell(2).setCellValue(sentryExcelBO.getTime());
        row.createCell(3).setCellValue(sentryExcelBO.getValue());
        row.createCell(4).setCellValue(sentryExcelBO.getMax());
        row.createCell(5).setCellValue(sentryExcelBO.getMin());
        row.createCell(6).setCellValue(sentryExcelBO.getUnit());
        row.createCell(7).setCellValue(sentryExcelBO.getUser());
        row.createCell(8).setCellValue(sentryExcelBO.getType());
        if (queryDataByMonitorDoBO != null) {
            QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
            queryAppIdQueryDoBO.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDoBO);
            if (queryAppIdBO != null) {
                MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                metricValueRecordListReqBO.setDataPointId(query.getDataPointId());
                metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
                metricValueRecordListReqBO.setStartTime(query.getStartTime());
                metricValueRecordListReqBO.setEndTime(query.getEndTime());
                MetricValueRecordListBO metricValueRecordListBO = this.godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                if (metricValueRecordListBO != null) {
                    QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                    queryRuleAndStartBO.setDataPointId(query.getDataPointId());
                    QueryRuleAndStartDoBO queryRuleAndStartDoBO = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                    if (queryRuleAndStartDoBO != null) {
                        int fistRow = 1;
                        for (GodzillaInfoBO godzillaInfoBO : metricValueRecordListBO.getCollectDataList()) {
                            XSSFRow row1 = sheet.createRow(fistRow);
                            row1.createCell(0).setCellValue(spaceName);
                            row1.createCell(1).setCellValue(assetName);
                            row1.createCell(2).setCellValue(godzillaInfoBO.getTime());
                            row1.createCell(3).setCellValue(godzillaInfoBO.getValue());
                            row1.createCell(4).setCellValue(godzillaInfoBO.getAlarmMax());
                            row1.createCell(5).setCellValue(godzillaInfoBO.getAlarmMin());
                            row1.createCell(6).setCellValue(queryRuleAndStartDoBO.getUnit());
                            row1.createCell(7).setCellValue(godzillaInfoBO.getUserName());
                            row1.createCell(8).setCellValue(queryDataByMonitorDoBO.getMetricType());
                            ++fistRow;
                        }
                    }
                }
            }
        }
        result.setFile(wb);
        result.setFilename(queryDataByMonitorDoBO.getMonitorMetricName());
        return result;
    }

    public static void main(String[] args) throws ParseException {
        String[] split;
        boolean send = false;
        String time = "00:00-15:12";
        SimpleDateFormat formatHours = new SimpleDateFormat("HH:mm");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (String s : split = time.split(",")) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            String[] split1 = s.split("-");
            String start = split1[0];
            String end = split1[1];
            Date startTime = formatHours.parse(start);
            Date endTime = formatHours.parse(end);
            Date nowTime = format.parse(format.format(new Date()));
            boolean effectiveDate = TimeUtils.isEffectiveDate((Date)nowTime, (Date)startTime, (Date)endTime);
            if (effectiveDate) continue;
            log.info("\u4e0d\u5728\u544a\u8b66\u533a\u95f4\u5185");
            send = true;
            break;
        }
        if (!send) {
            log.info("\u4e0d\u5728\u544a\u8b66\u533a\u95f4\u5185");
        }
    }
}

