/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingInfoDTO;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingQuDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetQuDTO;
import com.ifourthwall.dbm.asset.facade.MonitorReadingFacade;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.bo.meter.QueryMetricByAssetQuDoBO;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorReadingRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.domain.SpaceRepository;
import com.ifourthwall.dbm.sentry.domain.TaskRepository;
import com.ifourthwall.dbm.sentry.service.MonitorReadingService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MonitorReadingServiceImpl")
public class MonitorReadingServiceImpl
implements MonitorReadingService {
    private static final Logger log = LoggerFactory.getLogger(MonitorReadingServiceImpl.class);
    @Reference(version="1.0.0")
    private MonitorReadingFacade readingFacade;
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Resource(name="AssetRepository")
    private AssetRepository assetRepository;
    @Resource(name="SpaceRepository")
    private SpaceRepository spaceRepository;
    @Resource(name="MonitorReadingRepository")
    private MonitorReadingRepository monitorReading;
    @Resource(name="TaskRepository")
    private TaskRepository taskRepository;
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;

    public BaseResponse<List<TrackerMeterReadingInfoDTO>> trackerOfflineMeterReading(TrackerMeterReadingQuDTO trackerOffline, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)trackerOffline.getTenantId(), (IFWUser)user);
            trackerOffline.setTenantId(tenantId);
            QueryMetricByAssetQuDoBO queryMetricByAssetQuDoBO = new QueryMetricByAssetQuDoBO();
            queryMetricByAssetQuDoBO.setType("1");
            queryMetricByAssetQuDoBO.setProjectId(trackerOffline.getProjectId());
            queryMetricByAssetQuDoBO.setLanguageCode(trackerOffline.getLanguageCode());
            queryMetricByAssetQuDoBO.setTenantId(trackerOffline.getTenantId());
            queryMetricByAssetQuDoBO.setProjectId(trackerOffline.getProjectId());
            List queryMetricByAssetDoBOS = this.monitorReading.queryMetricByAsset(queryMetricByAssetQuDoBO);
            if (queryMetricByAssetDoBOS != null) {
                List resultList = IFWBeanCopyUtil.mapAsList((Iterable)queryMetricByAssetDoBOS, TrackerMeterReadingInfoDTO.class);
                QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
                queryAppIdQueryDoBO.setTenantId(trackerOffline.getTenantId());
                QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDoBO);
                if (queryAppIdBO != null) {
                    List collect = resultList.stream().filter(a -> a.getDataPointId() != null).collect(Collectors.toList());
                    for (TrackerMeterReadingInfoDTO result : collect) {
                        QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                        queryRuleAndStartBO.setDataPointId(result.getDataPointId());
                        QueryRuleAndStartDoBO queryRuleAndStartDoBO = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                        if (queryRuleAndStartDoBO != null && !StringUtils.isEmpty((CharSequence)queryRuleAndStartDoBO.getUnit())) {
                            result.setUnit(queryRuleAndStartDoBO.getUnit());
                        }
                        result.setAppId(queryAppIdBO.getAppId());
                    }
                }
                response.setData((Object)resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<List<QueryMetricByAssetDTO>> queryMetricByAsset(QueryMetricByAssetQuDTO queryMetricByAsset, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)queryMetricByAsset.getTenantId(), (IFWUser)user);
            queryMetricByAsset.setTenantId(tenantId);
            List queryMetricByAssetDoBOS = this.monitorReading.queryMetricByAsset((QueryMetricByAssetQuDoBO)IFWBeanCopyUtil.map((Object)queryMetricByAsset, QueryMetricByAssetQuDoBO.class));
            if (queryMetricByAssetDoBOS != null) {
                List resultList = IFWBeanCopyUtil.mapAsList((Iterable)queryMetricByAssetDoBOS, QueryMetricByAssetDTO.class);
                response.setData((Object)resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }
}

