/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWUUIDUtils;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryCreateTaskDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryInsertAlertIdDTO;
import com.ifourthwall.dbm.asset.facade.MonitorMetricFacade;
import com.ifourthwall.dbm.sentry.bo.AssetInfoQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.CreateTaskQueryDTO;
import com.ifourthwall.dbm.sentry.bo.GetNewPathBatchQueryBO;
import com.ifourthwall.dbm.sentry.bo.KafkaAlertBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpacePathBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetByDPDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetByDPDoQuBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetInfoDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryByDataPointBasicBO;
import com.ifourthwall.dbm.sentry.bo.QueryByDataPointDTO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskInsertDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskSpaceInsertBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.constant.TaskSourceEnum;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorReadingRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.domain.SpaceRepository;
import com.ifourthwall.dbm.sentry.dto.QueryByDataPointQuDTO;
import com.ifourthwall.dbm.sentry.service.MonitorMetricService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.kafka.IFWKafkaClient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="MonitorMetricServiceImpl")
public class MonitorMetricServiceImpl
implements MonitorMetricService {
    private static final Logger log = LoggerFactory.getLogger(MonitorMetricServiceImpl.class);
    @Reference(version="1.0.0")
    private MonitorMetricFacade metricFacade;
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Resource(name="AssetRepository")
    private AssetRepository assetRepository;
    @Resource(name="SpaceRepository")
    private SpaceRepository spaceRepository;
    @Resource(name="MonitorReadingRepository")
    private MonitorReadingRepository monitorReading;
    @Value(value="${robot.system.id}")
    private String robotId;
    @Value(value="${robot.system.position.id}")
    private String robotPositionId;
    @Resource(name="IFWKafkaClient-dbm_sentry_alert_create_task")
    private IFWKafkaClient ifwKafkaClientCreateTask;

    public BaseResponse<CheckDataPointIdDTO> checkDataPointId(CheckDataPointIdQuDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
        query.setTenantId(tenantId);
        return this.metricFacade.checkDataPointId(query);
    }

    public BaseResponse<QueryByDataPointDTO> queryByDataPoint(QueryByDataPointQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            QueryByDataPointDTO result = new QueryByDataPointDTO();
            String tenantId = CheckAccessUtils.judgeTenantId(null, (IFWUser)user);
            queryDataPointIdQuBO queryDataByMonitorQuDoBO = new queryDataPointIdQuBO();
            queryDataByMonitorQuDoBO.setDataPointId(query.getDataPointId());
            queryDataByMonitorQuDoBO.setTenantId(tenantId);
            queryDataByMonitorQuDoBO.setLanguageCode("CN");
            queryDataPointIdBO queryDataByMonitorDoBO = this.monitorRepository.queryDataPointId(queryDataByMonitorQuDoBO);
            QueryAssetByDPDoQuBO queryAsset = new QueryAssetByDPDoQuBO();
            queryAsset.setDataPointId(query.getDataPointId());
            QueryAssetByDPDoBO asset = this.monitorRepository.queryAssetByDP(queryAsset);
            if (asset != null) {
                AssetInfoQueryDoBO assetInfoQueryDoBO = new AssetInfoQueryDoBO();
                assetInfoQueryDoBO.setAssetId(asset.getAssetId());
                assetInfoQueryDoBO.setLanguageCode("CN");
                QueryAssetInfoDoBO queryAssetInfoDoBO = this.assetRepository.queryAssetInfo(assetInfoQueryDoBO);
                if (queryAssetInfoDoBO != null) {
                    result.setAssetName(queryAssetInfoDoBO.getAssetName());
                }
                GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
                ArrayList<String> spaceIds = new ArrayList<String>();
                spaceIds.add(queryAssetInfoDoBO.getProjectSpaceId());
                getNewPathBatchQueryBO.setProjectSpaceId(spaceIds);
                getNewPathBatchQueryBO.setProjectId(queryAssetInfoDoBO.getProjectId());
                getNewPathBatchQueryBO.setLanguageCode("CN");
                getNewPathBatchQueryBO.setTenantId(tenantId);
                List newPathBatch = this.spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
                if (newPathBatch != null) {
                    result.setSpaceName(((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                }
                result.setMetricName(queryDataByMonitorDoBO.getMonitorMetricName());
            }
            QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
            queryAppIdQueryDoBO.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDoBO);
            if (queryAppIdBO != null) {
                MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                metricValueRecordListReqBO.setDataPointId(query.getDataPointId());
                metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
                metricValueRecordListReqBO.setStartTime(query.getStartTime());
                metricValueRecordListReqBO.setEndTime(query.getEndTime());
                MetricValueRecordListBO metricValueRecordListBO = this.godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                if (metricValueRecordListBO != null) {
                    List queryByDataPointBasicBOS = IFWBeanCopyUtil.mapAsList((Iterable)metricValueRecordListBO.getCollectDataList(), QueryByDataPointBasicBO.class);
                    result.setMetricValueInfo(queryByDataPointBasicBOS);
                    QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                    queryRuleAndStartBO.setDataPointId(query.getDataPointId());
                    QueryRuleAndStartDoBO queryRuleAndStartDoBO = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                    if (queryRuleAndStartDoBO != null) {
                        result.setUnit(queryRuleAndStartDoBO.getUnit());
                    }
                }
            }
            result.setDataPointId(query.getDataPointId());
            response.setData((Object)result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse sentryCreateTask(SentryCreateTaskDTO create, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)create.getTenantId(), (IFWUser)user);
            String alertId = null;
            if (!StringUtils.isEmpty((CharSequence)create.getAlertId())) {
                alertId = create.getAlertId();
            } else {
                alertId = IFWUUIDUtils.randomUUID();
                SentryInsertAlertIdDTO insertAlertIdDTO = new SentryInsertAlertIdDTO();
                insertAlertIdDTO.setAlertId(alertId);
                insertAlertIdDTO.setMonitorRecordId(create.getMonitorRecordId());
                insertAlertIdDTO.setMonitorTargetId(create.getMonitorTargetId());
                insertAlertIdDTO.setUpdateBy(user.getUserId());
                this.monitorReading.insertAlertId(insertAlertIdDTO);
            }
            GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(create.getSpaceId());
            getNewPathBatchQueryBO.setProjectSpaceId(ids);
            getNewPathBatchQueryBO.setProjectId(create.getProjectId());
            getNewPathBatchQueryBO.setLanguageCode("CN");
            getNewPathBatchQueryBO.setTenantId(create.getTenantId());
            List newPathBatch = this.spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
            if (DataUtils.isListAvali((List)newPathBatch)) {
                KafkaAlertBO kafkaAlertBO = new KafkaAlertBO();
                CreateTaskQueryDTO query1 = new CreateTaskQueryDTO();
                TaskInsertDoBO taskQuery = new TaskInsertDoBO();
                ArrayList<TaskSpaceInsertBO> taskSpaceInfo = new ArrayList<TaskSpaceInsertBO>();
                TaskSpaceInsertBO taskSpace = new TaskSpaceInsertBO();
                taskSpace.setSpaceId(create.getSpaceId());
                taskSpace.setTaskSpaceDescription(((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                taskSpaceInfo.add(taskSpace);
                ArrayList<String> operatingId = new ArrayList<String>();
                operatingId.add(this.robotPositionId);
                taskQuery.setCreateByPositionId(this.robotPositionId);
                taskQuery.setTenantId(create.getTenantId());
                taskQuery.setProjectId(create.getProjectId());
                taskQuery.setTaskTypeId("1");
                taskQuery.setCreateBy(user.getUserId());
                taskQuery.setTaskTemplateId(create.getTaskTemplateId());
                taskQuery.setTaskName(create.getTaskName());
                taskQuery.setTaskDescription(create.getTaskDescription());
                taskQuery.setCreateByPositionId(this.robotPositionId);
                taskQuery.setTaskSource(TaskSourceEnum.SENTRY.getId());
                query1.setTask(taskQuery);
                ArrayList assetIds = new ArrayList();
                query1.setAssetIdList(assetIds);
                kafkaAlertBO.setAlertId(alertId);
                kafkaAlertBO.setTaskBO(query1);
                kafkaAlertBO.getTaskBO().setTaskSpaceList(taskSpaceInfo);
                String sendInfo = JSONUtils.jacksonToJson((Object)kafkaAlertBO);
                log.info("\u81ea\u52a8\u521b\u5efa\u5de5\u5355\uff0ckafka\u53d1\u9001\u6570\u636e" + sendInfo);
                this.ifwKafkaClientCreateTask.syncProduce(sendInfo);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }
}

