/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.asset.dto.GetDataPointBasisOneQueryDTO;
import com.ifourthwall.dbm.asset.dto.PageDTO;
import com.ifourthwall.dbm.asset.dto.app.UpdateAppIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.QueryAllDataPointDTO;
import com.ifourthwall.dbm.asset.dto.metric.QueryAllDataPointQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.EnvironmentListQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListQuBasisDTO;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.asset.facade.MonitorMetricFacade;
import com.ifourthwall.dbm.message.facade.dto.PushMessageReqDTO;
import com.ifourthwall.dbm.message.facade.dto.QueryMessageConfigReqDTO;
import com.ifourthwall.dbm.message.facade.dto.QueryMessageConfigResDTO;
import com.ifourthwall.dbm.message.facade.service.MessageServiceFacade;
import com.ifourthwall.dbm.project.dto.project.QueryCountryIdDTO;
import com.ifourthwall.dbm.project.dto.project.QueryCountryIdQuDTO;
import com.ifourthwall.dbm.sentry.bo.AssetInfoQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.CreateTaskQueryDTO;
import com.ifourthwall.dbm.sentry.bo.GetDataPointQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.GetNewPathBatchQueryBO;
import com.ifourthwall.dbm.sentry.bo.GetProjectSpaceInfoQueryBO;
import com.ifourthwall.dbm.sentry.bo.KafkaAlertBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpacePathBO;
import com.ifourthwall.dbm.sentry.bo.PushMessageSentryBO;
import com.ifourthwall.dbm.sentry.bo.QueryAlarmRuleDetailBO;
import com.ifourthwall.dbm.sentry.bo.QueryAlertIdDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetByDPDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetByDPDoQuBO;
import com.ifourthwall.dbm.sentry.bo.QueryAssetInfoDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryMonitorInfoDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryMonitorInfoQueryBasisDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryProjectPagePO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryTenantIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryTenantIdDoQueryBO;
import com.ifourthwall.dbm.sentry.bo.TaskInsertDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskSpaceInsertBO;
import com.ifourthwall.dbm.sentry.bo.UpAssetStatusDoBO;
import com.ifourthwall.dbm.sentry.bo.UpdateAlarmNumberBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleInsertBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleListReqBO;
import com.ifourthwall.dbm.sentry.bo.alarm.DatapointAndAlarmRuleBindReqBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.bo.obj.QueryTeantNameReqDoBO;
import com.ifourthwall.dbm.sentry.bo.obj.QueryTeantNameResDoBO;
import com.ifourthwall.dbm.sentry.constant.TaskSourceEnum;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.domain.ProjectRepository;
import com.ifourthwall.dbm.sentry.domain.SpaceRepository;
import com.ifourthwall.dbm.sentry.domain.TaskRepository;
import com.ifourthwall.dbm.sentry.domain.UserRepository;
import com.ifourthwall.dbm.sentry.service.MonitorAlarmService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.dbm.sentry.util.TimeUtils;
import com.ifourthwall.kafka.IFWKafkaClient;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="MonitorAlarmServiceImpl")
public class MonitorAlarmServiceImpl
implements MonitorAlarmService {
    private static final Logger log = LoggerFactory.getLogger(MonitorAlarmServiceImpl.class);
    public static final String ENABLE_ALARM = "1";
    public static final String DISABLE_ALARM = "0";
    public static final String ASIA_TOKYO = "JST";
    public static final String ASIA_SHANGHAI = "CTT";
    public static final String EUROPE_PARIS = "CST";
    @Autowired
    private RedisTemplate redisTemplate;
    @Reference(version="1.0.0")
    private MonitorFacade monitorFacade;
    @Reference(version="1.0.0")
    private MonitorMetricFacade monitorMetricFacade;
    @Resource(name="MonitorRepository")
    private MonitorRepository monitorRepository;
    @Resource(name="ProjectRepository")
    private ProjectRepository projectRepository;
    @Resource(name="AssetRepository")
    private AssetRepository assetRepository;
    @Resource(name="SpaceRepository")
    private SpaceRepository spaceRepository;
    @Resource(name="TaskRepository")
    private TaskRepository taskRepository;
    @Resource(name="UserRepository")
    private UserRepository userRepository;
    @Reference(version="1.0.0")
    private MessageServiceFacade messageServiceFacade;
    @Value(value="${robot.system.id}")
    private String robotId;
    @Value(value="${callback.url}")
    private String callbackUrl;
    @Value(value="${callback.token}")
    private String callbackToken;
    @Value(value="${robot.system.position.id}")
    private String robotPositionId;
    @Autowired
    private GodzillaServerRepository godzillaServerRepository;
    @Resource(name="IFWKafkaClient-dbm_sentry_alert_create_task")
    private IFWKafkaClient ifwKafkaClientCreateTask;
    @Resource(name="IFWKafkaClient-dbm_sentry_update_space_special_alarm_num")
    private IFWKafkaClient ifwKafkaClientUpdateAlarmNumber;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse getDataPoint(GetDataPointBasisOneQueryDTO dataPointBasis) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(new Date());
        log.info("\u63a5\u6536\u5230\u54e5\u65af\u62c9\u544a\u8b66\u4fe1\u606f\uff0c\u72b6\u6001\u4e3a\uff1a{}" + dataPointBasis.getDataPointStatus() + ",AlertId\u4e3a\uff1a{}" + dataPointBasis.getAlertId());
        BaseResponse response = new BaseResponse();
        try {
            Map message = (Map)JSONUtils.jacksonFromJson((String)dataPointBasis.getMessage(), HashMap.class);
            log.info("json\u8f6c\u6362" + message);
            ArrayList<PushMessageReqDTO> pushMessageReqDTOS = new ArrayList<PushMessageReqDTO>();
            QueryAlertIdDoBO queryAlertId = new QueryAlertIdDoBO();
            queryAlertId.setAlertId(dataPointBasis.getAlertId());
            queryAlertId.setLanguageCode("CN");
            Boolean alertId = this.monitorRepository.queryAlertId(queryAlertId);
            log.info("\u8be5AlertId\u662f\u5426\u5b58\u5728\uff1a" + alertId);
            if (!alertId.booleanValue()) {
                SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                QueryTenantIdDoQueryBO queryTenantId = new QueryTenantIdDoQueryBO();
                queryTenantId.setDataPointId(dataPointBasis.getDataPointId());
                QueryTenantIdBO tenantId = this.monitorRepository.queryTenantId(queryTenantId);
                IFWValidator.validate((Object)tenantId);
                QueryMonitorInfoQueryBasisDoBO query = new QueryMonitorInfoQueryBasisDoBO();
                ArrayList<String> monitorTargetId = new ArrayList<String>();
                monitorTargetId.add(tenantId.getMonitorTargetId());
                query.setTenantId(tenantId.getTenantId());
                query.setMonitorTargetId(monitorTargetId);
                query.setLanguageCode("CN");
                QueryMonitorInfoDoBO monitorInfo = this.monitorRepository.queryMonitorInfo(query);
                log.info("\u67e5\u8be2\u51fa\u76d1\u63a7\u5bf9\u8c61\u4fe1\u606f \uff1a" + monitorInfo);
                GetNewPathBatchQueryBO querySpaceName = new GetNewPathBatchQueryBO();
                ArrayList<String> spaceId = new ArrayList<String>();
                spaceId.add(monitorInfo.getSpaceId());
                querySpaceName.setProjectId(monitorInfo.getProjectId());
                querySpaceName.setProjectSpaceId(spaceId);
                querySpaceName.setLanguageCode("CN");
                List newPathBatch = this.spaceRepository.getNewPathBatch(querySpaceName);
                log.info("\u67e5\u8be2\u7a7a\u95f4\uff1a" + newPathBatch);
                QueryMessageConfigReqDTO queryMessageConfigReqDTO = new QueryMessageConfigReqDTO();
                queryMessageConfigReqDTO.setProjectId(monitorInfo.getProjectId());
                queryMessageConfigReqDTO.setMessageType(ENABLE_ALARM);
                queryMessageConfigReqDTO.setLanguageCode("CN");
                queryMessageConfigReqDTO.setTenantId(tenantId.getTenantId());
                log.info("\u67e5\u8be2\u544a\u8b66\u4eba\u5458\u4fe1\u606f\uff1a" + queryMessageConfigReqDTO);
                BaseResponse listBaseResponse = this.messageServiceFacade.queryMessageTemplateConfig(queryMessageConfigReqDTO);
                log.info("\u8fd4\u56de\u544a\u8b66\u4eba\u5458\u4fe1\u606f\uff1a" + listBaseResponse);
                queryDataPointIdQuBO queryDataPointIdQuBO2 = new queryDataPointIdQuBO();
                queryDataPointIdQuBO2.setDataPointId(dataPointBasis.getDataPointId());
                queryDataPointIdQuBO2.setLanguageCode("CN");
                queryDataPointIdQuBO2.setTenantId(tenantId.getTenantId());
                queryDataPointIdBO queryDataPointIdBO2 = this.monitorRepository.queryDataPointId(queryDataPointIdQuBO2);
                GetProjectSpaceInfoQueryBO getProjectSpaceInfoQueryBO = new GetProjectSpaceInfoQueryBO();
                getProjectSpaceInfoQueryBO.setTenantId(tenantId.getTenantId());
                getProjectSpaceInfoQueryBO.setProjectId(monitorInfo.getProjectId());
                getProjectSpaceInfoQueryBO.setLanguageCode("CN");
                QueryProjectPagePO projectSpaceInfo = this.projectRepository.getProjectSpaceInfo(getProjectSpaceInfoQueryBO);
                QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
                queryAppIdQueryDoBO.setTenantId(tenantId.getTenantId());
                QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDoBO);
                boolean send = false;
                QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                queryRuleAndStartBO.setDataPointId(dataPointBasis.getDataPointId());
                QueryRuleAndStartDoBO queryRuleAndStartDoBO = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                if (queryRuleAndStartDoBO != null && queryAppIdBO != null) {
                    String[] ruleIds;
                    String ruleId = null;
                    for (String id : ruleIds = queryRuleAndStartDoBO.getAlarmRuleId().split(",")) {
                        if (id.equals(queryAppIdBO.getDefaultAlarmRuleId())) continue;
                        ruleId = id;
                    }
                    if (ruleId != null) {
                        QueryAlarmRuleDetailBO queryAlarmRuleDetailBO = new QueryAlarmRuleDetailBO();
                        queryAlarmRuleDetailBO.setAlarmRuleId(ruleId);
                        AlarmRuleBO alarmRuleBO = this.godzillaServerRepository.queryAlarmRuleDetail(queryAlarmRuleDetailBO);
                        if (alarmRuleBO != null && !StringUtils.isEmpty((CharSequence)alarmRuleBO.getValidTime())) {
                            SimpleDateFormat formatHours = new SimpleDateFormat("HH:mm");
                            String[] split = alarmRuleBO.getValidTime().split(",");
                            log.info("\u9017\u53f7\u62c6\u5206\u7ed3\u679c\uff1a" + split);
                            for (String s : split) {
                                if (StringUtils.isEmpty((CharSequence)s)) continue;
                                String[] split1 = s.split("-");
                                log.info("\u6760\u53f7\u62c6\u5206\u7ed3\u679c\uff1a" + split1);
                                String start = split1[0];
                                String end = split1[1];
                                Date startTime = formatHours.parse(start);
                                Date endTime = formatHours.parse(end);
                                Date nowTime = format.parse(format.format(new Date()));
                                log.info("\u67e5\u8be2\u65f6\u95f4\u6bb5\uff1a" + nowTime + "," + startTime + "," + endTime);
                                boolean effectiveDate = TimeUtils.isEffectiveDate((Date)nowTime, (Date)startTime, (Date)endTime);
                                log.info("\u67e5\u8be2\u7ed3\u679c\uff1a" + effectiveDate);
                                if (effectiveDate) continue;
                                send = true;
                                log.info("\u4e0d\u5728\u544a\u8b66\u533a\u95f4\u5185");
                                break;
                            }
                        }
                    }
                }
                if (monitorInfo != null) {
                    if (dataPointBasis.getDataPointStatus().equals("alerting") && !send) {
                        GetDataPointQueryDoBO insertDataPoint = new GetDataPointQueryDoBO();
                        StringBuilder stringBuilder = new StringBuilder();
                        BeanUtils.copyProperties((Object)dataPointBasis.getMessage(), (Object)insertDataPoint);
                        insertDataPoint.setMonitorTargetId(monitorInfo.getMonitorTargetId());
                        insertDataPoint.setAssetId(monitorInfo.getAssetId());
                        insertDataPoint.setProjectId(monitorInfo.getProjectId());
                        insertDataPoint.setTenantId(tenantId.getTenantId());
                        insertDataPoint.setAlertId(dataPointBasis.getAlertId());
                        insertDataPoint.setCreateBy(this.robotId);
                        insertDataPoint.setMessage(dataPointBasis.getMessage());
                        insertDataPoint.setMessage((String)message.get("message"));
                        insertDataPoint.setDataPointId((String)message.get("dataPointId"));
                        insertDataPoint.setDataPointStatus((String)message.get("dataPointStatus"));
                        insertDataPoint.setCollectTime((String)message.get("collectTime"));
                        insertDataPoint.setValue(stringBuilder.append(message.get("value")).append(dataPointBasis.getDataPointUnit()).toString());
                        if (ENABLE_ALARM.equals(monitorInfo.getAutoCreateTemporaryTaskId())) {
                            insertDataPoint.setTaskStatusId("4");
                        } else if (DISABLE_ALARM.equals(monitorInfo.getAutoCreateTemporaryTaskId())) {
                            insertDataPoint.setTaskStatusId(ENABLE_ALARM);
                        }
                        this.monitorRepository.insetMonitorRecord(insertDataPoint);
                        log.info("\u4fe1\u606f\u5b58\u5165\u6210\u529f\uff0c\u662f\u5426\u81ea\u52a8\u53d1\u9001\u5de5\u5355 \uff1a" + monitorInfo.getAutoCreateTemporaryTaskId());
                        if (DISABLE_ALARM.equals(monitorInfo.getAutoCreateTemporaryTaskId())) {
                            String time;
                            log.info("\u81ea\u52a8\u53d1\u9001\u5de5\u5355\u521b\u5efa\u4e2d");
                            QueryCountryIdQuDTO queryCountryIdQuDTO = new QueryCountryIdQuDTO();
                            queryCountryIdQuDTO.setTenantId(tenantId.getTenantId());
                            queryCountryIdQuDTO.setLanguageCode("CN");
                            queryCountryIdQuDTO.setProjectId(monitorInfo.getProjectId());
                            QueryCountryIdDTO queryCountryIdDTO = this.projectRepository.queryCountryId(queryCountryIdQuDTO);
                            KafkaAlertBO kafkaAlertBO = new KafkaAlertBO();
                            CreateTaskQueryDTO query1 = new CreateTaskQueryDTO();
                            TaskInsertDoBO taskQuery = new TaskInsertDoBO();
                            ArrayList<TaskSpaceInsertBO> taskSpaceInfo = new ArrayList<TaskSpaceInsertBO>();
                            TaskSpaceInsertBO taskSpace = new TaskSpaceInsertBO();
                            taskSpace.setSpaceId(monitorInfo.getSpaceId());
                            taskSpace.setTaskSpaceDescription(((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                            taskSpaceInfo.add(taskSpace);
                            ArrayList<String> operatingId = new ArrayList<String>();
                            operatingId.add(this.robotPositionId);
                            taskQuery.setCreateByPositionId(this.robotPositionId);
                            taskQuery.setTenantId(tenantId.getTenantId());
                            taskQuery.setProjectId(monitorInfo.getProjectId());
                            taskQuery.setTaskTypeId(ENABLE_ALARM);
                            taskQuery.setCreateBy(this.robotId);
                            taskQuery.setTaskTemplateId(monitorInfo.getTaskTemplateId());
                            taskQuery.setTaskSource(TaskSourceEnum.SENTRY.getId());
                            if (queryCountryIdDTO.getCountryId() == null || queryCountryIdDTO.getCountryId() == 1) {
                                time = TimeUtils.TimeChange((Date)new Date(), (String)"CN");
                                taskQuery.setTaskName("Sentry\u544a\u8b66");
                                taskQuery.setTaskDescription("\u91c7\u96c6\u503c(\u6284\u8868\u503c)\uff1a" + dataPointBasis.getValue() + "\u544a\u8b66\u503c\uff1a" + dataPointBasis.getValue() + "\u544a\u8b66\u5185\u5bb9:" + (String)message.get("message") + "; \u544a\u8b66\u65f6\u95f4:" + time);
                            } else if (queryCountryIdDTO.getCountryId() == 2) {
                                time = TimeUtils.TimeChange((Date)new Date(), (String)"JP");
                                taskQuery.setTaskName("sentry\u30a2\u30e9\u30fc\u30e0");
                                taskQuery.setTaskDescription("\u53ce\u96c6\u5024\uff08\u30e1\u30fc\u30bf\u30fc\u5024\uff09\uff1a" + dataPointBasis.getValue() + "\u30a2\u30e9\u30fc\u30e0\u8a73\u7d30\uff1a" + dataPointBasis.getValue() + "\u30a2\u30e9\u30fc\u30e0\u60c5\u5831:" + (String)message.get("message") + "; \u30a2\u30e9\u30fc\u30e0\u6642\u9593:" + time);
                            } else {
                                time = TimeUtils.TimeChange((Date)new Date(), (String)"EN");
                                taskQuery.setTaskName("Sentry Alert");
                                taskQuery.setTaskDescription("Collected value (read meter value)\uff1a" + dataPointBasis.getValue() + "Value\uff1a" + dataPointBasis.getValue() + "Message:" + (String)message.get("message") + "; Time:" + time);
                            }
                            taskQuery.setCreateByPositionId(this.robotPositionId);
                            query1.setTask(taskQuery);
                            ArrayList<String> assetIds = new ArrayList<String>();
                            assetIds.add(monitorInfo.getAssetId());
                            query1.setAssetIdList(assetIds);
                            kafkaAlertBO.setAlertId(dataPointBasis.getAlertId());
                            kafkaAlertBO.setTaskBO(query1);
                            kafkaAlertBO.getTaskBO().setTaskSpaceList(taskSpaceInfo);
                            String sendInfo = JSONUtils.jacksonToJson((Object)kafkaAlertBO);
                            log.info("\u81ea\u52a8\u521b\u5efa\u5de5\u5355\uff0ckafka\u53d1\u9001\u6570\u636e" + sendInfo);
                            this.ifwKafkaClientCreateTask.syncProduce(sendInfo);
                        }
                        UpdateAlarmNumberBO updateAlarmNumberBO = new UpdateAlarmNumberBO();
                        updateAlarmNumberBO.setType(Integer.valueOf(1));
                        updateAlarmNumberBO.setSpaceId(monitorInfo.getSpaceId());
                        updateAlarmNumberBO.setAssetId(monitorInfo.getAssetId());
                        String sendInfo1 = JSONUtils.jacksonToJson((Object)updateAlarmNumberBO);
                        log.info("seer\u6807\u7b7e\u7edf\u8ba1\u6570\u91cf+1\uff0c\u5b58\u5165\u6570\u636e\u4e3a\uff1a" + sendInfo1);
                        this.ifwKafkaClientUpdateAlarmNumber.syncProduce(sendInfo1);
                        log.info("seer\u6807\u7b7e\u7edf\u8ba1\u6570\u91cf+1\uff0c\u7a7a\u95f4\u4e3a\uff1a" + monitorInfo.getSpaceId());
                        if (DataUtils.isListAvali((List)((List)listBaseResponse.getData()))) {
                            log.info("\u53d1\u9001\u6d88\u606f\u4e2d\u5fc3\u4e2d...");
                            for (QueryMessageConfigResDTO pushInfo : (List)listBaseResponse.getData()) {
                                log.info("\u544a\u8b66\u4eba\u4fe1\u606f\uff1a" + pushInfo);
                                PushMessageReqDTO pushMessageReqDTO = new PushMessageReqDTO();
                                pushMessageReqDTO.setTenantId(tenantId.getTenantId());
                                pushMessageReqDTO.setToUserId(pushInfo.getUserId());
                                PushMessageSentryBO pushMessageSentryBO = new PushMessageSentryBO();
                                pushMessageSentryBO.setTime(timeFormat.format(new Date()));
                                pushMessageSentryBO.setAssetName(monitorInfo.getAssetName());
                                if (queryDataPointIdBO2 != null) {
                                    pushMessageSentryBO.setMonitorMetricName(queryDataPointIdBO2.getMonitorMetricName());
                                }
                                pushMessageSentryBO.setSpaceName(((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                                pushMessageSentryBO.setSpaceId(monitorInfo.getSpaceId());
                                pushMessageSentryBO.setMessageInfo((String)message.get("message"));
                                pushMessageSentryBO.setMessageInfo((String)message.get("message"));
                                pushMessageSentryBO.setSentryStatus(dataPointBasis.getDataPointStatus());
                                if (projectSpaceInfo != null && projectSpaceInfo.getProjectName() != null) {
                                    pushMessageSentryBO.setProjectName(projectSpaceInfo.getProjectName());
                                }
                                pushMessageSentryBO.setMessageType(ENABLE_ALARM);
                                pushMessageSentryBO.setProjectId(monitorInfo.getProjectId());
                                pushMessageSentryBO.setAssetId(monitorInfo.getAssetId());
                                pushMessageSentryBO.setMonitorTargetId(monitorInfo.getMonitorTargetId());
                                pushMessageSentryBO.setDataPointId(dataPointBasis.getDataPointId());
                                String sendMessage = JSONUtils.jacksonToJson((Object)pushMessageSentryBO);
                                pushMessageReqDTO.setPushContent(sendMessage);
                                pushMessageReqDTO.setGodzillaDeviceTypes("0,2");
                                pushMessageReqDTO.setMessageType(ENABLE_ALARM);
                                pushMessageReqDTO.setProjectId(monitorInfo.getProjectId());
                                pushMessageReqDTOS.add(pushMessageReqDTO);
                            }
                        } else {
                            log.info("\u672a\u914d\u7f6e\u6d88\u606f\u53d1\u9001\uff01");
                        }
                    }
                    if (dataPointBasis.getDataPointStatus().equals("ok")) {
                        QueryAssetByDPDoQuBO queryAsset = new QueryAssetByDPDoQuBO();
                        queryAsset.setDataPointId(dataPointBasis.getDataPointId());
                        QueryAssetByDPDoBO assetId = this.monitorRepository.queryAssetByDP(queryAsset);
                        AssetInfoQueryDoBO queryAssetInfo = new AssetInfoQueryDoBO();
                        queryAssetInfo.setAssetId(assetId.getAssetId());
                        queryAssetInfo.setLanguageCode("CN");
                        QueryAssetInfoDoBO queryAssetInfoDoBO = this.assetRepository.queryAssetInfo(queryAssetInfo);
                        log.info("\u67e5\u8be2\u5230\u8d44\u4ea7\u4fe1\u606f" + queryAssetInfoDoBO);
                        UpAssetStatusDoBO upAssetStatusDoBO = new UpAssetStatusDoBO();
                        upAssetStatusDoBO.setCollectTime(dataPointBasis.getCollectTime());
                        upAssetStatusDoBO.setAlertId(dataPointBasis.getAlertId());
                        upAssetStatusDoBO.setProjectId(monitorInfo.getProjectId());
                        upAssetStatusDoBO.setMonitorTargetId(monitorInfo.getMonitorTargetId());
                        upAssetStatusDoBO.setAssetId(assetId.getAssetId());
                        upAssetStatusDoBO.setAssetStatus(ENABLE_ALARM);
                        upAssetStatusDoBO.setUpdateBy(this.robotId);
                        upAssetStatusDoBO.setDataPointId(dataPointBasis.getDataPointId());
                        upAssetStatusDoBO.setTenantId(tenantId.getTenantId());
                        log.info("\u66f4\u6539\u8d44\u4ea7\u72b6\u6001" + upAssetStatusDoBO);
                        this.assetRepository.upAssetStatus(upAssetStatusDoBO);
                        log.info("\u66f4\u6539\u8d44\u4ea7\u72b6\u6001\u6210\u529f\uff01\u51c6\u5907\u63d2\u5165\u7a7a\u95f4\u6807\u7b7e");
                        if (queryAssetInfoDoBO != null) {
                            UpdateAlarmNumberBO updateAlarmNumberBO = new UpdateAlarmNumberBO();
                            updateAlarmNumberBO.setType(Integer.valueOf(2));
                            updateAlarmNumberBO.setSpaceId(queryAssetInfoDoBO.getProjectSpaceId());
                            updateAlarmNumberBO.setAssetId(assetId.getAssetId());
                            String sendInfo1 = JSONUtils.jacksonToJson((Object)updateAlarmNumberBO);
                            log.info("seer\u6807\u7b7e\u7edf\u8ba1\u6570\u91cf-1\uff0c\u5b58\u5165\u6570\u636e\u4e3a\uff1a" + sendInfo1);
                            this.ifwKafkaClientUpdateAlarmNumber.syncProduce(sendInfo1);
                            log.info("seer\u6807\u7b7e\u7edf\u8ba1\u6570\u91cf-1\uff0c\u5b58\u5165\u6210\u529f");
                        }
                        if (!send && DataUtils.isListAvali((List)((List)listBaseResponse.getData()))) {
                            for (QueryMessageConfigResDTO pushInfo : (List)listBaseResponse.getData()) {
                                log.info("\u544a\u8b66\u4eba\u4fe1\u606f\uff1a" + pushInfo);
                                PushMessageReqDTO pushMessageReqDTO = new PushMessageReqDTO();
                                pushMessageReqDTO.setTenantId(tenantId.getTenantId());
                                pushMessageReqDTO.setToUserId(pushInfo.getUserId());
                                PushMessageSentryBO pushMessageSentryBO = new PushMessageSentryBO();
                                pushMessageSentryBO.setTime(timeFormat.format(new Date()));
                                pushMessageSentryBO.setAssetName(monitorInfo.getAssetName());
                                if (queryDataPointIdBO2 != null) {
                                    pushMessageSentryBO.setMonitorMetricName(queryDataPointIdBO2.getMonitorMetricName());
                                }
                                pushMessageSentryBO.setSpaceName(((ProjectSpacePathBO)newPathBatch.get(0)).getNameStr());
                                pushMessageSentryBO.setSpaceId(monitorInfo.getSpaceId());
                                pushMessageSentryBO.setMessageInfo((String)message.get("message"));
                                pushMessageSentryBO.setSentryStatus(dataPointBasis.getDataPointStatus());
                                if (projectSpaceInfo != null && projectSpaceInfo.getProjectName() != null) {
                                    pushMessageSentryBO.setProjectName(projectSpaceInfo.getProjectName());
                                }
                                pushMessageSentryBO.setProjectId(monitorInfo.getProjectId());
                                pushMessageSentryBO.setAssetId(monitorInfo.getAssetId());
                                pushMessageSentryBO.setMonitorTargetId(monitorInfo.getMonitorTargetId());
                                pushMessageSentryBO.setDataPointId(dataPointBasis.getDataPointId());
                                pushMessageSentryBO.setMessageType(ENABLE_ALARM);
                                String sendMessage = JSONUtils.jacksonToJson((Object)pushMessageSentryBO);
                                pushMessageReqDTO.setPushContent(sendMessage);
                                pushMessageReqDTO.setGodzillaDeviceTypes("0,2");
                                pushMessageReqDTO.setMessageType(ENABLE_ALARM);
                                pushMessageReqDTO.setProjectId(monitorInfo.getProjectId());
                                pushMessageReqDTOS.add(pushMessageReqDTO);
                            }
                        }
                    }
                }
            }
            log.info("\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01\u6570\u636e\u4e3a\uff1a" + pushMessageReqDTOS);
            this.messageServiceFacade.batchPush(pushMessageReqDTOS);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
            log.error("DataPointId\u672a\u7ed1\u5b9a!DataPointId:" + dataPointBasis.getDataPointId());
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<String> datapointInfo(EnvironmentListQuDTO query) {
        BaseResponse response = new BaseResponse();
        if (DataUtils.isListAvali((List)query.getMonitorTargetTagId())) {
            HashMap map1 = new HashMap();
            QueryEnvironmentListQuBasisDTO queryMonitorMetricListDoBO = new QueryEnvironmentListQuBasisDTO();
            queryMonitorMetricListDoBO.setLanguageCode("CN");
            queryMonitorMetricListDoBO.setMonitorTargetTagId(query.getMonitorTargetTagId());
            BaseResponse list = this.monitorFacade.queryMetricList(queryMonitorMetricListDoBO);
            if (list.getData() != null) {
                List collect = ((List)list.getData()).stream().map(QueryEnvironmentListDTO::getDataPointId).distinct().collect(Collectors.toList());
                List collect1 = ((List)list.getData()).stream().map(QueryEnvironmentListDTO::getMonitorMetricId).distinct().collect(Collectors.toList());
                List collect2 = ((List)list.getData()).stream().map(QueryEnvironmentListDTO::getMonitorTargetId).distinct().collect(Collectors.toList());
                map1.put("dataPointId", collect);
                map1.put("monitorMetricId", collect1);
                map1.put("monitorMetricTargetId", collect2);
            }
            String s = JSONUtils.jacksonToJson(map1);
            response.setData((Object)s);
        }
        return response;
    }

    public BaseResponse updateRule(QueryAllDataPointQuDTO query) {
        BaseResponse queryAllDataPointDTO = this.monitorMetricFacade.queryDataPointId(query);
        log.info("\u67e5\u8be2dataPointList\u7ed3\u679c\u4e3a\uff1a" + queryAllDataPointDTO);
        List dataPointList = (List)queryAllDataPointDTO.getData();
        if (DataUtils.isListAvali((List)dataPointList)) {
            Map<String, List<QueryAllDataPointDTO>> tenantIdMap = dataPointList.stream().collect(Collectors.groupingBy(QueryAllDataPointDTO::getTenantId));
            for (Map.Entry<String, List<QueryAllDataPointDTO>> tenantId : tenantIdMap.entrySet()) {
                log.info("\u79df\u6237id\u4e3a\uff1a" + tenantId.getKey());
                QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
                queryAppIdQueryDoBO.setTenantId(tenantId.getKey());
                QueryAppIdBO queryAppIdBO = this.monitorRepository.queryAppId(queryAppIdQueryDoBO);
                if (queryAppIdBO == null || StringUtils.isEmpty((CharSequence)queryAppIdBO.getAppId())) continue;
                QueryTeantNameReqDoBO queryTeantNameReqDoBO = new QueryTeantNameReqDoBO();
                ArrayList<String> id = new ArrayList<String>();
                id.add(tenantId.getKey());
                queryTeantNameReqDoBO.setTenantIds(id);
                queryTeantNameReqDoBO.setTenantId(tenantId.getKey());
                queryTeantNameReqDoBO.setLanguageCode("CN");
                log.info("userRepository\u5165\u53c2\uff1a" + queryTeantNameReqDoBO);
                List queryTeantNameResDoBOS = this.userRepository.queryTenantNames(queryTeantNameReqDoBO);
                log.info("userRepository\u51fa\u53c2\uff1a" + queryTeantNameResDoBOS);
                String ruleId = null;
                if (queryAppIdBO != null && StringUtils.isEmpty((CharSequence)queryAppIdBO.getDefaultAlarmRuleId())) {
                    AlarmRuleInsertBO insert = new AlarmRuleInsertBO();
                    insert.setAppId(queryAppIdBO.getAppId());
                    insert.setCallbackUrl(this.callbackUrl);
                    insert.setCallbackToken(this.callbackToken);
                    insert.setAlarmChannel("callback");
                    insert.setAlarmCycle(DISABLE_ALARM);
                    if (!DataUtils.isListAvali((List)queryTeantNameResDoBOS)) {
                        insert.setAlarmRuleName("sentry\u9ed8\u8ba4\u544a\u8b66\u6a21\u677f-" + tenantId.getKey());
                    } else {
                        insert.setAlarmRuleName("sentry\u9ed8\u8ba4\u544a\u8b66\u6a21\u677f-" + ((QueryTeantNameResDoBO)queryTeantNameResDoBOS.get(0)).getTenantName());
                    }
                    log.info("addAlarmRule\u5165\u53c2\uff1a" + insert);
                    ruleId = this.godzillaServerRepository.addAlarmRule(insert);
                    UpdateAppIdQuDTO updateAppIdQuDTO = new UpdateAppIdQuDTO();
                    updateAppIdQuDTO.setTenantId(tenantId.getKey());
                    updateAppIdQuDTO.setRuleId(ruleId);
                    this.monitorRepository.updateAppId(updateAppIdQuDTO);
                } else {
                    ruleId = queryAppIdBO.getDefaultAlarmRuleId();
                }
                AlarmRuleListReqBO alarmRuleListReqBO = new AlarmRuleListReqBO();
                alarmRuleListReqBO.setAppId(queryAppIdBO.getAppId());
                alarmRuleListReqBO.setPageSize(9999);
                alarmRuleListReqBO.setPageNum(1);
                PageDTO alarmRuleListRespBOPageDTO = this.godzillaServerRepository.queryAlarmRuleList(alarmRuleListReqBO);
                if (alarmRuleListRespBOPageDTO != null) {
                    List resultList = IFWBeanCopyUtil.mapAsList((Iterable)alarmRuleListRespBOPageDTO.getResult(), AlarmRuleBO.class);
                    for (AlarmRuleBO rule : resultList) {
                        if (rule.getAlarmRuleId().equals(ruleId) || StringUtils.isEmpty((CharSequence)rule.getAlarmChannel())) continue;
                        AlarmRuleInsertBO alarmRuleInsertBO = new AlarmRuleInsertBO();
                        alarmRuleInsertBO.setAlarmRuleId(rule.getAlarmRuleId());
                        alarmRuleInsertBO.setAlarmRuleName(rule.getAlarmRuleName());
                        String[] split = rule.getAlarmChannel().split(",");
                        ArrayList<String> alarmChannel = new ArrayList<String>();
                        for (String type : split) {
                            if ("callback".equals(type)) continue;
                            alarmChannel.add(type);
                        }
                        if (DataUtils.isListAvali(alarmChannel)) {
                            alarmRuleInsertBO.setAlarmChannel(String.join((CharSequence)",", alarmChannel));
                        } else {
                            alarmRuleInsertBO.setAlarmChannel(null);
                        }
                        alarmRuleInsertBO.setSmsPhoneNumbers(rule.getSmsPhoneNumbers());
                        alarmRuleInsertBO.setEmailToAddresses(rule.getEmailToAddresses());
                        alarmRuleInsertBO.setVoiceToPhoneNumber(rule.getVoiceToPhoneNumber());
                        alarmRuleInsertBO.setCallbackUrl(null);
                        alarmRuleInsertBO.setCallbackToken(null);
                        alarmRuleInsertBO.setAppId(queryAppIdBO.getAppId());
                        alarmRuleInsertBO.setValidTime(rule.getValidTime());
                        alarmRuleInsertBO.setAlarmCycle(rule.getAlarmCycle());
                        this.godzillaServerRepository.updateAlarmRule(alarmRuleInsertBO);
                    }
                }
                for (QueryAllDataPointDTO dataPointDTO : tenantId.getValue()) {
                    QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                    queryRuleAndStartBO.setDataPointId(dataPointDTO.getDataPointId());
                    QueryRuleAndStartDoBO ruleAndStart = this.godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                    if (ruleAndStart == null) continue;
                    ArrayList<String> ruleList = new ArrayList<String>();
                    if (!StringUtils.isEmpty((CharSequence)ruleAndStart.getAlarmRuleId())) {
                        String[] split;
                        for (String rule : split = ruleAndStart.getAlarmRuleId().split(",")) {
                            if (ruleId.equals(rule)) continue;
                            ruleList.add(rule);
                        }
                    }
                    ruleList.add(ruleId);
                    DatapointAndAlarmRuleBindReqBO datapointAndAlarmRuleBindReqBO = new DatapointAndAlarmRuleBindReqBO();
                    datapointAndAlarmRuleBindReqBO.setAliasEnableAlarm(ruleAndStart.getAliasEnableAlarm());
                    datapointAndAlarmRuleBindReqBO.setAlarmRuleIds(String.join((CharSequence)",", ruleList));
                    datapointAndAlarmRuleBindReqBO.setDataPointId(dataPointDTO.getDataPointId());
                    this.godzillaServerRepository.bindDatapointAndAlarmRule(datapointAndAlarmRuleBindReqBO);
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String[] split;
        String a = "sms,callback";
        for (String s : split = a.split(",")) {
            System.out.println(s);
        }
        boolean s1 = true;
    }
}

