/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.dashboard.DashboardPanelDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.DeleteDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.DeletePanelDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.InsertDashboardAndPanelDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.InsertDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.InsertDashboardPanelDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardPanelQuDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardQuDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.UpdateDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.UpdatePanelDTO;
import com.ifourthwall.dbm.asset.facade.DashboardFacade;
import com.ifourthwall.dbm.sentry.bo.dashboard.QueryDashboardDoBO;
import com.ifourthwall.dbm.sentry.bo.dashboard.QueryDashboardQuDoBO;
import com.ifourthwall.dbm.sentry.config.AssetTagConfig;
import com.ifourthwall.dbm.sentry.domain.DashboardRepository;
import com.ifourthwall.dbm.sentry.service.DashboardService;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DashboardServiceImpl")
public class DashboardServiceImpl
implements DashboardService {
    private static final Logger log = LoggerFactory.getLogger(DashboardServiceImpl.class);
    @Reference(version="1.0.0")
    private DashboardFacade dashboardFacade;
    @Autowired
    private DashboardRepository dashboardRepository;
    @Autowired
    private AssetTagConfig assetTagIn;

    public BaseResponse insertDashboard(InsertDashboardDTO inseret, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)inseret.getTenantId(), (IFWUser)user);
        inseret.setTenantId(tenantId);
        inseret.setCreateBy(user.getUserId());
        return this.dashboardFacade.insertDashboard(inseret);
    }

    public BaseResponse updateDashboard(UpdateDashboardDTO update, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)update.getTenantId(), (IFWUser)user);
        update.setTenantId(tenantId);
        update.setUpdateBy(user.getUserId());
        return this.dashboardFacade.updateDashboard(update);
    }

    public BaseResponse deleteDashboard(DeleteDashboardDTO delete, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)delete.getTenantId(), (IFWUser)user);
        delete.setTenantId(tenantId);
        return this.dashboardFacade.deleteDashboard(delete);
    }

    public BaseResponse<QueryDashboardDTO> queryDashboard(QueryDashboardQuDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
            query.setTenantId(tenantId);
            QueryDashboardDoBO dashboardList = this.dashboardRepository.queryDashboard((QueryDashboardQuDoBO)IFWBeanCopyUtil.map((Object)query, QueryDashboardQuDoBO.class));
            if (dashboardList != null) {
                response.setData(IFWBeanCopyUtil.map((Object)dashboardList, QueryDashboardDTO.class));
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse insertPanel(InsertDashboardPanelDTO inseret, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)inseret.getTenantId(), (IFWUser)user);
        inseret.setTenantId(tenantId);
        inseret.setCreateBy(user.getUserId());
        return this.dashboardFacade.insertPanel(inseret);
    }

    public BaseResponse updatePanel(UpdatePanelDTO update, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)update.getTenantId(), (IFWUser)user);
        update.setTenantId(tenantId);
        update.setUpdateBy(user.getUserId());
        return this.dashboardFacade.updatePanel(update);
    }

    public BaseResponse deletePanel(DeletePanelDTO delete, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)delete.getTenantId(), (IFWUser)user);
        delete.setTenantId(tenantId);
        return this.dashboardFacade.deletePanel(delete);
    }

    public BaseResponse noCustomInsert(InsertDashboardAndPanelDTO inseret, IFWUser user) {
        BaseResponse response = new BaseResponse();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId((String)inseret.getTenantId(), (IFWUser)user);
            inseret.setTenantId(tenantId);
            BaseResponse result = this.dashboardFacade.insertNoCustom(inseret);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        }
        catch (Throwable e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<DashboardPanelDTO>> queryDashboardPanel(QueryDashboardPanelQuDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId((String)query.getTenantId(), (IFWUser)user);
        query.setTenantId(tenantId);
        return this.dashboardFacade.queryDashboardPanel(query);
    }
}

