/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.sentry.bo.QueryUserNameQueryBO;
import com.ifourthwall.dbm.sentry.bo.UserNameDTO;
import com.ifourthwall.dbm.sentry.bo.obj.QueryTeantNameReqDoBO;
import com.ifourthwall.dbm.sentry.bo.obj.QueryTeantNameResDoBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.dbm.user.dto.QueryRealNameReqDTO;
import com.ifourthwall.dbm.user.dto.QueryRealNameResDTO;
import com.ifourthwall.dbm.user.dto.QueryTeantNameReqDTO;
import com.ifourthwall.dbm.user.dto.QueryTeantNameResDTO;
import com.ifourthwall.dbm.user.dto.ServiceWetherPurchaseReqDTO;
import com.ifourthwall.dbm.user.facade.TenantFacade;
import com.ifourthwall.dbm.user.facade.TenantPurchaseServiceFacade;
import com.ifourthwall.dbm.user.facade.UserFacade;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="UserRepository")
public class UserRepository {
    private static final Logger log = LoggerFactory.getLogger(UserRepository.class);
    @Reference(version="1.0.0")
    private UserFacade userFacade;
    @Reference(version="1.0.0")
    private TenantFacade tenantFacade;
    @Reference(version="1.0.0")
    private TenantPurchaseServiceFacade tenantPurchaseServiceFacade;

    public List<UserNameDTO> queryUserName(QueryUserNameQueryBO ids) {
        ArrayList<UserNameDTO> resultList = new ArrayList<UserNameDTO>();
        QueryRealNameReqDTO queryUser = new QueryRealNameReqDTO();
        queryUser.setUserIds(ids.getUserIds());
        queryUser.setTenantId(ids.getTenantId());
        queryUser.setLanguageCode("CN");
        log.info("\u63a5\u53e3 queryUserName ,\u63a5\u53d7\u53c2\u6570:{}", (Object)ids);
        BaseResponse response = this.userFacade.queryRealNameByUserIds(queryUser);
        log.info("\u63a5\u53e3 queryUserName ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali((List)((List)response.getData()))) {
            for (QueryRealNameResDTO userInfo : (List)response.getData()) {
                UserNameDTO resultDTO = new UserNameDTO();
                resultDTO.setUserId(userInfo.getUserId());
                resultDTO.setUserName(userInfo.getRealName());
                resultList.add(resultDTO);
            }
        }
        return resultList;
    }

    public boolean queryTenantWhetherPurchaseService(ServiceWetherPurchaseReqDTO ids) {
        log.info("\u63a5\u53e3 queryUserName ,\u63a5\u53d7\u53c2\u6570:{}", (Object)ids);
        BaseResponse response = this.tenantPurchaseServiceFacade.queryTenantWhetherPurchaseService(ids);
        log.info("\u63a5\u53e3 queryUserName ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        return response.getData() != null;
    }

    public List<QueryTeantNameResDoBO> queryTenantNames(QueryTeantNameReqDoBO queryTeantName) {
        ArrayList<QueryTeantNameResDoBO> resultList = new ArrayList<QueryTeantNameResDoBO>();
        log.info("\u63a5\u53e3 queryTenantNames ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryTeantName);
        BaseResponse response = this.tenantFacade.queryTenantNames((QueryTeantNameReqDTO)IFWBeanCopyUtil.map((Object)queryTeantName, QueryTeantNameReqDTO.class));
        log.info("\u63a5\u53e3 queryTenantNames ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali((List)((List)response.getData()))) {
            for (QueryTeantNameResDTO tenantInfo : (List)response.getData()) {
                QueryTeantNameResDoBO resultDTO = new QueryTeantNameResDoBO();
                resultDTO.setTenantId(tenantInfo.getTenantId());
                resultDTO.setTenantName(tenantInfo.getTenantName());
                resultList.add(resultDTO);
            }
            return resultList;
        }
        return null;
    }
}

