/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.project.dto.GetNewPathBatchQueryDTO;
import com.ifourthwall.dbm.project.dto.GetSonSpaceQueryDTO;
import com.ifourthwall.dbm.project.dto.ProjectSpaceBaseDTO;
import com.ifourthwall.dbm.project.dto.ProjectSpaceSubListQueryDTO;
import com.ifourthwall.dbm.project.dto.QueryNextSonListQuDTO;
import com.ifourthwall.dbm.project.dto.QuerySpaceIdsDTO;
import com.ifourthwall.dbm.project.dto.QuerySpaceInfoQueryDTO;
import com.ifourthwall.dbm.project.dto.space.QuerySpaceListByNameDTO;
import com.ifourthwall.dbm.project.dto.space.QuerySpaceListByNameQuDTO;
import com.ifourthwall.dbm.project.facade.ProjectSpaceFacade;
import com.ifourthwall.dbm.project.facade.ProjectSpaceTwoFacade;
import com.ifourthwall.dbm.sentry.bo.GetNewPathBatchQueryBO;
import com.ifourthwall.dbm.sentry.bo.GetSonSpaceBO;
import com.ifourthwall.dbm.sentry.bo.GetSonSpaceQueryBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpaceBaseDoBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpacePathBO;
import com.ifourthwall.dbm.sentry.bo.ProjectSpaceSubListQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryNextSonListDoBO;
import com.ifourthwall.dbm.sentry.bo.QueryNextSonListQuDoBO;
import com.ifourthwall.dbm.sentry.bo.QuerySpaceIdsQueryBO;
import com.ifourthwall.dbm.sentry.bo.QuerySpaceInfoQueryDoBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="SpaceRepository")
public class SpaceRepository {
    private static final Logger log = LoggerFactory.getLogger(SpaceRepository.class);
    @Reference(version="1.0.0")
    private ProjectSpaceFacade projectSpaceFacade;
    @Reference(version="1.0.0")
    private ProjectSpaceTwoFacade projectSpaceTwoFacade;

    public GetSonSpaceBO getSonpace(GetSonSpaceQueryBO sonSpace) {
        GetSonSpaceBO result = new GetSonSpaceBO();
        log.info("\u63a5\u53e3 getSonpace ,\u63a5\u53d7\u53c2\u6570:{}", (Object)sonSpace);
        BaseResponse sonpace = this.projectSpaceFacade.getSonpace((GetSonSpaceQueryDTO)IFWBeanCopyUtil.map((Object)sonSpace, GetSonSpaceQueryDTO.class));
        log.info("\u63a5\u53e3 getSonpace ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)sonpace);
        if (!sonpace.isFlag()) {
            throw new BizException(sonpace.getRetMsg(), sonpace.getRetCode());
        }
        if (sonpace.getData() != null) {
            return (GetSonSpaceBO)IFWBeanCopyUtil.map((Object)sonpace.getData(), GetSonSpaceBO.class);
        }
        return result;
    }

    public GetSonSpaceBO querySpaceIds(QuerySpaceIdsQueryBO spaceIds) {
        GetSonSpaceBO result = new GetSonSpaceBO();
        QuerySpaceIdsDTO query = new QuerySpaceIdsDTO();
        query.setProjectId(spaceIds.getProjectId());
        log.info("\u63a5\u53e3 querySpaceIds ,\u63a5\u53d7\u53c2\u6570:{}", (Object)spaceIds);
        BaseResponse response = this.projectSpaceFacade.querySpaceIds(query);
        log.info("\u63a5\u53e3 querySpaceIds ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali((List)((List)response.getData()))) {
            ArrayList<String> strings = new ArrayList<String>();
            for (ProjectSpaceBaseDTO datum : (List)response.getData()) {
                strings.add(datum.getProjectSpaceId());
            }
            result.setSpaceId(strings);
            return result;
        }
        return result;
    }

    public List<ProjectSpacePathBO> getNewPathBatch(GetNewPathBatchQueryBO newPathBatchQuery) {
        log.info("\u63a5\u53e3 getNewPathBatch ,\u63a5\u53d7\u53c2\u6570:{}", (Object)newPathBatchQuery);
        BaseResponse newPathBatch = this.projectSpaceFacade.getNewPathBatch((GetNewPathBatchQueryDTO)IFWBeanCopyUtil.map((Object)newPathBatchQuery, GetNewPathBatchQueryDTO.class));
        log.info("\u63a5\u53e3 getNewPathBatch ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)newPathBatchQuery);
        if (!newPathBatch.isFlag()) {
            throw new BizException(newPathBatch.getRetMsg(), newPathBatch.getRetCode());
        }
        if (DataUtils.isListAvali((List)((List)newPathBatch.getData()))) {
            List projectSpacePathBOS = IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)newPathBatch.getData()), ProjectSpacePathBO.class);
            return projectSpacePathBOS;
        }
        return new ArrayList<ProjectSpacePathBO>();
    }

    public ProjectSpaceBaseDoBO querySpaceInfo(QuerySpaceInfoQueryDoBO newPathBatchQuery) {
        log.info("\u63a5\u53e3 querySpaceInfo ,\u63a5\u53d7\u53c2\u6570:{}", (Object)newPathBatchQuery);
        BaseResponse response = this.projectSpaceFacade.querySpaceInfo((QuerySpaceInfoQueryDTO)IFWBeanCopyUtil.map((Object)newPathBatchQuery, QuerySpaceInfoQueryDTO.class));
        log.info("\u63a5\u53e3 querySpaceInfo ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return (ProjectSpaceBaseDoBO)IFWBeanCopyUtil.map((Object)response.getData(), ProjectSpaceBaseDoBO.class);
        }
        return null;
    }

    public QueryNextSonListDoBO queryNextSonList(QueryNextSonListQuDoBO newPathBatchQuery) {
        log.info("\u63a5\u53e3 querySpaceInfo ,\u63a5\u53d7\u53c2\u6570:{}", (Object)newPathBatchQuery);
        BaseResponse response = this.projectSpaceFacade.queryNextSonList((QueryNextSonListQuDTO)IFWBeanCopyUtil.map((Object)newPathBatchQuery, QueryNextSonListQuDTO.class));
        log.info("\u63a5\u53e3 querySpaceInfo ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)newPathBatchQuery);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return (QueryNextSonListDoBO)IFWBeanCopyUtil.map((Object)response.getData(), QueryNextSonListDoBO.class);
        }
        return null;
    }

    public List<ProjectSpaceBaseDoBO> getSonSpaceList(ProjectSpaceSubListQueryDoBO newPathBatchQuery) {
        log.info("\u63a5\u53e3 querySpaceInfo ,\u63a5\u53d7\u53c2\u6570:{}", (Object)newPathBatchQuery);
        BaseResponse response = this.projectSpaceFacade.getSonSpaceList((ProjectSpaceSubListQueryDTO)IFWBeanCopyUtil.map((Object)newPathBatchQuery, ProjectSpaceSubListQueryDTO.class));
        log.info("\u63a5\u53e3 querySpaceInfo ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)newPathBatchQuery);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), ProjectSpaceBaseDoBO.class);
        }
        return null;
    }

    public List<QuerySpaceListByNameDTO> querySpaceListByName(QuerySpaceListByNameQuDTO query) {
        log.info("\u63a5\u53e3 querySpaceListByName ,\u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.projectSpaceTwoFacade.querySpaceListByName(query);
        log.info("\u63a5\u53e3 querySpaceListByName ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)query);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return (List)response.getData();
        }
        return null;
    }
}

