/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.asset.dto.AlertRulesDTO;
import com.ifourthwall.dbm.asset.dto.PageDTO;
import com.ifourthwall.dbm.asset.dto.UpInGodzillaMonitor;
import com.ifourthwall.dbm.sentry.bo.AddMaxAndMinBO;
import com.ifourthwall.dbm.sentry.bo.DeleteAlarmRuleBO;
import com.ifourthwall.dbm.sentry.bo.DeleteMaxAndMinBO;
import com.ifourthwall.dbm.sentry.bo.GodzillaInfoBO;
import com.ifourthwall.dbm.sentry.bo.GodzillaInfoTwoBO;
import com.ifourthwall.dbm.sentry.bo.QueryAlarmRuleDetailBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.bo.TransferNumberDoBO;
import com.ifourthwall.dbm.sentry.bo.TransferNumberQuDoBO;
import com.ifourthwall.dbm.sentry.bo.UpdateMaxAndMinBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleInsertBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleListReqBO;
import com.ifourthwall.dbm.sentry.bo.alarm.AlarmRuleListRespBO;
import com.ifourthwall.dbm.sentry.bo.alarm.DatapointAndAlarmRuleBindReqBO;
import com.ifourthwall.dbm.sentry.bo.app.AppReqBO;
import com.ifourthwall.dbm.sentry.bo.app.AppRespBO;
import com.ifourthwall.dbm.sentry.bo.godzilla.QueryRuleBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GodzillaServerRepository {
    private static final Logger log = LoggerFactory.getLogger(GodzillaServerRepository.class);
    @Value(value="${godzilla.token}")
    private String godzillaToken;
    @Value(value="${query.alarm.rule.list}")
    private String queryAlarmRuleList;
    @Value(value="${add.alarm.rule}")
    private String addAlarmRule;
    @Value(value="${update.alarm.rule.list}")
    private String updateAlarmRule;
    @Value(value="${query.alarm.rule.detail}")
    private String queryAlarmRuleDetail;
    @Value(value="${delete.alarm.rule}")
    private String deleteAlarmRule;
    @Value(value="${query.datapoint.max.and.min}")
    private String queryMaxAndMin;
    @Value(value="${datapoint.rule.update}")
    private String updateRuleDataPoint;
    @Value(value="${datapoint.rule.delete}")
    private String deleteRuleDataPoint;
    @Value(value="${query.metric.value.record.list}")
    private String queryMetricValueRecordList;
    @Value(value="${create.app}")
    private String createApp;
    @Value(value="${update.data.point.name}")
    private String updateDataPointName;
    @Value(value="${update.max.and.min}")
    private String insertMaxAndMin;
    @Value(value="${bind.datapoint.and.alarm.rule}")
    private String bindDatapointAndAlarmRule;
    @Value(value="${query.rule.and.start}")
    private String queryRuleAndStart;
    @Value(value="${transfer.number}")
    private String transferNumber;
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.SECONDS).build();

    public Request synPost(String url, String json, String token) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new RuntimeException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            builder.header("Authorization", token);
        }
        builder.method("POST", body);
        Request request = builder.build();
        return request;
    }

    private Map<String, Object> synSend(String url, String json, String token) {
        Request request = this.synPost(url, json, token);
        log.info("\u5373\u5c06\u53d1\u9001URL:{}", (Object)url);
        Response response = null;
        try {
            response = client.newCall(request).execute();
            String content = response.body().string();
            log.info("\u53d1\u9001URL:{}\u6210\u529f,\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)url, (Object)content);
            Map result = (Map)JSONUtils.jacksonFromJson((String)content, HashMap.class);
            return result;
        }
        catch (IOException e) {
            log.error("\u53d1\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void handleFailedResult(Map<String, Object> result, String errorMsg, String errorCode) {
        if (!((Boolean)result.get("flag")).booleanValue()) {
            log.warn("\u8c03\u7528godzilla\u63a5\u53e3\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{},\u9519\u8bef\u7f16\u7801:{}", result.get("msg"), result.get("code"));
            throw new BizException(errorMsg, errorCode);
        }
    }

    public PageDTO<AlarmRuleListRespBO> queryAlarmRuleList(AlarmRuleListReqBO alarmRuleListReqBO) {
        Map data;
        PageDTO resultPage = new PageDTO();
        log.info("\u544a\u8b66\u89c4\u5219\u8be6\u60c5\u544a\u8b66\u89c4\u5219\u5217\u8868\u67e5\u8be2\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)alarmRuleListReqBO);
        String sentInfo = JSONUtils.jacksonToJson((Object)alarmRuleListReqBO);
        log.info("json:" + sentInfo);
        Map result = this.synSend(this.queryAlarmRuleList, sentInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.QUERY_OF_ALARM_RULE_LIST_FAILED.getDesc(), PlatformCodeEnum.QUERY_OF_ALARM_RULE_LIST_FAILED.getCode());
        if (result.get("data") != null && (data = (Map)result.get("data")).get("alarmRuleList") != null) {
            List alarmRuleList = (List)data.get("alarmRuleList");
            Integer pageNum = (Integer)data.get("pageNum");
            Integer pageSize = (Integer)data.get("pageSize");
            Integer total = (Integer)data.get("total");
            resultPage.setResult(alarmRuleList);
            resultPage.setPageNum(pageNum.intValue());
            resultPage.setPageSize(pageSize.intValue());
            resultPage.setTotal((long)total.intValue());
            return resultPage;
        }
        return null;
    }

    public String addAlarmRule(AlarmRuleInsertBO alarmRuleBO) {
        String releId;
        log.info("\u589e\u52a0\u544a\u8b66\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)alarmRuleBO);
        String sendInfo = JSONUtils.jacksonToJson((Object)alarmRuleBO);
        log.info("json:" + sendInfo);
        Map result = this.synSend(this.addAlarmRule, sendInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.INSERT_FAILURE.getDesc(), PlatformCodeEnum.INSERT_FAILURE.getCode());
        Map data = (Map)result.get("data");
        if (data != null && !StringUtils.isEmpty((CharSequence)(releId = (String)data.get("alarmRuleId")))) {
            return releId;
        }
        return null;
    }

    public void updateAlarmRule(AlarmRuleInsertBO alarmRuleBO) {
        log.info("\u7f16\u8f91\u544a\u8b66\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)alarmRuleBO);
        String sentInfo = JSONUtils.jacksonToJson((Object)alarmRuleBO);
        log.info("json:" + sentInfo);
        Map result = this.synSend(this.updateAlarmRule, sentInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.UPDATE_FAILURE.getDesc(), PlatformCodeEnum.UPDATE_FAILURE.getCode());
    }

    public AlarmRuleBO queryAlarmRuleDetail(QueryAlarmRuleDetailBO alarmRuleId) {
        AlarmRuleBO resultDTO = new AlarmRuleBO();
        log.info("\u544a\u8b66\u89c4\u5219\u8be6\u60c5\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)alarmRuleId);
        String sentInfo = JSONUtils.jacksonToJson((Object)alarmRuleId);
        log.info("json:" + sentInfo);
        Map result = this.synSend(this.queryAlarmRuleDetail, sentInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.FAILED_TO_VIEW_ALARM_RULE_DETAILS.getDesc(), PlatformCodeEnum.FAILED_TO_VIEW_ALARM_RULE_DETAILS.getCode());
        Map data = (Map)result.get("data");
        if (data != null) {
            resultDTO.setAlarmRuleId((String)data.get("alarmRuleId"));
            resultDTO.setAlarmRuleName((String)data.get("alarmRuleName"));
            resultDTO.setAlarmChannel((String)data.get("alarmChannel"));
            resultDTO.setSmsPhoneNumbers((String)data.get("smsPhoneNumbers"));
            resultDTO.setEmailToAddresses((String)data.get("emailToAddresses"));
            resultDTO.setVoiceToPhoneNumber((String)data.get("voiceToPhoneNumber"));
            resultDTO.setCallbackUrl((String)data.get("callbackUrl"));
            resultDTO.setCallbackToken((String)data.get("callbackToken"));
            resultDTO.setAppId((String)data.get("appId"));
            resultDTO.setValidTime((String)data.get("validTime"));
            resultDTO.setAlarmCycle((String)data.get("alarmCycle"));
            return resultDTO;
        }
        return null;
    }

    public void deleteAlarmRule(String alarmRuleId) {
        DeleteAlarmRuleBO deleteAlarmRuleBO = new DeleteAlarmRuleBO();
        log.info("\u5220\u9664\u544a\u8b66\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)alarmRuleId);
        deleteAlarmRuleBO.setAlarmRuleId(alarmRuleId);
        String sentInfo = JSONUtils.jacksonToJson((Object)deleteAlarmRuleBO);
        Map result = this.synSend(this.deleteAlarmRule, sentInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.DELETE_FAILURE.getDesc(), PlatformCodeEnum.DELETE_FAILURE.getCode());
    }

    public MetricValueRecordListBO queryMetricValueRecordList(MetricValueRecordListReqBO metricValueRecordListReq) {
        MetricValueRecordListBO resultList = new MetricValueRecordListBO();
        log.info("\u68c0\u6d4b\u6307\u6807\u6570\u636e\u8bb0\u5f55\u67e5\u8be2\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)metricValueRecordListReq);
        String sentInfo = JSONUtils.jacksonToJson((Object)metricValueRecordListReq);
        log.info("json:" + sentInfo);
        Map result = this.synSend(this.queryMetricValueRecordList, sentInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.QUERY_OF_TEST_INDICATOR_DATA_RECORD_FAILED.getDesc(), PlatformCodeEnum.QUERY_OF_TEST_INDICATOR_DATA_RECORD_FAILED.getCode());
        if (result.get("data") != null) {
            Map data = (Map)result.get("data");
            List collectDataList = (List)data.get("collectDataList");
            List alarmRecordList = (List)data.get("alarmRecordList");
            if (DataUtils.isListAvali((List)collectDataList)) {
                ArrayList<GodzillaInfoBO> resultList1 = new ArrayList<GodzillaInfoBO>();
                for (Map resultInfo : collectDataList) {
                    GodzillaInfoBO resultDTO = new GodzillaInfoBO();
                    resultDTO.setDataPointId((String)resultInfo.get("dataPointId"));
                    resultDTO.setTime((String)resultInfo.get("time"));
                    resultDTO.setValue((String)resultInfo.get("dataValue"));
                    resultDTO.setAlarmMax((String)resultInfo.get("alarm_max"));
                    resultDTO.setAlarmMin((String)resultInfo.get("alarm_min"));
                    resultDTO.setEnableAlarm((String)resultInfo.get("enable_alarm"));
                    resultDTO.setUserName((String)resultInfo.get("userName"));
                    resultDTO.setRemark((String)resultInfo.get("remark"));
                    resultList1.add(resultDTO);
                }
                resultList.setCollectDataList(resultList1);
            }
            if (DataUtils.isListAvali((List)alarmRecordList)) {
                ArrayList<GodzillaInfoTwoBO> resultList2 = new ArrayList<GodzillaInfoTwoBO>();
                for (Map resultInfo : alarmRecordList) {
                    GodzillaInfoTwoBO godzillaInfoTwoBO = new GodzillaInfoTwoBO();
                    godzillaInfoTwoBO.setDataPointId((String)resultInfo.get("dataPointId"));
                    godzillaInfoTwoBO.setTime((String)resultInfo.get("time"));
                    godzillaInfoTwoBO.setValue((String)resultInfo.get("value"));
                    godzillaInfoTwoBO.setMessage((String)resultInfo.get("message"));
                    godzillaInfoTwoBO.setDataPointStatus((String)resultInfo.get("dataPointStatus"));
                    resultList2.add(godzillaInfoTwoBO);
                }
                resultList.setAlarmRecordList(resultList2);
            }
            return resultList;
        }
        return null;
    }

    public AppRespBO createApp(AppReqBO appReqBO) {
        AppRespBO resultDTO = new AppRespBO();
        log.info("\u521b\u5efaapp\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)appReqBO);
        String sentInfo = JSONUtils.jacksonToJson((Object)appReqBO);
        Map result = this.synSend(this.createApp, sentInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.GODZILLA_FAILED_TO_GET_APPID.getDesc(), PlatformCodeEnum.GODZILLA_FAILED_TO_GET_APPID.getCode());
        if (result.get("data") != null) {
            Map data = (Map)result.get("data");
            String appid = (String)data.get("appId");
            resultDTO.setAppId(appid);
            return resultDTO;
        }
        return null;
    }

    public void updateDataPointName(UpInGodzillaMonitor upInGodzillaMonitor) {
        String sendInfo = JSONUtils.jacksonToJson((Object)upInGodzillaMonitor);
        log.info("\u8bbe\u7f6edatapoint\u540d\u79f0\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)upInGodzillaMonitor);
        Map result = this.synSend(this.updateDataPointName, sendInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }

    public void addMaxAndMin(AddMaxAndMinBO updateMaxAndMinBO) {
        String sendInfo = JSONUtils.jacksonToJson((Object)updateMaxAndMinBO);
        log.info("\u8bbe\u7f6e\u6700\u5927\u503c\u6700\u5c0f\u503c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)updateMaxAndMinBO);
        Map result = this.synSend(this.insertMaxAndMin, sendInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }

    public void deleteMaxAndMin(DeleteMaxAndMinBO delete) {
        String sendInfo = JSONUtils.jacksonToJson((Object)delete);
        log.info("\u8bbe\u7f6e\u6700\u5927\u503c\u6700\u5c0f\u503c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)delete);
        Map result = this.synSend(this.deleteRuleDataPoint, sendInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }

    public void updateMaxAndMin(UpdateMaxAndMinBO updateMaxAndMinBO) {
        String sendInfo = JSONUtils.jacksonToJson((Object)updateMaxAndMinBO);
        log.info("\u8bbe\u7f6e\u6700\u5927\u503c\u6700\u5c0f\u503c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)updateMaxAndMinBO);
        Map result = this.synSend(this.updateRuleDataPoint, sendInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }

    public List<QueryRuleBO> queryRule(QueryRuleAndStartBO queryRuleAndStartBO) {
        List dataOne;
        String sendInfo = JSONUtils.jacksonToJson((Object)queryRuleAndStartBO);
        log.info("\u8bbe\u7f6e\u6700\u5927\u503c\u6700\u5c0f\u503c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)queryRuleAndStartBO);
        Map resultOne = this.synSend(this.queryMaxAndMin, sendInfo, this.godzillaToken);
        if (resultOne.get("data") != null && DataUtils.isListAvali((List)(dataOne = (List)resultOne.get("data")))) {
            ArrayList<QueryRuleBO> alertList = new ArrayList<QueryRuleBO>();
            for (Map objectObjectMap : dataOne) {
                QueryRuleBO alertRulesDTO = new QueryRuleBO();
                String alarmMaximumValue = (String)objectObjectMap.get("alarmMaximumValue");
                String alarmMinimumValue = (String)objectObjectMap.get("alarmMinimumValue");
                Integer compareDuration = (Integer)objectObjectMap.get("compareDuration");
                String compareTarget = (String)objectObjectMap.get("compareTarget");
                String dataPointAlarmTriggerRuleId = (String)objectObjectMap.get("dataPointAlarmTriggerRuleId");
                alertRulesDTO.setAlarmMaximumValue(alarmMaximumValue);
                alertRulesDTO.setAlarmMinimumValue(alarmMinimumValue);
                alertRulesDTO.setCompareDuration(compareDuration);
                alertRulesDTO.setCompareTarget(compareTarget);
                alertRulesDTO.setDataPointAlarmTriggerRuleId(dataPointAlarmTriggerRuleId);
                alertList.add(alertRulesDTO);
            }
            return alertList;
        }
        return null;
    }

    public void bindDatapointAndAlarmRule(DatapointAndAlarmRuleBindReqBO datapointAndAlarmRuleBindReqBO) {
        log.info("\u4fee\u6539\u544a\u8b66\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)datapointAndAlarmRuleBindReqBO);
        String sendInfo = JSONUtils.jacksonToJson((Object)datapointAndAlarmRuleBindReqBO);
        System.out.println("json:" + sendInfo);
        Map result = this.synSend(this.bindDatapointAndAlarmRule, sendInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }

    public QueryRuleAndStartDoBO queryRuleAndStart(QueryRuleAndStartBO queryRuleAndStartBO) {
        QueryRuleAndStartDoBO resultDTO = new QueryRuleAndStartDoBO();
        log.info("\u6839\u636edataPoint\u67e5\u8be2\u54e5\u65af\u62c9\u76f8\u5173\u6570\u636e\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)queryRuleAndStartBO);
        String sendInfo = JSONUtils.jacksonToJson((Object)queryRuleAndStartBO);
        System.out.println("json:" + sendInfo);
        Map result = this.synSend(this.queryRuleAndStart, sendInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.FAILED_TO_QUERY_GODZILLA_RELATED_DATA_ACCORDING_TO_DATAPOINT.getDesc(), PlatformCodeEnum.FAILED_TO_QUERY_GODZILLA_RELATED_DATA_ACCORDING_TO_DATAPOINT.getCode());
        if (result.get("data") != null) {
            List dataOne;
            Map data = (Map)result.get("data");
            String alarmRuleName = (String)data.get("alarmRuleNames");
            String alarmRuleId = (String)data.get("alarmRuleIds");
            String aliasEnableAlarm = (String)data.get("aliasEnableAlarm");
            String currentValue = (String)data.get("currentValue");
            if (!StringUtils.isEmpty((CharSequence)currentValue)) {
                String currentValueLast = Double.valueOf(currentValue) + "";
                resultDTO.setCurrentValue(currentValueLast);
            }
            String unit = (String)data.get("unit");
            resultDTO.setAlarmRuleName(alarmRuleName);
            resultDTO.setAlarmRuleId(alarmRuleId);
            resultDTO.setAliasEnableAlarm(aliasEnableAlarm);
            resultDTO.setUnit(unit);
            Map resultOne = this.synSend(this.queryMaxAndMin, sendInfo, this.godzillaToken);
            if (resultOne.get("data") != null && DataUtils.isListAvali((List)(dataOne = (List)resultOne.get("data")))) {
                ArrayList<AlertRulesDTO> alertList = new ArrayList<AlertRulesDTO>();
                for (Map objectObjectMap : dataOne) {
                    AlertRulesDTO alertRulesDTO = new AlertRulesDTO();
                    Map query = (Map)dataOne.get(0);
                    String alarmMaximumValue = (String)query.get("alarmMaximumValue");
                    String alarmMinimumValue = (String)query.get("alarmMinimumValue");
                    Integer compareDuration = (Integer)query.get("compareDuration");
                    String compareTarget = (String)query.get("compareTarget");
                    alertRulesDTO.setAlarmMaximumValue(alarmMaximumValue);
                    alertRulesDTO.setAlarmMinimumValue(alarmMinimumValue);
                    alertRulesDTO.setCompareDuration(compareDuration);
                    alertRulesDTO.setCompareTarget(compareTarget);
                    alertList.add(alertRulesDTO);
                }
                resultDTO.setAlarmInfo(alertList);
                return resultDTO;
            }
            return resultDTO;
        }
        return null;
    }

    public TransferNumberDoBO transferNumber(TransferNumberQuDoBO appId) {
        TransferNumberDoBO resultDTO = new TransferNumberDoBO();
        log.info("\u67e5\u8be2\u8c03\u7528\u6b21\u6570\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)appId);
        String sendInfo = JSONUtils.jacksonToJson((Object)appId);
        System.out.println("json:" + sendInfo);
        Map result = this.synSend(this.transferNumber, sendInfo, this.godzillaToken);
        this.handleFailedResult(result, PlatformCodeEnum.QUERY_CALLS_FAILED.getDesc(), PlatformCodeEnum.QUERY_CALLS_FAILED.getCode());
        if (result.get("data") != null) {
            Map data = (Map)result.get("data");
            Integer apiInvocationMaxCountPerDay = (Integer)data.get("apiInvocationMaxCountPerDay");
            Integer apiInvocationCurrentCountPerDay = (Integer)data.get("apiInvocationCurrentCountPerDay");
            Integer notificationCallbackMaxCount = (Integer)data.get("notificationCallbackMaxCount");
            Integer notificationCallbackCurrentCount = (Integer)data.get("notificationCallbackCurrentCount");
            Integer notificationEmailMaxCount = (Integer)data.get("notificationEmailMaxCount");
            Integer notificationEmailCurrentCount = (Integer)data.get("notificationEmailCurrentCount");
            Integer notificationSmsMaxCount = (Integer)data.get("notificationSmsMaxCount");
            Integer notificationSmsCurrentCount = (Integer)data.get("notificationSmsCurrentCount");
            Integer notificationVoiceMaxCount = (Integer)data.get("notificationVoiceMaxCount");
            Integer notificationVoiceCurrentCount = (Integer)data.get("notificationVoiceCurrentCount");
            if (apiInvocationMaxCountPerDay == null) {
                resultDTO.setApiNumber(Integer.valueOf(0));
            } else {
                resultDTO.setApiNumber(apiInvocationMaxCountPerDay);
            }
            if (apiInvocationCurrentCountPerDay == null) {
                resultDTO.setApiUseNumber(Integer.valueOf(0));
            } else {
                resultDTO.setApiUseNumber(apiInvocationCurrentCountPerDay);
            }
            if (notificationCallbackMaxCount == null) {
                resultDTO.setCallbackNumber(Integer.valueOf(0));
            } else {
                resultDTO.setCallbackNumber(notificationCallbackMaxCount);
            }
            if (notificationCallbackCurrentCount == null) {
                resultDTO.setCallbackUseNumber(Integer.valueOf(0));
            } else {
                resultDTO.setCallbackUseNumber(notificationCallbackCurrentCount);
            }
            if (notificationEmailMaxCount == null) {
                resultDTO.setEmailNumber(Integer.valueOf(0));
            } else {
                resultDTO.setEmailNumber(notificationEmailMaxCount);
            }
            if (notificationEmailCurrentCount == null) {
                resultDTO.setEmailUseNumber(Integer.valueOf(0));
            } else {
                resultDTO.setEmailUseNumber(notificationEmailCurrentCount);
            }
            if (notificationSmsMaxCount == null) {
                resultDTO.setSmsNumber(Integer.valueOf(0));
            } else {
                resultDTO.setSmsNumber(notificationSmsMaxCount);
            }
            if (notificationSmsCurrentCount == null) {
                resultDTO.setSmsUseNumber(Integer.valueOf(0));
            } else {
                resultDTO.setSmsUseNumber(notificationSmsCurrentCount);
            }
            if (notificationVoiceMaxCount == null) {
                resultDTO.setVoiceNumber(Integer.valueOf(0));
            } else {
                resultDTO.setVoiceNumber(notificationVoiceMaxCount);
            }
            if (notificationVoiceCurrentCount == null) {
                resultDTO.setVoiceUseNumber(Integer.valueOf(0));
            } else {
                resultDTO.setVoiceUseNumber(notificationVoiceCurrentCount);
            }
        } else {
            resultDTO.setApiNumber(Integer.valueOf(0));
            resultDTO.setApiUseNumber(Integer.valueOf(0));
            resultDTO.setCallbackNumber(Integer.valueOf(0));
            resultDTO.setCallbackUseNumber(Integer.valueOf(0));
            resultDTO.setEmailNumber(Integer.valueOf(0));
            resultDTO.setEmailUseNumber(Integer.valueOf(0));
            resultDTO.setSmsNumber(Integer.valueOf(0));
            resultDTO.setSmsUseNumber(Integer.valueOf(0));
            resultDTO.setVoiceNumber(Integer.valueOf(0));
            resultDTO.setVoiceUseNumber(Integer.valueOf(0));
        }
        return resultDTO;
    }
}

