/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.QueryIndexRankingDTO;
import com.ifourthwall.dbm.asset.dto.QueryIndexRankingQuDTO;
import com.ifourthwall.dbm.asset.dto.SeerQueryTagDTO;
import com.ifourthwall.dbm.asset.dto.SeerQueryTagQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.EnvironmentListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentBasisQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionListQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.SeerTagMoveDTO;
import com.ifourthwall.dbm.asset.dto.seer.SqDepositSenrtyInfoDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoQuDTO;
import com.ifourthwall.dbm.sentry.service.SeerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Seer\u76f8\u5173\u63a5\u53e3"}, value="SeerController")
@RequestMapping(value={"/dbm/sentry/seer"})
public class SeerController {
    private static final Logger log = LoggerFactory.getLogger(SeerController.class);
    @Resource(name="SeerServiceImpl")
    private SeerService seerService;

    @ApiOperation(value="seer\u7a7a\u95f4\u6807\u7b7e", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/tag"})
    public ResponseEntity<BaseResponse<List<SeerQueryTagDTO>>> seerQueryTag(@Valid @RequestBody SeerQueryTagQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 seerQueryTag \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.seerQueryTag(query, user);
        log.info("\u63a5\u53e3 seerQueryTag \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636e\u6807\u7b7e\u67e5\u8be2\u6392\u884c", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/index/rank"})
    public ResponseEntity<BaseResponse<List<QueryIndexRankingDTO>>> queryIndexRanking(@Valid @RequestBody QueryIndexRankingQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryIndexRanking \u63a5\u53d7\u53c2\u6570:{}");
        BaseResponse response = this.seerService.queryIndexRanking(query, user);
        log.info("\u63a5\u53e3 queryIndexRanking \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u73af\u5883\u7edf\u8ba1", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/environment"})
    public ResponseEntity<BaseResponse<QueryEnvironmentDTO>> queryEnvironment(@Valid @RequestBody QueryEnvironmentBasisQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryEnvironment \u63a5\u53d7\u53c2\u6570:{}");
        BaseResponse response = this.seerService.queryEnvironment(query, user);
        log.info("\u63a5\u53e3 queryEnvironment \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u73af\u5883\u7edf\u8ba1\u5217\u8868", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/environment/list"})
    public ResponseEntity<BaseResponse<List<EnvironmentListDTO>>> queryEnvironmentList(@Valid @RequestBody QueryEnvironmentListQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryEnvironmentList \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.queryEnvironmentList(query, user);
        log.info("\u63a5\u53e3 queryEnvironmentList \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u95e8\u78c1-\u7a7a\u95f4\u5b89\u5168\u76d1\u6d4b", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/induction/info"})
    public ResponseEntity<BaseResponse<QueryInductionDTO>> queryInduction(@Valid @RequestBody QueryInductionQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryInduction \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.queryInduction(query, user);
        log.info("\u63a5\u53e3 queryInduction \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u95e8\u78c1-\u7a7a\u95f4\u5217\u8868", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/induction/list"})
    public ResponseEntity<BaseResponse<List<QueryInductionListDTO>>> queryInductionList(@Valid @RequestBody QueryInductionListQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryInductionList \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.queryInductionList(query, user);
        log.info("\u63a5\u53e3 queryInductionList \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u80fd\u8017-\u80fd\u8017\u7edf\u8ba1", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/energy/statistics"})
    public ResponseEntity<BaseResponse<QueryEnergyStatisticsDTO>> queryEnergyStatistics(@Valid @RequestBody QueryEnergyStatisticsQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryEnergyStatistics \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.queryEnergyStatistics(query, user);
        log.info("\u63a5\u53e3 queryEnergyStatistics \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u80fd\u8017-\u80fd\u8017\u5bf9\u6bd4\u66f2\u7ebf", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/energy/compared/graph"})
    public ResponseEntity<BaseResponse<QueryEnergyComparedGraphDTO>> queryEnergyComparedGraph(@Valid @RequestBody QueryEnergyComparedGraphQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryEnergyComparedGraph \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.queryEnergyComparedGraph(query, user);
        log.info("\u63a5\u53e3 queryEnergyComparedGraph \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u4e0a\u6c7d-\u73af\u5883\u7edf\u8ba1", notes="\u6768\u9e4f")
    @PostMapping(value={"/sq/query/environment/info"})
    public ResponseEntity<BaseResponse<List<QuerySqEnvironmentInfoDTO>>> querySqEnvironmentInfo(@Valid @RequestBody QuerySqEnvironmentInfoQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 querySqEnvironmentInfo \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.querySqEnvironmentInfo(query, user);
        log.info("\u63a5\u53e3 querySqEnvironmentInfo \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u7edf\u8ba1\u63a5\u53e3", notes="\u6768\u9e4f")
    @PostMapping(value={"/sq/query/environment/line/chart"})
    public ResponseEntity<BaseResponse> sqDepositSenrtyInfo(@Valid @RequestBody SqDepositSenrtyInfoDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 sqDepositSenrtyInfo \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.sqDepositSenrtyInfo(query, user);
        log.info("\u63a5\u53e3 sqDepositSenrtyInfo \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5916\u90e8\u6807\u7b7e\u6570\u636e\u8fc1\u79fb", notes="\u6768\u9e4f")
    @PostMapping(value={"/seer/tag/move"})
    public ResponseEntity<BaseResponse> seerTagMove(@Valid @RequestBody SeerTagMoveDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 seerTagMove \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.seerService.seerTagMove(query, user);
        log.info("\u63a5\u53e3 seerTagMove \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

