/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryCreateTaskDTO;
import com.ifourthwall.dbm.sentry.bo.QueryByDataPointDTO;
import com.ifourthwall.dbm.sentry.dto.QueryByDataPointQuDTO;
import com.ifourthwall.dbm.sentry.service.MonitorMetricService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"sentry-\u70b9\u4f4d\u76f8\u5173\u63a5\u53e3"}, value="MonitorMetricController")
@RequestMapping(value={"/dbm/sentry/metric"})
public class MonitorMetricController {
    private static final Logger log = LoggerFactory.getLogger(MonitorMetricController.class);
    @Resource(name="MonitorMetricServiceImpl")
    private MonitorMetricService metricService;

    @ApiOperation(value="\u68c0\u67e5\u70b9\u4f4d\u662f\u5426\u53c8\u88ab\u4f7f\u7528", notes="\u6768\u9e4f")
    @PostMapping(value={"/check/datapoint"})
    public ResponseEntity<BaseResponse<CheckDataPointIdDTO>> checkDataPointId(@RequestBody @Valid CheckDataPointIdQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 checkDataPointId \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.metricService.checkDataPointId(query, user);
        log.info("\u63a5\u53e3 checkDataPointId \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u901a\u8fc7\u70b9\u4f4d\u67e5\u770b\u4fe1\u606f", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/by/data/point"})
    public ResponseEntity<BaseResponse<QueryByDataPointDTO>> queryByDataPoint(@Valid @RequestBody QueryByDataPointQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryByDataPoint \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.metricService.queryByDataPoint(query, user);
        log.info("\u63a5\u53e3 queryByDataPoint \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u624b\u52a8\u53d1\u8d77\u5de5\u5355", notes="\u6768\u9e4f")
    @PostMapping(value={"/create/task"})
    public ResponseEntity<BaseResponse> sentryCreateTask(@Valid @RequestBody SentryCreateTaskDTO create, IFWUser user) {
        log.info("\u63a5\u53e3 sentryCreateTask \u63a5\u53d7\u53c2\u6570:{}", (Object)create);
        BaseResponse response = this.metricService.sentryCreateTask(create, user);
        log.info("\u63a5\u53e3 sentryCreateTask \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

