/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.asset.dto.GetDataPointBasisOneQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryMonitorListDTO;
import com.ifourthwall.dbm.asset.dto.QueryTagInfoListDTO;
import com.ifourthwall.dbm.asset.dto.QueryTagInfoListQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.QueryAllDataPointQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.EnvironmentListQuDTO;
import com.ifourthwall.dbm.sentry.dto.QueryInfoByDataPointDTO;
import com.ifourthwall.dbm.sentry.dto.QueryMetricIdDTO;
import com.ifourthwall.dbm.sentry.service.MonitorAlarmService;
import com.ifourthwall.dbm.sentry.service.SeerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u544a\u8b66\u63a5\u6536"}, value="AlarmController")
@RequestMapping(value={"/dbm/ig/sentry"})
public class AlarmController {
    private static final Logger log = LoggerFactory.getLogger(AlarmController.class);
    @Resource(name="MonitorAlarmServiceImpl")
    private MonitorAlarmService alarmService;
    @Resource(name="SeerServiceImpl")
    private SeerService seerService;

    @ApiOperation(value="\u63a5\u6536\u54e5\u65af\u62c9\u544a\u8b66\u4fe1\u606f(\u63d2\u5165\u57fa\u672c\u6570\u636e)", notes="\u6768\u9e4f")
    @PostMapping(value={"/get/data/point"})
    public ResponseEntity<Map<String, Object>> getDataPoint(@RequestBody GetDataPointBasisOneQueryDTO dataPointBasis) {
        log.info("\u63a5\u53e3 getDataPoint \u63a5\u53d7\u53c2\u6570:{}", (Object)dataPointBasis);
        BaseResponse response = this.alarmService.getDataPoint(dataPointBasis);
        log.info("\u63a5\u53e3 getDataPoint \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("flag", true);
        return ResponseEntity.ok(resultMap);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u70b9\u4fe1\u606f", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/datapoint"})
    public ResponseEntity<BaseResponse<String>> datapointInfo(@RequestBody EnvironmentListQuDTO query) {
        log.info("\u63a5\u53e3 datapointInfo \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.alarmService.datapointInfo(query);
        log.info("\u63a5\u53e3 datapointInfo \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636e\u6807\u7b7e\u67e5\u8be2", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/tag/info/list"})
    public ResponseEntity<BaseResponse<List<QueryTagInfoListDTO>>> queryTagInfoList(@Valid @RequestBody QueryTagInfoListQuDTO query) {
        log.info("\u63a5\u53e3 queryTagInfoList \u63a5\u53d7\u53c2\u6570:{}");
        BaseResponse response = this.seerService.queryTagInfoList(query);
        log.info("\u63a5\u53e3 queryTagInfoList \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636e\u76d1\u63a7\u6307\u6807id\u67e5\u8be2\u76d1\u63a7\u4fe1\u606f", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/metric/id"})
    public ResponseEntity<BaseResponse<List<QueryMonitorListDTO>>> queryMetricId(@Valid @RequestBody QueryMetricIdDTO query) {
        log.info("\u63a5\u53e3 queryMetricId \u63a5\u53d7\u53c2\u6570:{}");
        BaseResponse response = this.seerService.queryMetricId(query);
        log.info("\u63a5\u53e3 queryMetricId \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636edataPointId\u67e5\u8be2\u54e5\u65af\u62c9\u4fe1\u606f", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/data/by/datepoint"})
    public ResponseEntity<BaseResponse<List<QueryInfoByDataPointDTO>>> queryByDataPoint(@Valid @RequestBody QueryMetricIdDTO query) {
        log.info("\u63a5\u53e3 queryByDataPoint \u63a5\u53d7\u53c2\u6570:{}");
        BaseResponse response = this.seerService.queryByDataPoint(query);
        log.info("\u63a5\u53e3 queryByDataPoint \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="111111111111", notes="\u6768\u9e4f")
    @PostMapping(value={"/update/rule"})
    public ResponseEntity updateRule(@Valid @RequestBody QueryAllDataPointQuDTO query) {
        BaseResponse response = this.alarmService.updateRule(query);
        return ResponseEntity.ok((Object)response);
    }
}

