package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.dbm.asset.dto.PageDTO;
import com.ifourthwall.dbm.asset.dto.SeerQueryTagQuDTO;
import com.ifourthwall.dbm.asset.dto.alertNumberDTO;
import com.ifourthwall.dbm.asset.dto.alertNumberRanking;
import com.ifourthwall.dbm.asset.dto.app.CheckMeterDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO;
import com.ifourthwall.dbm.asset.dto.seer.*;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateDTO;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateQuDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageQuDTO;
import com.ifourthwall.dbm.asset.facade.AssetAppFacade;
import com.ifourthwall.dbm.asset.facade.SentryFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.service.SentryService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.dbm.sentry.util.DateTools;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: YangPeng
 * @Date: 2020/12/28 10:05
 * @Description:
 */
@Service("SentryServiceImpl")
@Slf4j
public class SentryServiceImpl implements SentryService {

    @Autowired
    private RedisTemplate redisTemplate;

    @Resource(name = "AssetRepository")
    private AssetRepository assetRepository;

    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Reference(version = "1.0.0")
    private SentryFacade sentryFacade;

    /**
     * 折线图统计-设备异常数
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/12/28 10:05
     */
    @Override
    public BaseResponse<List<QueryLineChartDTO>> queryLineChart(QueryLineChartQuDTO query, IFWUser user) {
        BaseResponse<List<QueryLineChartDTO>> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            ArrayList<QueryLineChartDTO> resultList = new ArrayList<>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat formatHour = new SimpleDateFormat("yyyy-MM-dd HH");
            SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM");
            QueryRecordingListByTimeQuDTO queryRecording = new QueryRecordingListByTimeQuDTO();
            queryRecording.setTenantId(query.getTenantId());
            queryRecording.setProjectId(query.getProjectId());
            queryRecording.setEndTime(query.getEndTime());
            queryRecording.setStartTime(query.getStartTime());
            queryRecording.setLanguageCode(query.getLanguageCode());
            if (query.getTimeType().equals("2") || query.getTimeType().equals("3") || query.getTimeType().equals("4")) {
                //按照过去7天、过去30天、本月查询，结果均以yyyy-MM-dd返回
                queryRecording.setTimeTypeId("2");
            } else if (query.getTimeType().equals("5")) {
                //按照年查询结果以yyyy-MM返回
                queryRecording.setTimeTypeId("3");
            } else {
                //按照今日查询结果以yyyy-MM-dd HH:mm:ss 返回
                queryRecording.setTimeTypeId(query.getTimeType());
            }
            List<QueryRecordingListByTimeDTO> recordingPage = monitorRepository.queryRecordingListByTime(queryRecording);
            if ("1".equals(query.getTimeType())) {
                log.info("查询今天");
                Date dayBegin = DataUtils.getDayBegin();
                //查询这段时间内故障的设备数量

                //封装数据
                for (int i = 0; i < 24; i++) {
                    Date startDate = DateUtils.addHours(formatHour.parse(query.getStartTime()), i);
                    String resultTime = formatHour.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }

            } else if ("2".equals(query.getTimeType())) {
                log.info("查询过去7天");
                //封装数据
                for (int i = 1; i < 8; i++) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays(now, -i);
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("3".equals(query.getTimeType())) {
                log.info("查询过去30天");
                //封装数据
                for (int i = 1; i < 31; i++) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays(formatDay.parse(query.getStartTime()), -i);
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("4".equals(query.getTimeType())) {
                log.info("查询月份查询");
                //封装数据
                Date d2 = DateTools.paraseStringToDate(query.getStartTime());
                List<Date> lst4 = DateTools.getAllDaysMonthByDate(d2);
                for (Date date : lst4) {
                    String resultTime = formatDay.format(date);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("5".equals(query.getTimeType())) {
                log.info("查询年份查询");
                //封装数据
                for (int i = 0; i < 12; i++) {
                    Date startDate = DateUtils.addMonths(formatDay.parse(query.getEndTime()), -i);
                    String resultTime = formatMonth.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (recordingPage != null) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 告警次数排行
     *
     * @param rankingQuDTO
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2021/1/8 10:49
     */
    @Override
    public BaseResponse<AlertNumberRankingByDateDTO> alertNumberRankingByDate(AlertNumberRankingByDateQuDTO rankingQuDTO, IFWUser user) {
        BaseResponse<AlertNumberRankingByDateDTO> response = new BaseResponse<>();
        AlertNumberRankingByDateDTO result = new AlertNumberRankingByDateDTO();
        ArrayList<alertNumberDTO> resultList = new ArrayList<>();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String tenantId = CheckAccessUtils.judgeTenantId(rankingQuDTO.getTenantId(), user);
            rankingQuDTO.setTenantId(tenantId);
            //查询系统分类
            TranslationDoBO translationDoBO = new TranslationDoBO();
            translationDoBO.setLanguageCode(rankingQuDTO.getLanguageCode());
            AllTranslationDoBO allTranslationDoBO = assetRepository.allTranslation(translationDoBO);
            for (Map.Entry<String, String> tagIds : allTranslationDoBO.getSystem().entrySet()) {
                alertNumberDTO alertNumberRanking = new alertNumberDTO();
                alertNumberRanking.setTagName(tagIds.getValue());
                alertNumberRanking.setTagId(tagIds.getKey());
                resultList.add(alertNumberRanking);
            }
            //监控所有记录
            QueryRecordingQueryDoBO queryRecordingList = new QueryRecordingQueryDoBO();
            queryRecordingList.setProjectId(rankingQuDTO.getProjectId());
            queryRecordingList.setBeginTime(rankingQuDTO.getStartTime());
            queryRecordingList.setEndTime(rankingQuDTO.getEndTime());
            queryRecordingList.setLanguageCode(rankingQuDTO.getLanguageCode());
            queryRecordingList.setTenantId(rankingQuDTO.getTenantId());
            List<QueryRecordingListDoBO> recordingAllList = monitorRepository.queryRecordingList(queryRecordingList).getResult();
            for (alertNumberDTO tagId : resultList) {
                //当没有任何告警记录
                if (DataUtils.isListAvali(recordingAllList)) {
                    //筛选出有系统的检测对象
                    List<QueryRecordingListDoBO> collect = recordingAllList.stream().filter(a -> a.getAssetSystemId() != null).collect(Collectors.toList());
                    queryRecordingList.setAssetSystemId(tagId.getTagId());
                    //按照资产系统查询监控记录
                    List<QueryRecordingListDoBO> recordingList = monitorRepository.queryRecordingList(queryRecordingList).getResult();
                    if (DataUtils.isListAvali(recordingList)) {
                        tagId.setAlertNumber(recordingList.size());
                    } else {
                        tagId.setAlertNumber(0);
                    }
                } else {
                    tagId.setAlertNumber(0);
                }
            }
            //排序
            if (DataUtils.isListAvali(resultList)) {
                List<alertNumberDTO> collect = resultList.stream().sorted(Comparator.comparing(alertNumberDTO::getAlertNumber).reversed()).collect(Collectors.toList());
                result.setRankInfo(collect);
            } else {
                result.setRankInfo(resultList);
            }
            response.setData(result);

            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 折线图统计-设备返修率
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.seer.QueryLineChartRepairDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2021/1/11 14:20
     */
    @Override
    public BaseResponse<List<QueryLineChartRepairDTO>> queryLineChartRepair(QueryLineChartRepairQuDTO query, IFWUser user) {
        BaseResponse<List<QueryLineChartRepairDTO>> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            ArrayList<QueryLineChartRepairDTO> resultList = new ArrayList<>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat formatHour = new SimpleDateFormat("yyyy-MM-dd HH");
            SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM");
            QueryRecordingRepairQuDTO queryRecording = new QueryRecordingRepairQuDTO();
            queryRecording.setTenantId(query.getTenantId());
            queryRecording.setProjectId(query.getProjectId());
            queryRecording.setEndTime(query.getEndTime());
            queryRecording.setStartTime(query.getStartTime());
            queryRecording.setLanguageCode(query.getLanguageCode());
            if (query.getTimeType().equals("2") || query.getTimeType().equals("3") || query.getTimeType().equals("4")) {
                //按照过去7天、过去30天、本月查询，结果均以yyyy-MM-dd返回
                queryRecording.setTimeTypeId("2");
            } else if (query.getTimeType().equals("5")) {
                //按照年查询结果以yyyy-MM返回
                queryRecording.setTimeTypeId("3");
            } else {
                //按照今日查询结果以yyyy-MM-dd HH:mm:ss 返回
                queryRecording.setTimeTypeId(query.getTimeType());
            }
            List<QueryRecordingRepairDTO> recordingPage = monitorRepository.queryRecordingRepair(queryRecording);
            if ("1".equals(query.getTimeType())) {
                log.info("查询今天");
                Date dayBegin = DataUtils.getDayBegin();
                //封装数据
                for (int i = 0; i < 24; i++) {
                    Date startDate = DateUtils.addHours(formatHour.parse(query.getStartTime()), i);
                    String resultTime = formatHour.format(startDate);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }

            } else if ("2".equals(query.getTimeType())) {
                log.info("查询过去7天");
                //封装数据
                for (int i = 1; i < 8; i++) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays(formatDay.parse(query.getStartTime()), -i);
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("3".equals(query.getTimeType())) {
                log.info("查询过去30天");
                //封装数据
                for (int i = 1; i < 31; i++) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays(formatDay.parse(query.getStartTime()), -i);
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("4".equals(query.getTimeType())) {
                log.info("查询月份查询");
                //封装数据
                Date d2 = DateTools.paraseStringToDate(query.getStartTime());
                List<Date> lst4 = DateTools.getAllDaysMonthByDate(d2);
                for (Date date : lst4) {
                    String resultTime = formatDay.format(date);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("5".equals(query.getTimeType())) {
                log.info("查询年份查询");
                //封装数据
                for (int i = 0; i < 12; i++) {
                    Date startDate = DateUtils.addMonths(formatDay.parse(query.getEndTime()), -i);
                    String resultTime = formatMonth.format(startDate);
                    QueryLineChartRepairDTO queryLineChartDTO = new QueryLineChartRepairDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setRepairPercent(new BigDecimal(0));
                    if (recordingPage != null) {
                        for (QueryRecordingRepairDTO queryInfo : recordingPage) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setRepairPercent(queryInfo.getProportion());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 监测设备占比
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2021/1/12 14:30
     */
    @Override
    public BaseResponse<MonitorPercentageDTO> monitorPercentage(MonitorPercentageQuDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
        query.setTenantId(tenantId);
        return sentryFacade.monitorPercentage(query);
    }

    /**
     * seer设备统计折线图
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.QuerySeerLineChartDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2021/1/19 11:35
     */
    @Override
    public BaseResponse<QuerySeerLineChartDTO> querySeerLineChart(QuerySeerLineChartQuDTO query, IFWUser user) {
        BaseResponse<QuerySeerLineChartDTO> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            QuerySeerLineChartDTO result = new QuerySeerLineChartDTO();
            ArrayList<QueryLineChartDTO> resultList = new ArrayList<>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat formatHour = new SimpleDateFormat("yyyy-MM-dd HH");
            SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM");
            QueryRecordingListBySystemQuDTO queryRecording = new QueryRecordingListBySystemQuDTO();
            queryRecording.setTenantId(query.getTenantId());
            queryRecording.setProjectId(query.getProjectId());
            queryRecording.setEndTime(query.getEndTime());
            queryRecording.setStartTime(query.getStartTime());
            queryRecording.setLanguageCode(query.getLanguageCode());
            queryRecording.setAssetSystemId(query.getAssetSystemId());
            if (query.getTimeType().equals("2") || query.getTimeType().equals("3") || query.getTimeType().equals("4")) {
                //按照过去7天、过去30天、本月查询，结果均以yyyy-MM-dd返回
                queryRecording.setTimeTypeId("2");
            } else if (query.getTimeType().equals("5")) {
                //按照年查询结果以yyyy-MM返回
                queryRecording.setTimeTypeId("3");
            } else {
                //按照今日查询结果以yyyy-MM-dd HH:mm:ss 返回
                queryRecording.setTimeTypeId(query.getTimeType());
            }
            QueryRecordingListBySystemDTO recordingInfo = monitorRepository.queryRecordingListBySystem(queryRecording);
            result.setAlertNumber(recordingInfo.getAlertNumber());
            result.setAssetNumber(recordingInfo.getAssetNumber());
            if ("1".equals(query.getTimeType())) {
                log.info("查询今天");
                Date dayBegin = DataUtils.getDayBegin();
                //查询这段时间内故障的设备数量

                //封装数据
                for (int i = 0; i < 24; i++) {
                    Date startDate = DateUtils.addHours(formatHour.parse(query.getStartTime()), i);
                    String resultTime = formatHour.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (DataUtils.isListAvali(recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }

            } else if ("2".equals(query.getTimeType())) {
                log.info("查询过去7天");
                //封装数据
                for (int i = 1; i < 8; i++) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays(formatDay.parse(query.getStartTime()), -i);
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (DataUtils.isListAvali(recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("3".equals(query.getTimeType())) {
                log.info("查询过去30天");
                //封装数据
                for (int i = 1; i < 31; i++) {
                    Date now = new Date();
                    Date startDate = DateUtils.addDays(formatDay.parse(query.getStartTime()), -i);
                    String resultTime = formatDay.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (DataUtils.isListAvali(recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            } else if ("4".equals(query.getTimeType())) {
                log.info("查询月份查询");
                //封装数据
                Date d2 = DateTools.paraseStringToDate(query.getStartTime());
                List<Date> lst4 = DateTools.getAllDaysMonthByDate(d2);
                for (Date date : lst4) {
                    String resultTime = formatDay.format(date);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (DataUtils.isListAvali(recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
            } else if ("5".equals(query.getTimeType())) {
                log.info("查询年份查询");
                //封装数据
                for (int i = 0; i < 12; i++) {
                    Date startDate = DateUtils.addMonths(formatDay.parse(query.getEndTime()), -i);
                    String resultTime = formatMonth.format(startDate);
                    QueryLineChartDTO queryLineChartDTO = new QueryLineChartDTO();
                    queryLineChartDTO.setXCoordinate(resultTime);
                    queryLineChartDTO.setAbnormalNumber(0);
                    if (DataUtils.isListAvali(recordingInfo.getRecordingList())) {
                        for (QueryRecordingListByTimeDTO queryInfo : recordingInfo.getRecordingList()) {
                            if (resultTime.equals(queryInfo.getCreateDate())) {
                                queryLineChartDTO.setAbnormalNumber(queryInfo.getSum());
                            }
                        }
                    }
                    resultList.add(queryLineChartDTO);
                }
                Collections.reverse(resultList);
            }
            result.setLineChartInfo(resultList);
            response.setData(result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }


    public void getLineChartInfo(GetLineChartDTO query) {

    }



    public static void main(String[] args) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        String time = "14:10-15:00,14:00-14:05";
        String[] split = time.split(",");
        Date send = null;
        Date one = null;
        Date two = null;
        for (String s : split) {
            if (!StringUtils.isEmpty(s)) {
                String[] split1 = s.split("-");
                String s2 = split1[0];
                String s3 = split1[1];
                Date parse1 = format.parse(s2);
                Date parse2 = format.parse(s3);
                Date parse3 = format.parse(format.format(new Date()));

            }
        }

    }
}
