package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.dbm.asset.dto.app.CheckMeterDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListQuDTO;
import com.ifourthwall.dbm.asset.facade.AssetAppFacade;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartBO;
import com.ifourthwall.dbm.sentry.bo.QueryRuleAndStartDoBO;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.service.SentryAppService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/8/28 17:44
 * @Description:
 */
@Service("SentryAppServiceImpl")
@Slf4j
public class SentryAppServiceImpl implements SentryAppService {

    @Reference(version = "1.0.0")
    private AssetAppFacade assetAppFacade;

    @Resource(name = "AssetRepository")
    private AssetRepository assetRepository;

    @Autowired
    private GodzillaServerRepository godzillaServerRepository;


    /**
     * 通过资产查询资产及抄表信息
     *
     * @param assetList
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/8/28 17:44
     */
    @Override
    public BaseResponse<List<QueryAssetAppListDTO>> queryAssetAppList(QueryAssetAppListQuDTO assetList, IFWUser user) {
        BaseResponse<List<QueryAssetAppListDTO>> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(assetList.getTenantId(), user);
            assetList.setTenantId(tenantId);
            List<QueryAssetAppListDTO> queryAssetAppListDTOS = assetRepository.queryAssetAppList(assetList);
            if (queryAssetAppListDTOS != null) {
                for (QueryAssetAppListDTO queryAssetAppListDTO : queryAssetAppListDTOS) {
                    if (DataUtils.isListAvali(queryAssetAppListDTO.getCheckMeterInfo())) {
                        for (CheckMeterDTO checkMeterDTO : queryAssetAppListDTO.getCheckMeterInfo()) {
                            QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                            queryRuleAndStartBO.setDataPointId(checkMeterDTO.getDataPointId());
                            //查询单位
                            QueryRuleAndStartDoBO queryRuleAndStartDoBO = godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                            if (queryRuleAndStartDoBO != null) {
                                checkMeterDTO.setUnit(queryRuleAndStartDoBO.getUnit());
                            }
                        }
                    }
                }
            }
            response.setData(queryAssetAppListDTOS);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }
}
