package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingInfoDTO;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingQuDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetQuDTO;
import com.ifourthwall.dbm.asset.facade.MonitorReadingFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.meter.QueryMetricByAssetDoBO;
import com.ifourthwall.dbm.sentry.bo.meter.QueryMetricByAssetQuDoBO;
import com.ifourthwall.dbm.sentry.domain.*;
import com.ifourthwall.dbm.sentry.service.MonitorReadingService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: YangPeng
 * @Date: 2020/5/14 15:01
 * @Description:
 */
@Slf4j
@Service("MonitorReadingServiceImpl")
public class MonitorReadingServiceImpl implements MonitorReadingService {


    @Reference(version = "1.0.0")
    private MonitorReadingFacade readingFacade;

    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Resource(name = "AssetRepository")
    private AssetRepository assetRepository;

    @Resource(name = "SpaceRepository")
    private SpaceRepository spaceRepository;

    @Resource(name = "MonitorReadingRepository")
    private MonitorReadingRepository monitorReading;

    @Resource(name = "TaskRepository")
    private TaskRepository taskRepository;

    @Autowired
    private GodzillaServerRepository godzillaServerRepository;

    /**
     * tracker离线包数据-抄表
     *
     * @param trackerOffline
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/5/14 15:02
     */
    @Override
    public BaseResponse<List<TrackerMeterReadingInfoDTO>> trackerOfflineMeterReading(TrackerMeterReadingQuDTO trackerOffline, IFWUser user) {
        BaseResponse response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(trackerOffline.getTenantId(), user);
            trackerOffline.setTenantId(tenantId);
            //查询资产下绑定的抄表指标
            QueryMetricByAssetQuDoBO queryMetricByAssetQuDoBO = new QueryMetricByAssetQuDoBO();
            queryMetricByAssetQuDoBO.setType("1");
            queryMetricByAssetQuDoBO.setProjectId(trackerOffline.getProjectId());
            queryMetricByAssetQuDoBO.setLanguageCode(trackerOffline.getLanguageCode());
            queryMetricByAssetQuDoBO.setTenantId(trackerOffline.getTenantId());
            queryMetricByAssetQuDoBO.setProjectId(trackerOffline.getProjectId());
            List<QueryMetricByAssetDoBO> queryMetricByAssetDoBOS = monitorReading.queryMetricByAsset(queryMetricByAssetQuDoBO);
            if (queryMetricByAssetDoBOS != null){
                List<TrackerMeterReadingInfoDTO> resultList = IFWBeanCopyUtil.mapAsList(queryMetricByAssetDoBOS, TrackerMeterReadingInfoDTO.class);
                //查询该租户的appId
                QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
                queryAppIdQueryDoBO.setTenantId(trackerOffline.getTenantId());
                QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppIdQueryDoBO);
                if (queryAppIdBO != null){
                    List<TrackerMeterReadingInfoDTO> collect = resultList.stream().filter(a -> a.getDataPointId() != null).collect(Collectors.toList());
                    //根据dataPointId查询单位
                    for (TrackerMeterReadingInfoDTO result : collect) {
                        QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                        queryRuleAndStartBO.setDataPointId(result.getDataPointId());
                        QueryRuleAndStartDoBO queryRuleAndStartDoBO = godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                        if (queryRuleAndStartDoBO != null){
                            //判断是否有单位
                            if (!StringUtils.isEmpty(queryRuleAndStartDoBO.getUnit())){
                                result.setUnit(queryRuleAndStartDoBO.getUnit());
                            }
                        }
                        result.setAppId(queryAppIdBO.getAppId());
                    }
                }
                response.setData(resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 根据资产查询绑定指标
     *
     * @param queryMetricByAsset
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/12 10:13
     */
    @Override
    public BaseResponse<List<QueryMetricByAssetDTO>> queryMetricByAsset(QueryMetricByAssetQuDTO queryMetricByAsset, IFWUser user) {
        BaseResponse response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(queryMetricByAsset.getTenantId(), user);
            queryMetricByAsset.setTenantId(tenantId);
            //查询资产下绑定的抄表指标
            List<QueryMetricByAssetDoBO> queryMetricByAssetDoBOS = monitorReading.queryMetricByAsset(IFWBeanCopyUtil.map(queryMetricByAsset, QueryMetricByAssetQuDoBO.class));
            if (queryMetricByAssetDoBOS != null){
                List<QueryMetricByAssetDTO> resultList = IFWBeanCopyUtil.mapAsList(queryMetricByAssetDoBOS, QueryMetricByAssetDTO.class);
                response.setData(resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }
}
