package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.kafka.TopicConstants;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWUUIDUtils;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryInsertAlertIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryCreateTaskDTO;
import com.ifourthwall.dbm.asset.facade.MonitorMetricFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.constant.TaskSourceEnum;
import com.ifourthwall.dbm.sentry.domain.*;
import com.ifourthwall.dbm.sentry.dto.QueryByDataPointQuDTO;
import com.ifourthwall.dbm.sentry.service.MonitorMetricService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.kafka.IFWKafkaClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/4 09:53
 * @Description:
 */
@Service("MonitorMetricServiceImpl")
@Slf4j
public class MonitorMetricServiceImpl implements MonitorMetricService {

    @Reference(version = "1.0.0")
    private MonitorMetricFacade metricFacade;

    @Autowired
    private GodzillaServerRepository godzillaServerRepository;


    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Resource(name = "AssetRepository")
    private AssetRepository assetRepository;

    @Resource(name = "SpaceRepository")
    private SpaceRepository spaceRepository;

    @Resource(name = "MonitorReadingRepository")
    private MonitorReadingRepository monitorReading;

    @Value("${robot.system.id}")
    private String robotId;

    @Value("${robot.system.position.id}")
    private String robotPositionId;

    //手动发起工单
    @Resource(name = "IFWKafkaClient-" + TopicConstants.dbmSentryCreateTask)
    private IFWKafkaClient ifwKafkaClientCreateTask;

    /**
     * 检查点位是否又被使用
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/4 9:52
     */
    @Override
    public BaseResponse<CheckDataPointIdDTO> checkDataPointId(CheckDataPointIdQuDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
        query.setTenantId(tenantId);
        return metricFacade.checkDataPointId(query);
    }

    /**
     * 通过点位查看信息
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.sentry.bo.QueryByDataPointBO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/16 18:11
     */
    @Override
    public BaseResponse<QueryByDataPointDTO> queryByDataPoint(QueryByDataPointQuDTO query, IFWUser user) {
        BaseResponse<QueryByDataPointDTO> response = new BaseResponse<>();
        try {
            QueryByDataPointDTO result = new QueryByDataPointDTO();
            String tenantId = CheckAccessUtils.judgeTenantId(null, user);
            //查询监控对象
            queryDataPointIdQuBO queryDataByMonitorQuDoBO = new queryDataPointIdQuBO();
            queryDataByMonitorQuDoBO.setDataPointId(query.getDataPointId());
            queryDataByMonitorQuDoBO.setTenantId(tenantId);
            queryDataByMonitorQuDoBO.setLanguageCode("CN");
            queryDataPointIdBO queryDataByMonitorDoBO = monitorRepository.queryDataPointId(queryDataByMonitorQuDoBO);
            QueryAssetByDPDoQuBO queryAsset = new QueryAssetByDPDoQuBO();
            queryAsset.setDataPointId(query.getDataPointId());
            QueryAssetByDPDoBO asset = monitorRepository.queryAssetByDP(queryAsset);
            if (asset != null) {
                //查询资产信息
                AssetInfoQueryDoBO assetInfoQueryDoBO = new AssetInfoQueryDoBO();
                assetInfoQueryDoBO.setAssetId(asset.getAssetId());
                assetInfoQueryDoBO.setLanguageCode("CN");
                QueryAssetInfoDoBO queryAssetInfoDoBO = assetRepository.queryAssetInfo(assetInfoQueryDoBO);
                if (queryAssetInfoDoBO != null) {
                    result.setAssetName(queryAssetInfoDoBO.getAssetName());
                }
                //查询空间名称
                GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
                ArrayList<String> spaceIds = new ArrayList<>();
                spaceIds.add(queryAssetInfoDoBO.getProjectSpaceId());
                getNewPathBatchQueryBO.setProjectSpaceId(spaceIds);
                getNewPathBatchQueryBO.setProjectId(queryAssetInfoDoBO.getProjectId());
                getNewPathBatchQueryBO.setLanguageCode("CN");
                getNewPathBatchQueryBO.setTenantId(tenantId);
                List<ProjectSpacePathBO> newPathBatch = spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
                if (newPathBatch != null) {
                    result.setSpaceName(newPathBatch.get(0).getNameStr());
                }
                result.setMetricName(queryDataByMonitorDoBO.getMonitorMetricName());
            }
            //表头

            //查询appID
            QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
            queryAppIdQueryDoBO.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppIdQueryDoBO);
            if (queryAppIdBO != null) {
                //查询指标
                MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                metricValueRecordListReqBO.setDataPointId(query.getDataPointId());
                metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
                metricValueRecordListReqBO.setStartTime(query.getStartTime());
                metricValueRecordListReqBO.setEndTime(query.getEndTime());
                MetricValueRecordListBO metricValueRecordListBO = godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                if (metricValueRecordListBO != null) {
                    List<QueryByDataPointBasicBO> queryByDataPointBasicBOS = IFWBeanCopyUtil.mapAsList(metricValueRecordListBO.getCollectDataList(), QueryByDataPointBasicBO.class);
                    result.setMetricValueInfo(queryByDataPointBasicBOS);
                    //查询单位
                    QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                    queryRuleAndStartBO.setDataPointId(query.getDataPointId());
                    QueryRuleAndStartDoBO queryRuleAndStartDoBO = godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                    if (queryRuleAndStartDoBO != null) {
                        result.setUnit(queryRuleAndStartDoBO.getUnit());
                    }
                }
            }
            result.setDataPointId(query.getDataPointId());
            response.setData(result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 手动发起工单
     *
     * @param create
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/10/26 10:19
     */
    @Override
    public BaseResponse sentryCreateTask(SentryCreateTaskDTO create, IFWUser user) {
        BaseResponse response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(create.getTenantId(), user);
            //如果告警id为空，需要创建
            String alertId = null;
            if (!StringUtils.isEmpty(create.getAlertId())){
                alertId = create.getAlertId();
            }else{
                alertId = IFWUUIDUtils.randomUUID();
                //创建完以后需要插入数据库
                SentryInsertAlertIdDTO insertAlertIdDTO = new SentryInsertAlertIdDTO();
                insertAlertIdDTO.setAlertId(alertId);
                insertAlertIdDTO.setMonitorRecordId(create.getMonitorRecordId());
                insertAlertIdDTO.setMonitorTargetId(create.getMonitorTargetId());
                insertAlertIdDTO.setUpdateBy(user.getUserId());
                monitorReading.insertAlertId(insertAlertIdDTO);
            }
            //查询空间
            GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
            ArrayList<String> ids = new ArrayList<>();
            ids.add(create.getSpaceId());
            getNewPathBatchQueryBO.setProjectSpaceId(ids);
            getNewPathBatchQueryBO.setProjectId(create.getProjectId());
            getNewPathBatchQueryBO.setLanguageCode("CN");
            getNewPathBatchQueryBO.setTenantId(create.getTenantId());
            List<ProjectSpacePathBO> newPathBatch = spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
            if (DataUtils.isListAvali(newPathBatch)) {
                KafkaAlertBO kafkaAlertBO = new KafkaAlertBO();
                CreateTaskQueryDTO query1 = new CreateTaskQueryDTO();
                TaskInsertDoBO taskQuery = new TaskInsertDoBO();
                ArrayList<TaskSpaceInsertBO> taskSpaceInfo = new ArrayList<>();
                TaskSpaceInsertBO taskSpace = new TaskSpaceInsertBO();
                taskSpace.setSpaceId(create.getSpaceId());
                taskSpace.setTaskSpaceDescription(newPathBatch.get(0).getNameStr());
                taskSpaceInfo.add(taskSpace);
                ArrayList<String> operatingId = new ArrayList<>();
                operatingId.add(robotPositionId);
                taskQuery.setCreateByPositionId(robotPositionId);
                taskQuery.setTenantId(create.getTenantId());
                taskQuery.setProjectId(create.getProjectId());
                taskQuery.setTaskTypeId("1");
                taskQuery.setCreateBy(user.getUserId());
                taskQuery.setTaskTemplateId(create.getTaskTemplateId());
                //中文模板
                taskQuery.setTaskName(create.getTaskName());
                taskQuery.setTaskDescription(create.getTaskDescription());
                taskQuery.setCreateByPositionId(robotPositionId);
                taskQuery.setTaskSource(TaskSourceEnum.SENTRY.getId());
                query1.setTask(taskQuery);
                ArrayList<String> assetIds = new ArrayList<>();
                query1.setAssetIdList(assetIds);
                //往kafka扔消息
                kafkaAlertBO.setAlertId(alertId);
                kafkaAlertBO.setTaskBO(query1);
                kafkaAlertBO.getTaskBO().setTaskSpaceList(taskSpaceInfo);
                String sendInfo = JSONUtils.jacksonToJson(kafkaAlertBO);
                log.info("自动创建工单，kafka发送数据" + sendInfo);
                ifwKafkaClientCreateTask.syncProduce(sendInfo);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());

            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }
}
