package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingQuDTO;
import com.ifourthwall.dbm.asset.dto.godzilla.*;
import com.ifourthwall.dbm.asset.dto.seer.QueryInductionDTO;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.godzilla.QueryRuleBO;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.service.MonitorGodzillaService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: YangPeng
 * @Date: 2020/8/25 11:19
 * @Description:
 */
@Slf4j
@Service("MonitorGodzillaServiceImpl")
public class MonitorGodzillaServiceImpl implements MonitorGodzillaService {

    @Autowired
    private GodzillaServerRepository godzillaServerRepository;


    /**
     * 新增触发规则
     *
     * @param add
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/8/25 11:23
     */
    @Override
    public BaseResponse addMaxAndMin(AddMaxAndMinDTO add, IFWUser user) {
        BaseResponse response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(add.getTenantId(), user);
            AddMaxAndMinBO addINfo = IFWBeanCopyUtil.map(add, AddMaxAndMinBO.class);
            //分钟转毫秒
            addINfo.setCompareDuration(add.getCompareDuration() * 60 * 1000);
            godzillaServerRepository.addMaxAndMin(addINfo);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 修改触发规则
     *
     * @param update
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/8/25 11:23
     */
    @Override
    public BaseResponse updateMaxAndMin(UpdateMaxAndMinDTO update, IFWUser user) {
        BaseResponse response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(update.getTenantId(), user);
            UpdateMaxAndMinBO updateInfo = IFWBeanCopyUtil.map(update, UpdateMaxAndMinBO.class);
            //分钟转毫秒
            updateInfo.setCompareDuration(update.getCompareDuration() * 60 * 1000);
            godzillaServerRepository.updateMaxAndMin(updateInfo);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 删除触发规则
     *
     * @param delete
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/8/25 11:23
     */
    @Override
    public BaseResponse deleteMaxAndMin(DeleteMaxAndMinDTO delete, IFWUser user) {
        BaseResponse<QueryInductionDTO> response = new BaseResponse<>();
        QueryInductionDTO result = new QueryInductionDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(delete.getTenantId(), user);
            godzillaServerRepository.deleteMaxAndMin(IFWBeanCopyUtil.map(delete, DeleteMaxAndMinBO.class));
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 查询触发规则
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.godzilla.QueryMaxAndMinDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/8/25 11:23
     */
    @Override
    public BaseResponse<List<QueryMaxAndMinDTO>> queryMaxAndMin(QueryMaxAndMinQuDTO query, IFWUser user) {
        BaseResponse<List<QueryMaxAndMinDTO>> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            List<QueryRuleBO> queryRuleBOS = godzillaServerRepository.queryRule(IFWBeanCopyUtil.map(query, QueryRuleAndStartBO.class));
            if (queryRuleBOS != null){
                List<QueryMaxAndMinDTO> resultList = IFWBeanCopyUtil.mapAsList(queryRuleBOS, QueryMaxAndMinDTO.class);
                //毫秒转分钟
                for (QueryMaxAndMinDTO result : resultList) {
                    int i = result.getCompareDuration() / (60 * 1000);
                    if (i >= 0){
                        result.setCompareDuration(result.getCompareDuration()/(60 * 1000));
                    }
                }
                response.setData(resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }


    public static void main(String[] args) throws ParseException {
//        String a = "03:05-06:06,06:07-23:05";
//        String[] split = a.split(",");
//        for (String s : split) {
//            String[] split1 = s.split("-");
//            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
//            int length = split1.length;
//            System.out.println(length);
//            for (String s1 : split1) {
//                Date parse = format.parse(s1);
//                long time = parse.getTime();
//                System.out.println(time);
//                System.out.println(parse);
//            }
//        }
        String a = "\u0000";
        if (a == null){
            System.out.println("为空");
        }else {
            System.out.println("不为空");

        }
    }
}
